/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellDataType;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import org.apache.poi.xssf.model.SharedStringsTable;

public class BooleanCellInfo
extends CellInfo {
    private Boolean rawValue;

    public BooleanCellInfo() {
        this.setCellDataType(CellDataType.BOOL);
    }

    @Override
    public String getDataTypeClassName() {
        return "java.lang.Boolean";
    }

    @Override
    public void initRawValue(SharedStringsTable sharedStringsTable) {
        char first = this.getCellOriginalValue().charAt(0);
        this.rawValue = first == '0' ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    protected String getFormateString() {
        return this.rawValue.toString();
    }

    @Override
    protected CellInfo newInstance() {
        BooleanCellInfo cellInfo = new BooleanCellInfo();
        cellInfo.rawValue = this.rawValue;
        return cellInfo;
    }

    @Override
    public Object getRawValue() {
        return this.rawValue;
    }

    @Override
    protected Boolean getBooleanValue() throws ParseException {
        return this.rawValue;
    }

    @Override
    protected BigDecimal getBigInt() throws ParseException {
        return this.rawValue != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    protected BigDecimal getNumericValue() throws ParseException {
        return this.rawValue != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    protected Long getLongValue() throws ParseException {
        return this.rawValue != false ? Long.valueOf(1L) : Long.valueOf(0L);
    }
}

