/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.unionsource;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.data.exception.file.qs.QSFileWriteException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.BizUnionInnerEntityRelations;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.runtime.ISubjectEntityExtractDataCallBack;
import com.kingdee.bos.qing.data.model.runtime.ISubjectPrepareDataCallBack;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityExtractContext {
    private IQingFile dataFile;
    private Map<String, AbstractSource> sourcesMap;
    private Map<String, AbstractEntity> entityNamesMap;
    private QingContext qingContext;
    private String ownerId;
    private ISubjectPrepareDataCallBack callBackFunction;
    private StringBuilder warmingMsgBuilder = new StringBuilder();
    private List<Relation> relations = new ArrayList<Relation>();
    private Map<Entity, IQingFileVisitor> readQingFileMap = new HashMap<Entity, IQingFileVisitor>();
    private ISubjectEntityExtractDataCallBack subjectEntityExtractDataCallBack;
    private Map<Entity, IQingFile> writeQingFileMap = new HashMap<Entity, IQingFile>();
    private String themeId;
    private Set<String> whitePropertySet;
    private Entity qsEntity;
    private List<BizUnionInnerEntityRelations> bizUnionInnerEntityRelations;
    private List<ColumnToRowProperty> columnToRowProperties;

    public List<ColumnToRowProperty> getColumnToRowProperties() {
        return this.columnToRowProperties;
    }

    public void setColumnToRowProperties(List<ColumnToRowProperty> columnToRowProperties) {
        this.columnToRowProperties = columnToRowProperties;
    }

    public Entity getQsEntity() {
        return this.qsEntity;
    }

    public void setQsEntity(Entity qsEntity) {
        this.qsEntity = qsEntity;
    }

    public ISubjectEntityExtractDataCallBack getSubjectEntityExtractDataCallBack() {
        return this.subjectEntityExtractDataCallBack;
    }

    public List<BizUnionInnerEntityRelations> getBizUnionInnerEntityRelations() {
        return this.bizUnionInnerEntityRelations;
    }

    public void setBizUnionInnerEntityRelations(List<BizUnionInnerEntityRelations> bizUnionInnerEntityRelations) {
        this.bizUnionInnerEntityRelations = bizUnionInnerEntityRelations;
    }

    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public void setReadQingFileMap(Map<Entity, IQingFileVisitor> readQingFileMap) {
        this.readQingFileMap = readQingFileMap;
    }

    public void setSubjectEntityExtractDataCallBack(ISubjectEntityExtractDataCallBack subjectEntityExtractDataCallBack) {
        this.subjectEntityExtractDataCallBack = subjectEntityExtractDataCallBack;
    }

    public IQingFile getWriteQingFile(Entity entity) {
        return this.writeQingFileMap.get(entity);
    }

    public void putWriteQingFile(Entity entity, IQingFile qingFile) {
        this.writeQingFileMap.put(entity, qingFile);
    }

    public IQingFileVisitor getReadQingFile(Entity entity) {
        return this.readQingFileMap.get(entity);
    }

    public Map<String, AbstractSource> getSourcesMap() {
        return this.sourcesMap;
    }

    public List<Relation> getRelations(String entityName) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (Relation relation : this.relations) {
            if (!relation.getFromEntity().equalsIgnoreCase(entityName) && !relation.getToEntity().equalsIgnoreCase(entityName)) continue;
            result.add(relation);
        }
        return result;
    }

    public boolean existRelation(String entityName) {
        for (Relation relation : this.relations) {
            if (!relation.getFromEntity().equalsIgnoreCase(entityName) && !relation.getToEntity().equalsIgnoreCase(entityName)) continue;
            return true;
        }
        return false;
    }

    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    public ISubjectPrepareDataCallBack getCallBackFunction() {
        return this.callBackFunction;
    }

    public void setCallBackFunction(ISubjectPrepareDataCallBack callBackFunction) {
        this.callBackFunction = callBackFunction;
    }

    public IQingFile getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(IQingFile dataFile) {
        this.dataFile = dataFile;
    }

    public void setSourcesMap(Map<String, AbstractSource> sourcesMap) {
        this.sourcesMap = sourcesMap;
    }

    public Map<String, AbstractEntity> getEntityNamesMap() {
        return this.entityNamesMap;
    }

    public void setEntityNamesMap(Map<String, AbstractEntity> entityNamesMap) {
        this.entityNamesMap = entityNamesMap;
    }

    public QingContext getQingContext() {
        return this.qingContext;
    }

    public void setQingContext(QingContext qContext) {
        this.qingContext = qContext;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public AbstractSource getSource(String sourceName) {
        return this.sourcesMap.get(sourceName);
    }

    public AbstractEntity getEntity(String entityName) {
        return this.entityNamesMap.get(entityName);
    }

    public ProgressProcessor newProgress() {
        if (this.callBackFunction != null) {
            return this.callBackFunction.startOneEntity();
        }
        return new ProgressProcessor(-1L);
    }

    public void addWarmingMsg(String msg) {
        if (null != msg) {
            this.warmingMsgBuilder.append(msg);
        }
    }

    public String getWarmingMsg() {
        return this.warmingMsgBuilder.toString();
    }

    public void setWhitePropertySet(Set<String> whitePropertySet) {
        this.whitePropertySet = whitePropertySet;
    }

    public Set<String> getWhitePropertySet() {
        return this.whitePropertySet;
    }

    public String getEntityUniqueKey(AbstractSource source, Entity entity) {
        if (this.subjectEntityExtractDataCallBack != null) {
            return this.subjectEntityExtractDataCallBack.getEntityUniqueKey(source, entity);
        }
        return null;
    }

    public Object getQSFileWriterOrVisitor(AbstractSource source, Entity entity, String fromId) throws AbstractQingIntegratedException, SQLException {
        if (this.subjectEntityExtractDataCallBack != null) {
            return this.subjectEntityExtractDataCallBack.getQSFileWriterOrVisitor(this.qingContext, source, entity, fromId, this);
        }
        return null;
    }

    public void addQSFile(IQingFile writeQingFile, AbstractSource source, Entity entity) {
        if (this.subjectEntityExtractDataCallBack != null) {
            this.subjectEntityExtractDataCallBack.addQSFile(this.qingContext, writeQingFile, source, entity, this.themeId);
        }
    }

    public Entity getSourceEntity(DesigntimeDataObject designtimeDataObject, Entity entity) {
        if (this.subjectEntityExtractDataCallBack != null) {
            return this.subjectEntityExtractDataCallBack.getSourceEntity(designtimeDataObject, entity);
        }
        return null;
    }

    public void setConvertingQSFlagToCache(String themeId, String fileUrl, String entityName) throws QingLockRequireException, InterruptedException {
        if (this.subjectEntityExtractDataCallBack != null) {
            this.subjectEntityExtractDataCallBack.setConvertingQSFlagToCache(themeId, fileUrl, entityName);
        }
    }

    public void removeConvertingQSFlagFromCache(String themeId, String fileUrl, String entityName) throws QingLockRequireException, InterruptedException {
        if (this.subjectEntityExtractDataCallBack != null) {
            this.subjectEntityExtractDataCallBack.removeConvertingQSFlagFromCache(themeId, fileUrl, entityName);
        }
    }

    public void initReadQingFileVisitor(AbstractEntity abstractEntity) throws QSFileWriteException {
        if (this.subjectEntityExtractDataCallBack != null) {
            this.subjectEntityExtractDataCallBack.initReadQingFileVisitor(abstractEntity, this);
        }
    }
}

