/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.unionsource.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.domain.unionsource.WhitePropertyUtil;
import com.kingdee.bos.qing.data.domain.unionsource.impl.AbstractEntityDataService;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.util.EntityErrorHelper;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Map;
import java.util.Set;

public class SimpleEntityDataService
extends AbstractEntityDataService {
    private Entity entity;

    public SimpleEntityDataService(Entity entity) {
        this.entity = entity;
    }

    @Override
    public String extractEntityData(EntityExtractContext context) throws AbstractSourceException, AbstractQingIntegratedException, DataSourcePersistenceException, InterruptedException, QingLockRequireException {
        Throwable exception = null;
        QSDataSourceWriter dataSourceWriter = new QSDataSourceWriter(context.getDataFile());
        try {
            Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(this.entity, context.getRelations(this.entity.getName()));
            context.setWhitePropertySet(whitePropertySet);
            AbstractSource source = context.getSource(this.entity.getSource());
            AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomain(source);
            RuntimeEntity runtimeEntity = domain.newRuntimeEntity(this.entity, context.getEntityNamesMap(), whitePropertySet, source, context.getQingContext(), context.getOwnerId());
            runtimeEntity.init(null);
            domain.addDataSourceCloseListener((IDataSourceWriter)dataSourceWriter, runtimeEntity);
            LogUtil.info((String)("record qs file with entity name relation info,fileName:" + context.getDataFile().getName() + ",entityName:" + this.entity.getAssociateName() + ",alias:" + this.entity.getAlias() + ",userId:" + context.getOwnerId()));
            dataSourceWriter.start(runtimeEntity.getMetaInfo());
            context.setQsEntity(this.entity);
            runtimeEntity.setEntityExtractContext(context);
            String result = domain.extractData(context.getQingContext(), (IDataSourceWriter)dataSourceWriter, runtimeEntity, context.newProgress());
            dataSourceWriter.finishWriteData();
            String string = result;
            return string;
        }
        catch (AbstractSourceException e) {
            exception = e;
            throw e;
        }
        catch (DataSourcePersistenceException e) {
            exception = e;
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            exception = e;
            throw e;
        }
        finally {
            dataSourceWriter.close((Exception)exception);
        }
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, int previewRows, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        AbstractSource foundSource = sources.getSource(this.entity.getSource());
        if (foundSource != null) {
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(foundSource);
            FixProcesser.fixEntityForPreview(qingContext, (AbstractEntity)this.entity, foundSource, entities.getEntities());
            if (EntityErrorHelper.isErrorExist(this.entity)) {
                PreviewDataModel errorPreview = new PreviewDataModel();
                EntityErrorInfo errorInfo = this.entity.getErrorInfo();
                errorInfo.setEntityName(this.entity.getName());
                errorPreview.setEntityErrorInfo(errorInfo);
                return errorPreview;
            }
            RuntimeEntity runtimeEntity = sourceDomain.newRuntimeEntity(this.entity, entities.getEntityMap(), null, foundSource, qingContext, qingContext.getUserId());
            runtimeEntity.init(null);
            EntityExtractContext entityExtractContext = new EntityExtractContext();
            entityExtractContext.setQsEntity(this.entity);
            entityExtractContext.setReadQingFileMap(qingFileVisitorMap);
            runtimeEntity.setEntityExtractContext(entityExtractContext);
            PreviewDataModel dataModel = sourceDomain.getPreviewData(qingContext, runtimeEntity, previewRows);
            this.fillOtherPreviewInfo(this.entity, qingContext, dataModel);
            return dataModel;
        }
        throw new IllegalArgumentException(this.entity.getSource() + " source not found.");
    }

    @Override
    public long getDataCount(QingContext qingContext, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        AbstractSource foundSource = sources.getSource(this.entity.getSource());
        if (foundSource != null) {
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(foundSource);
            FixProcesser.fixEntityForPreview(qingContext, (AbstractEntity)this.entity, foundSource, entities.getEntities());
            RuntimeEntity runtimeEntity = sourceDomain.newRuntimeEntity(this.entity, entities.getEntityMap(), null, foundSource, qingContext, qingContext.getUserId());
            runtimeEntity.init(null);
            EntityExtractContext entityExtractContext = new EntityExtractContext();
            entityExtractContext.setQsEntity(this.entity);
            entityExtractContext.setReadQingFileMap(qingFileVisitorMap);
            runtimeEntity.setEntityExtractContext(entityExtractContext);
            return sourceDomain.getDataCount(qingContext, runtimeEntity);
        }
        throw new IllegalArgumentException(this.entity.getSource() + " source not found.");
    }
}

