/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.unionsource.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.domain.unionsource.WhitePropertyUtil;
import com.kingdee.bos.qing.data.domain.unionsource.impl.AbstractEntityDataService;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.BizUnionInnerEntityRelations;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.data.model.vo.Entites;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.util.EntityErrorHelper;
import com.kingdee.bos.qing.data.util.EntityNameKeySelector;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnionEntityDataService
extends AbstractEntityDataService {
    private UnionEntity unionEntity;

    public UnionEntityDataService(UnionEntity unionEntity) {
        this.unionEntity = unionEntity;
    }

    @Override
    public String extractEntityData(EntityExtractContext context) throws AbstractSourceException, AbstractDataSourceException, AbstractQingIntegratedException, InterruptedException, QingLockRequireException {
        TraceSpan traceSpan = null;
        Throwable exception = null;
        QSDataSourceWriter dataSourceWriter = new QSDataSourceWriter(context.getDataFile());
        try {
            traceSpan = this.createDataExtractTrace();
            switch (this.unionEntity.getEntityType()) {
                case BIZ_UNION: {
                    this.extractBizUnionEntity(context, dataSourceWriter);
                    break;
                }
                case COMMON_UNION: {
                    this.extractCommonUnionEntity(context, dataSourceWriter);
                    break;
                }
                default: {
                    throw new UnSupportDataSourceException("union entity type can not be Single");
                }
            }
            String string = context.getWarmingMsg();
            return string;
        }
        catch (AbstractSourceException e) {
            exception = e;
            throw e;
        }
        catch (DataSourcePersistenceException e) {
            exception = e;
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            exception = e;
            throw e;
        }
        catch (AbstractDataSourceException e) {
            exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            exception = e;
            throw e;
        }
        catch (QingLockRequireException e) {
            exception = e;
            throw e;
        }
        finally {
            dataSourceWriter.close((Exception)exception);
            TracerUtil.close((TraceSpan)traceSpan);
        }
    }

    private void extractBizUnionEntity(EntityExtractContext context, QSDataSourceWriter dataSourceWriter) throws AbstractDataSourceException, AbstractSourceException, AbstractQingIntegratedException, QingLockRequireException, InterruptedException {
        UnionEntity bizRootUnionEntity = this.findBizRootUnionEntity(this.unionEntity, context.getEntityNamesMap());
        List<Relation> entityUnitInnerRelations = this.getBizUnionEntityInnerRelations(context, bizRootUnionEntity.getName());
        AbstractSource source = context.getSource(this.unionEntity.getChildren().get(0).getSource());
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        RuntimeEntity runtimeEntity = sourceDomain.newRuntimeEntity(this.unionEntity, null, null, source, context.getQingContext(), context.getOwnerId());
        runtimeEntity.init(null);
        sourceDomain.addDataSourceCloseListener((IDataSourceWriter)dataSourceWriter, runtimeEntity);
        dataSourceWriter.start(runtimeEntity.getMetaInfo());
        ProgressProcessor progress = context.newProgress();
        for (Entity childEntity : this.unionEntity.getChildren()) {
            Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(childEntity, entityUnitInnerRelations);
            RuntimeEntity subRuntimeEntity = runtimeEntity.getSubRuntimeEntity(childEntity.getName(), whitePropertySet);
            this.extractOneBizEntityChild(context, subRuntimeEntity, dataSourceWriter, progress, childEntity);
        }
        dataSourceWriter.finishWriteData();
    }

    private List<Relation> getBizUnionEntityInnerRelations(EntityExtractContext context, String rootUnionEntityName) {
        List<BizUnionInnerEntityRelations> innerRelations = context.getBizUnionInnerEntityRelations();
        if (null == innerRelations) {
            return Collections.emptyList();
        }
        for (BizUnionInnerEntityRelations br : innerRelations) {
            if (!br.getRootUnionEntityName().equals(rootUnionEntityName)) continue;
            return br.getRelations();
        }
        return Collections.emptyList();
    }

    private void extractOneBizEntityChild(EntityExtractContext context, RuntimeEntity unitRuntimeEntity, QSDataSourceWriter dataSourceWriter, ProgressProcessor progress, Entity unionUnit) throws AbstractSourceException, DataSourcePersistenceException, AbstractQingIntegratedException, QingLockRequireException, InterruptedException {
        UnionEntity bizRootUnionEntity = this.findBizRootUnionEntity(this.unionEntity, context.getEntityNamesMap());
        int unionLocation = unionUnit.getUnionLocation();
        Entity rootEntityUnit = bizRootUnionEntity.getChildren().get(unionLocation);
        AbstractSource source = context.getSource(unionUnit.getSource());
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        unitRuntimeEntity.init(null);
        unitRuntimeEntity.setRootEntity(rootEntityUnit);
        context.setQsEntity(unionUnit);
        unitRuntimeEntity.setEntityExtractContext(context);
        String warmingMsg = sourceDomain.extractData(context.getQingContext(), (IDataSourceWriter)dataSourceWriter, unitRuntimeEntity, progress);
        context.addWarmingMsg(warmingMsg);
    }

    private void extractCommonUnionEntity(EntityExtractContext context, QSDataSourceWriter dataSourceWriter) throws AbstractQingIntegratedException, AbstractDataSourceException, AbstractSourceException, InterruptedException, QingLockRequireException {
        Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(this.unionEntity, context.getRelations(this.unionEntity.getName()));
        RuntimeEntity runtimeEntity = new RuntimeEntity(this.unionEntity, null, null, context.getQingContext(), context.getOwnerId());
        runtimeEntity.init(null);
        dataSourceWriter.start(runtimeEntity.getMetaInfo());
        ProgressProcessor progress = context.newProgress();
        List<ColumnToRowProperty> columnToRowProperties = this.unionEntity.getColumnToRowProperties();
        context.setColumnToRowProperties(columnToRowProperties);
        for (Entity childEntity : this.unionEntity.getChildren()) {
            this.extractOneChildEntityData(context, whitePropertySet, dataSourceWriter, progress, childEntity);
        }
        context.setColumnToRowProperties(null);
        dataSourceWriter.finishWriteData();
    }

    private TraceSpan createDataExtractTrace() {
        TraceSpan traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"mergeDataTable", (String)"\u5408\u5e76\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + this.unionEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
        traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
        traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), this.unionEntity.getName());
        traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), this.unionEntity.getAlias());
        return traceSpan;
    }

    private void extractOneChildEntityData(EntityExtractContext context, Set<String> whitePropertySet, QSDataSourceWriter dataSourceWriter, ProgressProcessor progress, Entity unionUnit) throws AbstractQingIntegratedException, AbstractDataSourceException, AbstractSourceException, InterruptedException, QingLockRequireException {
        AbstractSource source = context.getSource(unionUnit.getSource());
        QingContext qingContext = context.getQingContext();
        AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
        RuntimeEntity unitRuntimeEntity = sourceDomain.newRuntimeEntity(unionUnit, null, whitePropertySet, source, qingContext, context.getOwnerId());
        unitRuntimeEntity.init(null);
        context.setWhitePropertySet(whitePropertySet);
        context.setQsEntity(unionUnit);
        unitRuntimeEntity.setEntityExtractContext(context);
        String warmingMsg = sourceDomain.extractData(context.getQingContext(), (IDataSourceWriter)dataSourceWriter, unitRuntimeEntity, progress);
        context.addWarmingMsg(warmingMsg);
    }

    private UnionEntity findBizRootUnionEntity(UnionEntity current, Map<String, AbstractEntity> entityMap) {
        UnionEntity temp;
        String parentName = current.getParentName();
        UnionEntity parent = current;
        while (null != parentName && null != (temp = (UnionEntity)entityMap.get(parentName))) {
            parentName = temp.getParentName();
            parent = temp;
        }
        return parent;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, int previewRows, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        int reservedRows = previewRows;
        FixProcesser.fixEntityForPreview(qingContext, (AbstractEntity)this.unionEntity, sources.getSources(), entities.getEntities());
        if (this.unionEntity.getChildren().isEmpty()) {
            throw new UnSupportDataSourceException("table not exist");
        }
        List<Entity> errorExistEntity = this.getErrorExistEntity();
        if (errorExistEntity.size() != 0) {
            String errorDescInfo = "";
            for (int i = 0; i < errorExistEntity.size(); ++i) {
                Entity errorEntity = errorExistEntity.get(i);
                errorEntity.getErrorInfo().setEntityName(errorEntity.getName());
                EntityErrorInfo entityErrorInfo = errorEntity.getErrorInfo();
                String errorDesc = errorEntity.getName() + "\uff1a" + entityErrorInfo.getErrorDesc();
                errorDescInfo = errorDescInfo + (i != errorExistEntity.size() - 1 ? errorDesc + "\uff1b" : errorDesc);
            }
            this.unionEntity.getErrorInfo().setEntityName(this.unionEntity.getName());
            this.unionEntity.getErrorInfo().setErrorDesc(errorDescInfo);
            PreviewDataModel previewDataModel = new PreviewDataModel();
            previewDataModel.setEntityErrorInfo(this.unionEntity.getErrorInfo());
            return previewDataModel;
        }
        switch (this.unionEntity.getEntityType()) {
            case BIZ_UNION: {
                return this.getBizUnionPreviewData(qingContext, previewRows, entities, sources, qingFileVisitorMap, reservedRows);
            }
            case COMMON_UNION: {
                return this.getCommonUnionPreviewData(qingContext, previewRows, sources, qingFileVisitorMap, reservedRows);
            }
        }
        throw new UnSupportDataSourceException("union entity type can not be Single");
    }

    private List<Entity> getErrorExistEntity() {
        ArrayList<Entity> errorEntityList = new ArrayList<Entity>(this.unionEntity.getChildren().size());
        for (Entity entity : this.unionEntity.getChildren()) {
            if (!EntityErrorHelper.isErrorExist(entity)) continue;
            errorEntityList.add(entity);
        }
        return errorEntityList;
    }

    private PreviewDataModel getBizUnionPreviewData(QingContext qingContext, int previewRows, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap, int reservedRows) throws AbstractSourceException, AbstractQingIntegratedException {
        PreviewDataModel unionEntityPreviewData = new PreviewDataModel(new ArrayList<Object[]>());
        List<Entity> children = this.unionEntity.getChildren();
        Map entityMap = MapUtils.collectionToMap(entities.getEntities(), (MapUtils.IMapKeySelector)new EntityNameKeySelector());
        UnionEntity bizRootUnionEntity = this.findBizRootUnionEntity(this.unionEntity, entityMap);
        EntityExtractContext context = new EntityExtractContext();
        context.setQingContext(qingContext);
        context.setReadQingFileMap(qingFileVisitorMap);
        for (Entity entity : children) {
            AbstractSource source = sources.getSource(entity.getSource());
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            RuntimeEntity unitRuntimeEntity = sourceDomain.newRuntimeEntity(entity, null, null, source, qingContext, context.getOwnerId());
            unitRuntimeEntity.init(null);
            context.setQsEntity(entity);
            int unionLocation = entity.getUnionLocation();
            Entity rootEntity = bizRootUnionEntity.getChildren().get(unionLocation);
            unitRuntimeEntity.setRootEntity(rootEntity);
            unitRuntimeEntity.setEntityExtractContext(context);
            if (this.containNotExistedFieldFilter(unitRuntimeEntity)) continue;
            PreviewDataModel result = sourceDomain.getPreviewData(qingContext, unitRuntimeEntity, reservedRows);
            unionEntityPreviewData.getData().addAll(result.getData());
            reservedRows = previewRows - unionEntityPreviewData.getData().size();
            if (reservedRows > 0) continue;
            break;
        }
        this.fillOtherPreviewInfo(this.unionEntity, qingContext, unionEntityPreviewData);
        return unionEntityPreviewData;
    }

    private PreviewDataModel getCommonUnionPreviewData(QingContext qingContext, int previewRows, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap, int reservedRows) throws AbstractSourceException, AbstractQingIntegratedException {
        PreviewDataModel unionEntityPreviewData = new PreviewDataModel(new ArrayList<Object[]>());
        List<Entity> children = this.unionEntity.getChildren();
        EntityExtractContext context = new EntityExtractContext();
        context.setQingContext(qingContext);
        context.setReadQingFileMap(qingFileVisitorMap);
        List<ColumnToRowProperty> columnToRowProperties = this.unionEntity.getColumnToRowProperties();
        context.setColumnToRowProperties(columnToRowProperties);
        for (Entity entity : children) {
            AbstractSource source = sources.getSource(entity.getSource());
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            RuntimeEntity unitRuntimeEntity = sourceDomain.newRuntimeEntity(entity, null, null, source, qingContext, context.getOwnerId());
            unitRuntimeEntity.init(null);
            context.setQsEntity(entity);
            unitRuntimeEntity.setEntityExtractContext(context);
            PreviewDataModel result = sourceDomain.getPreviewData(qingContext, unitRuntimeEntity, reservedRows);
            unionEntityPreviewData.getData().addAll(result.getData());
            reservedRows = previewRows - unionEntityPreviewData.getData().size();
            if (reservedRows > 0) continue;
            break;
        }
        this.fillOtherPreviewInfo(this.unionEntity, qingContext, unionEntityPreviewData);
        context.setColumnToRowProperties(null);
        return unionEntityPreviewData;
    }

    @Override
    public long getDataCount(QingContext qingContext, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        FixProcesser.fixEntityForPreview(qingContext, (AbstractEntity)this.unionEntity, sources.getSources(), entities.getEntities());
        switch (this.unionEntity.getEntityType()) {
            case BIZ_UNION: {
                return this.getBizUnionEntityDataCount(qingContext, entities, sources, qingFileVisitorMap);
            }
            case COMMON_UNION: {
                return this.getCommonUnionDataCount(qingContext, sources, qingFileVisitorMap);
            }
            case SINGLE: {
                LogUtil.warn((String)"union entity type can not be single ,there must be logical error in somewhere code ");
                return -1L;
            }
        }
        return -1L;
    }

    private long getBizUnionEntityDataCount(QingContext qingContext, Entites entities, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        List<Entity> children = this.unionEntity.getChildren();
        long totalCount = 0L;
        Map entityMap = MapUtils.collectionToMap(entities.getEntities(), (MapUtils.IMapKeySelector)new EntityNameKeySelector());
        UnionEntity bizRootUnionEntity = this.findBizRootUnionEntity(this.unionEntity, entityMap);
        EntityExtractContext context = new EntityExtractContext();
        context.setQingContext(qingContext);
        context.setReadQingFileMap(qingFileVisitorMap);
        for (Entity entity : children) {
            AbstractSource source = sources.getSource(entity.getSource());
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            RuntimeEntity unitRuntimeEntity = sourceDomain.newRuntimeEntity(entity, null, null, source, qingContext, context.getOwnerId());
            unitRuntimeEntity.init(null);
            context.setQsEntity(entity);
            int unionLocation = entity.getUnionLocation();
            Entity rootEntity = bizRootUnionEntity.getChildren().get(unionLocation);
            unitRuntimeEntity.setRootEntity(rootEntity);
            unitRuntimeEntity.setEntityExtractContext(context);
            totalCount += sourceDomain.getDataCount(qingContext, unitRuntimeEntity);
        }
        return totalCount;
    }

    private long getCommonUnionDataCount(QingContext qingContext, Sources sources, Map<Entity, IQingFileVisitor> qingFileVisitorMap) throws AbstractSourceException, AbstractQingIntegratedException {
        List<Entity> children = this.unionEntity.getChildren();
        long totalCount = 0L;
        EntityExtractContext context = new EntityExtractContext();
        context.setQingContext(qingContext);
        context.setReadQingFileMap(qingFileVisitorMap);
        List<ColumnToRowProperty> columnToRowProperties = this.unionEntity.getColumnToRowProperties();
        context.setColumnToRowProperties(columnToRowProperties);
        for (Entity entity : children) {
            AbstractSource source = sources.getSource(entity.getSource());
            AbstractDataSourceDomain sourceDomain = SourceDomainFactory.getSourceDomain(source);
            RuntimeEntity unitRuntimeEntity = sourceDomain.newRuntimeEntity(entity, null, null, source, qingContext, context.getOwnerId());
            unitRuntimeEntity.init(null);
            context.setQsEntity(entity);
            unitRuntimeEntity.setEntityExtractContext(context);
            totalCount += sourceDomain.getDataCount(qingContext, unitRuntimeEntity);
        }
        context.setColumnToRowProperties(null);
        return totalCount;
    }

    private boolean containNotExistedFieldFilter(RuntimeEntity runtimeEntity) {
        boolean hasInvalidFilter = false;
        List<FilterItem> filters = runtimeEntity.getFilters();
        Map<String, RuntimeProperty> propertyMap = runtimeEntity.getAllPropertiesMap();
        for (int i = 0; i < filters.size(); ++i) {
            Property property;
            String propertyName = filters.get(i).getProprety();
            RuntimeProperty runtimeProperty = propertyMap.get(propertyName);
            if (runtimeProperty == null || !(property = runtimeProperty.getProperty()).isNotExisted() || "custom_biz_entity_name".equals(property.getName())) continue;
            hasInvalidFilter = true;
            break;
        }
        return hasInvalidFilter;
    }
}

