/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.visitor;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.domain.unionsource.WhitePropertyUtil;
import com.kingdee.bos.qing.data.domain.visitor.EntitySingleDataSourceVisitorDelegate;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.Relation;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.EmptySingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.ListSingleDataSourceVisitor;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BoxDataSourceWrap
extends MultiDataSourceWrap {
    private QingContext qingContext;
    private Map<String, AbstractSource> sourceMap;
    private Map<String, AbstractEntity> entityMap;
    private List<Relation> relations;
    private String ownerId;
    private Map<String, DSMetaEntity> dsMetaEntityMap;
    private boolean hasDirectModelEntity = true;
    private String themeId;
    private String CUSTOM_BIZ_ENTITY_NAME_FIELD = ".custom_biz_entity_name";
    private String FormId = "FormId";
    private String FormName = "FormName";
    private String UnionFormName = "UnionFormName";
    private String PseudoAdditionFilter = "pseudo_addition_filter";

    public BoxDataSourceWrap(QingContext qingContext, String themeId, Map<String, AbstractSource> sourceMap, Map<String, AbstractEntity> entityMap, List<Relation> relations, String ownerId, Map<String, DSMetaEntity> dsMetaEntityMap, Map<Set<String>, ? extends AbstractSingleDataSourceVisitor> dataSourceMap) {
        super(dataSourceMap);
        this.qingContext = qingContext;
        this.sourceMap = sourceMap;
        this.entityMap = entityMap;
        this.relations = relations;
        this.ownerId = ownerId;
        this.themeId = themeId;
        for (Map.Entry<String, AbstractEntity> entry : entityMap.entrySet()) {
            AbstractEntity abstractEntity = entry.getValue();
            if (!abstractEntity.hasDirectModel()) continue;
            this.hasDirectModelEntity = false;
        }
        this.dsMetaEntityMap = dsMetaEntityMap;
    }

    protected boolean isCacheJoinFile(Set<String> entityNameSet) {
        if (this.hasDirectModelEntity) {
            for (String entityName : entityNameSet) {
                AbstractEntity abstractEntity = this.entityMap.get(entityName);
                if (!abstractEntity.hasDirectModel()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, String> getUnionTableAdditionFilter(String primaryKey, String subTableBizName) {
        String[] parts = BoxDataSourceWrap.decodeFullName(primaryKey);
        String unionTableName = parts[0];
        HashMap<String, String> result = new HashMap<String, String>(16);
        Map bizParam = (Map)JsonUtil.decodeFromString((String)subTableBizName, HashMap.class);
        String formId = (String)bizParam.get(this.FormId);
        String formName = (String)bizParam.get(this.FormName);
        String unionFormName = (String)bizParam.get(this.UnionFormName);
        AbstractEntity abstractEntity = this.entityMap.get(unionTableName);
        String key = unionTableName + this.CUSTOM_BIZ_ENTITY_NAME_FIELD;
        if (abstractEntity instanceof UnionEntity) {
            List<Entity> children = ((UnionEntity)abstractEntity).getChildren();
            for (Entity child : children) {
                if (formName != null) {
                    if (!formName.equals(child.getName())) continue;
                    result.put(key, child.getAlias());
                    continue;
                }
                if (!formId.equals(child.getName())) continue;
                result.put(key, child.getAlias());
            }
            if (result.isEmpty()) {
                result.put(key, this.PseudoAdditionFilter);
                String FieldNameString = this.getFieldNameOfStringType(children.get(0));
                result.put(unionTableName + "." + FieldNameString, this.PseudoAdditionFilter);
            }
        } else if (unionFormName != null && !unionTableName.equals(formName)) {
            result.put(key, this.PseudoAdditionFilter);
            String FieldNameString = this.getFieldNameOfStringType(abstractEntity);
            result.put(unionTableName + "." + FieldNameString, this.PseudoAdditionFilter);
        }
        return result;
    }

    private String getFieldNameOfStringType(AbstractEntity entity) {
        List<Property> props = entity.getProperties();
        for (Property prop : props) {
            if (!prop.getDataType().equals((Object)DesigningDataType.STRING)) continue;
            return prop.getName();
        }
        return null;
    }

    public AbstractSingleDataSourceVisitor get(Set<String> entityNames) throws AbstractDataSourceException {
        if (entityNames.size() == 1) {
            String entityName = (String)entityNames.toArray()[0];
            AbstractEntity abstractEntity = this.entityMap.get(entityName);
            DSMetaEntity dsMetaEntity = this.dsMetaEntityMap.get(entityName);
            if (abstractEntity instanceof Entity) {
                Entity entity = (Entity)abstractEntity;
                if (abstractEntity.hasDirectModel()) {
                    AbstractDataSourceDomain sourceDomain;
                    String sourceName = entity.getSource();
                    AbstractSource source = this.sourceMap.get(sourceName);
                    try {
                        sourceDomain = SourceDomainFactory.getSourceDomain(source);
                    }
                    catch (UnSupportDataSourceException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(abstractEntity, this.relations);
                    return sourceDomain.createDirectModelDataSourceVisitor(this.qingContext, source, entity, dsMetaEntity, whitePropertySet, this.ownerId);
                }
                return super.get(entityNames);
            }
            if (abstractEntity instanceof UnionEntity) {
                AbstractSingleDataSourceVisitor dataSourceVisitor = super.get(entityNames);
                UnionEntity unionEntity = (UnionEntity)abstractEntity;
                Map<String, Set<Entity>> sameSourceDirectModelEntityMap = unionEntity.getSameSourceDirectModelEntityMap();
                ArrayList<AbstractSingleDataSourceVisitor> dataSourceVisitors = new ArrayList<AbstractSingleDataSourceVisitor>();
                if (dataSourceVisitor != null) {
                    dataSourceVisitors.add(dataSourceVisitor);
                }
                for (Map.Entry<String, Set<Entity>> sourceEntry : sameSourceDirectModelEntityMap.entrySet()) {
                    AbstractDataSourceDomain sourceDomain;
                    Set<Entity> entitySet = sourceEntry.getValue();
                    AbstractSource source = this.sourceMap.get(sourceEntry.getKey());
                    try {
                        sourceDomain = SourceDomainFactory.getSourceDomain(source);
                    }
                    catch (UnSupportDataSourceException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    if (entitySet.size() == 1) {
                        for (Entity entity : entitySet) {
                            Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(entity, this.relations);
                            dataSourceVisitor = sourceDomain.createDirectModelDataSourceVisitor(this.qingContext, source, entity, dsMetaEntity, whitePropertySet, this.ownerId);
                            dataSourceVisitors.add(dataSourceVisitor);
                        }
                        continue;
                    }
                    try {
                        UnionEntity newUnionEntity = unionEntity.createNewUnionEntity(entitySet);
                        Set<String> whitePropertySet = WhitePropertyUtil.getWhitePropertySet(newUnionEntity, this.relations);
                        dataSourceVisitor = sourceDomain.createDirectDataSourceVisitor(this.qingContext, source, newUnionEntity, dsMetaEntity, whitePropertySet, this.ownerId);
                        dataSourceVisitors.add(dataSourceVisitor);
                    }
                    catch (ModelParseException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                if (dataSourceVisitors.size() == 0) {
                    return new EntitySingleDataSourceVisitorDelegate(abstractEntity, dsMetaEntity, (AbstractSingleDataSourceVisitor)new EmptySingleDataSourceVisitor());
                }
                if (dataSourceVisitors.size() == 1) {
                    return (AbstractSingleDataSourceVisitor)dataSourceVisitors.get(0);
                }
                return new EntitySingleDataSourceVisitorDelegate(unionEntity, dsMetaEntity, (AbstractSingleDataSourceVisitor)new ListSingleDataSourceVisitor(dataSourceVisitors));
            }
        }
        return super.get(entityNames);
    }

    public String getThemeId() {
        return this.themeId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static String[] decodeFullName(String fullName) {
        String fieldPureName;
        String tableName;
        int dotIdx = fullName.indexOf(".");
        if (dotIdx == -1) {
            tableName = null;
            fieldPureName = fullName;
        } else {
            tableName = fullName.substring(0, dotIdx);
            fieldPureName = fullName.substring(dotIdx + 1);
        }
        return new String[]{tableName, fieldPureName};
    }
}

