/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.common.thread.GlobalScheduledExecutor;
import com.kingdee.bos.qing.data.model.designtime.Box;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class BoxModelGlobalJvmCache
implements Runnable {
    private static BoxModelGlobalJvmCache instance = new BoxModelGlobalJvmCache();
    private static final int LOW_LEVEL_SIZE = 50;
    private static final int HIGH_LEVEL_SIZE = 200;
    private static final long EXPIRE_TIME = 300000L;
    private static Map<String, Box> boxCacheMap = new HashMap<String, Box>(50);
    private static Map<String, Box> weakBoxCacheMap = new WeakHashMap<String, Box>(10);
    private static Map<String, Long> boxAliveTime = new HashMap<String, Long>();

    private BoxModelGlobalJvmCache() {
        GlobalScheduledExecutor.scheduleAtFixRate((Runnable)this, (long)3000L, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static BoxModelGlobalJvmCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String themeId) {
        BoxModelGlobalJvmCache boxModelGlobalJvmCache = this;
        synchronized (boxModelGlobalJvmCache) {
            boxAliveTime.remove(themeId);
            boxCacheMap.remove(themeId);
            weakBoxCacheMap.remove(themeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheBox(String themeId, Box box) {
        BoxModelGlobalJvmCache boxModelGlobalJvmCache = this;
        synchronized (boxModelGlobalJvmCache) {
            int currentSizeAfterMove;
            int currentSize = boxCacheMap.size();
            if (currentSize >= 200) {
                this.moveTimeoutBox();
            }
            if ((currentSizeAfterMove = boxCacheMap.size()) < 200) {
                boxCacheMap.put(themeId, box);
            } else {
                weakBoxCacheMap.put(themeId, box);
            }
            boxAliveTime.put(themeId, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Box getCached(String themeId) {
        BoxModelGlobalJvmCache boxModelGlobalJvmCache = this;
        synchronized (boxModelGlobalJvmCache) {
            Box box = boxCacheMap.get(themeId);
            boolean isFromWeakMap = false;
            if (null == box) {
                box = weakBoxCacheMap.get(themeId);
                isFromWeakMap = true;
            }
            if (null != box) {
                boxAliveTime.put(themeId, System.currentTimeMillis());
                if (isFromWeakMap) {
                    this.moveTimeoutBox();
                    int currentSize = boxCacheMap.size();
                    if (currentSize < 200) {
                        boxCacheMap.put(themeId, box);
                        weakBoxCacheMap.remove(themeId);
                    }
                }
            }
            return box;
        }
    }

    private void moveTimeoutBox() {
        Set<String> themeIds = boxCacheMap.keySet();
        long currentTimeMillis = System.currentTimeMillis();
        HashSet<String> themeIdSetToMove = new HashSet<String>();
        for (String key : themeIds) {
            long time = boxAliveTime.get(key);
            long duration = currentTimeMillis - time;
            if (duration < 10000L) continue;
            themeIdSetToMove.add(key);
        }
        for (String themeIdToRemove : themeIdSetToMove) {
            Box boxToMove = boxCacheMap.remove(themeIdToRemove);
            weakBoxCacheMap.put(themeIdToRemove, boxToMove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BoxModelGlobalJvmCache boxModelGlobalJvmCache = this;
        synchronized (boxModelGlobalJvmCache) {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<String, Long> entry : boxAliveTime.entrySet()) {
                long aliveTime = entry.getValue();
                String themeID = entry.getKey();
                long duration = currentTime - aliveTime;
                if (duration >= 300000L) {
                    boxCacheMap.remove(themeID);
                    weakBoxCacheMap.remove(themeID);
                }
                if (boxCacheMap.size() > 50) continue;
                return;
            }
        }
    }
}

