/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.designtime;

import com.kingdee.bos.qing.common.daterange.RelativeDateRange;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.CompareType;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.ValueMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterItem {
    private String property;
    private CompareOp compare;
    private String value;
    private ValueMode mode;
    private int leftBrackets;
    private int rightBrackets;
    private LogicOp logic;
    private RelativeDateRange relativeDateRange;
    private CompareType compareType;
    private transient Boolean _prediction;
    private static Set<CompareOp> STRINGOP = new HashSet<CompareOp>();
    private static Set<CompareOp> NUMBEROP = new HashSet<CompareOp>();
    private static Set<CompareOp> DATETIMEOP = new HashSet<CompareOp>();
    private static Set<CompareOp> BOOLEANOP = new HashSet<CompareOp>();

    public FilterItem() {
        STRINGOP.add(CompareOp.EQUAL);
        STRINGOP.add(CompareOp.NOT_EQUAL);
        STRINGOP.add(CompareOp.INCLUDE);
        STRINGOP.add(CompareOp.NOT_INCLUDE);
        STRINGOP.add(CompareOp.START_WITH);
        STRINGOP.add(CompareOp.END_WITH);
        STRINGOP.add(CompareOp.NULL);
        STRINGOP.add(CompareOp.NOT_NULL);
        STRINGOP.add(CompareOp.VARIABALE_MATCH);
        NUMBEROP.add(CompareOp.EQUAL);
        NUMBEROP.add(CompareOp.NOT_EQUAL);
        NUMBEROP.add(CompareOp.GREATER);
        NUMBEROP.add(CompareOp.GREATER_EQUAL);
        NUMBEROP.add(CompareOp.LESS);
        NUMBEROP.add(CompareOp.LESS_EQUAL);
        NUMBEROP.add(CompareOp.NULL);
        NUMBEROP.add(CompareOp.NOT_NULL);
        NUMBEROP.add(CompareOp.VARIABALE_MATCH);
        DATETIMEOP.add(CompareOp.EQUAL);
        DATETIMEOP.add(CompareOp.NOT_EQUAL);
        DATETIMEOP.add(CompareOp.GREATER);
        DATETIMEOP.add(CompareOp.GREATER_EQUAL);
        DATETIMEOP.add(CompareOp.LESS);
        DATETIMEOP.add(CompareOp.LESS_EQUAL);
        DATETIMEOP.add(CompareOp.NULL);
        DATETIMEOP.add(CompareOp.NOT_NULL);
        DATETIMEOP.add(CompareOp.RELATIVE_DATE_RANGE);
        DATETIMEOP.add(CompareOp.VARIABALE_MATCH);
        BOOLEANOP.add(CompareOp.EQUAL);
        BOOLEANOP.add(CompareOp.NOT_EQUAL);
        BOOLEANOP.add(CompareOp.NULL);
        BOOLEANOP.add(CompareOp.NOT_NULL);
    }

    public void setPrediction(Boolean prediction) {
        this._prediction = prediction;
    }

    public Boolean getPrediction() {
        return this._prediction;
    }

    public Boolean predict() {
        return this._prediction;
    }

    public String getProprety() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public CompareOp getCompareOp() {
        return this.compare;
    }

    public void setCompareOp(CompareOp compare) {
        this.compare = compare;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ValueMode getValueMode() {
        return this.mode == null ? ValueMode.Const : this.mode;
    }

    public void setValueMode(ValueMode mode) {
        this.mode = mode;
    }

    public int getLeftBracketCount() {
        return this.leftBrackets;
    }

    public void setLeftBracketCount(int count) {
        this.leftBrackets = count;
    }

    public int getRightBracketCount() {
        return this.rightBrackets;
    }

    public void setRightBracketCount(int count) {
        this.rightBrackets = count;
    }

    public LogicOp getLogicOp() {
        return this.logic;
    }

    public void setLogicOp(LogicOp op) {
        this.logic = op;
    }

    public RelativeDateRange getRelativeDateRange() {
        return this.relativeDateRange;
    }

    public void setRelativeDateRange(RelativeDateRange relativeDateRange) {
        this.relativeDateRange = relativeDateRange;
    }

    public Element toXml() {
        Element node = new Element("Item");
        node.setAttribute("property", this.property);
        node.setAttribute("compare", this.compare.toPersistance());
        if (!this.compare.isComparedValueNeedless()) {
            if (this.value != null) {
                node.setAttribute("value", this.value);
            }
            if (this.relativeDateRange != null) {
                Element nodeDateRange = new Element("RelativeDateRange");
                this.relativeDateRange.toXml(nodeDateRange);
                node.addContent((Content)nodeDateRange);
            }
        }
        if (this.getValueMode() != ValueMode.Const) {
            node.setAttribute("mode", this.getValueMode().toPersistance());
        }
        if (this.leftBrackets > 0) {
            node.setAttribute("lb", Integer.toString(this.leftBrackets));
        }
        if (this.rightBrackets > 0) {
            node.setAttribute("rb", Integer.toString(this.rightBrackets));
        }
        if (this.logic != null) {
            node.setAttribute("logic", this.logic.toPersistance());
        }
        if (null != this.compareType) {
            node.setAttribute("compareType", this.compareType.name());
        }
        return node;
    }

    public void fromXml(Element node) throws ModelParseException {
        String mode;
        this.property = node.getAttributeValue("property");
        if (this.property == null) {
            throw new ModelParseException("Incomplete FilterItem.");
        }
        this.compare = CompareOp.fromPersistance(node.getAttributeValue("compare"));
        if (!this.compare.isComparedValueNeedless()) {
            this.value = node.getAttributeValue("value");
            Element nodeDateRange = node.getChild("RelativeDateRange");
            if (nodeDateRange != null) {
                this.relativeDateRange = new RelativeDateRange();
                this.relativeDateRange.fromXml(nodeDateRange);
            } else {
                this.relativeDateRange = null;
            }
        }
        this.mode = (mode = node.getAttributeValue("mode")) == null ? null : ValueMode.fromPersistance((String)mode);
        String lb = node.getAttributeValue("lb");
        String rb = node.getAttributeValue("rb");
        try {
            this.leftBrackets = lb == null ? 0 : Integer.parseInt(lb);
            this.rightBrackets = rb == null ? 0 : Integer.parseInt(rb);
        }
        catch (NumberFormatException ex) {
            throw new ModelParseException("Brackets in FilterItem is NaN.", (Throwable)ex);
        }
        String logic = node.getAttributeValue("logic");
        this.logic = logic == null ? null : LogicOp.fromPersistance(logic);
        String compareType = node.getAttributeValue("compareType");
        this.compareType = null != compareType ? CompareType.valueOf(compareType) : CompareType.RAW;
    }

    public FilterItem createCopy() {
        FilterItem fi = new FilterItem();
        fi.setCompareOp(this.getCompareOp());
        fi.setLeftBracketCount(this.getLeftBracketCount());
        fi.setLogicOp(this.getLogicOp());
        fi.setRightBracketCount(this.getRightBracketCount());
        fi.setValue(this.getValue());
        fi.setValueMode(this.getValueMode());
        fi.setRelativeDateRange(this.getRelativeDateRange());
        fi.setProperty(this.getProprety());
        fi.setCompareType(this.getCompareType());
        return fi;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = hashCode * 31 + this.property.hashCode();
        hashCode = hashCode * 31 + this.value.hashCode();
        hashCode = hashCode * 31 + this.compare.hashCode();
        hashCode = hashCode * 31 + this.logic.hashCode();
        hashCode = hashCode * 31 + this.leftBrackets;
        hashCode = hashCode * 31 + this.rightBrackets;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterItem target = (FilterItem)obj;
        return this.doCompare(this.property, target.getProprety()) && this.doCompare(this.value, target.getValue()) && this.doCompare((Object)this.compare, (Object)target.getCompareOp()) && this.doCompare((Object)this.logic, (Object)target.getLogicOp()) && this.doCompare(this.leftBrackets, target.getLeftBracketCount()) && this.doCompare(this.rightBrackets, target.getRightBracketCount()) && this.doCompare(this.mode, target.getValueMode()) && this.doCompare(this.relativeDateRange, target.getRelativeDateRange());
    }

    private boolean doCompare(Object src, Object target) {
        if (src == null) {
            return null == target;
        }
        return src.equals(target);
    }

    public String toString() {
        return "FilterItem{property='" + this.property + '\'' + ", compare=" + (Object)((Object)this.compare) + ", value='" + this.value + '\'' + ", mode=" + this.mode + ", leftBrackets=" + this.leftBrackets + ", rightBrackets=" + this.rightBrackets + ", logic=" + (Object)((Object)this.logic) + ", relativeDateRange=" + this.relativeDateRange + ", _prediction=" + this._prediction + '}';
    }

    public static List<FilterItem> appendFilterItem(List<FilterItem> oldFilterItems, List<FilterItem> appendFilterItems, LogicOp logicOp) {
        if (oldFilterItems == null || oldFilterItems.isEmpty()) {
            return appendFilterItems;
        }
        if (appendFilterItems != null && !appendFilterItems.isEmpty()) {
            FilterItem lastFilterItem;
            FilterItem firstFilterItem;
            if (oldFilterItems.size() == 1) {
                FilterItem oldFilterItem = oldFilterItems.get(0);
                oldFilterItem.setLogicOp(logicOp);
            } else {
                firstFilterItem = oldFilterItems.get(0);
                firstFilterItem.setLeftBracketCount(firstFilterItem.getLeftBracketCount() + 1);
                lastFilterItem = oldFilterItems.get(oldFilterItems.size() - 1);
                lastFilterItem.setRightBracketCount(lastFilterItem.getRightBracketCount() + 1);
                lastFilterItem.setLogicOp(logicOp);
            }
            if (appendFilterItems.size() > 1) {
                firstFilterItem = appendFilterItems.get(0);
                firstFilterItem.setLeftBracketCount(firstFilterItem.getLeftBracketCount() + 1);
                lastFilterItem = appendFilterItems.get(appendFilterItems.size() - 1);
                lastFilterItem.setRightBracketCount(lastFilterItem.getRightBracketCount() + 1);
            }
            oldFilterItems.addAll(appendFilterItems);
            return oldFilterItems;
        }
        return oldFilterItems;
    }

    public static boolean checkDesigningDataTypeSupportCompareOp(DesigningDataType designingDataType, CompareOp compareOp) {
        switch (designingDataType) {
            case BOOLEAN: {
                return BOOLEANOP.contains((Object)compareOp);
            }
            case INT: 
            case NUMBER: {
                return NUMBEROP.contains((Object)compareOp);
            }
            case DATE: 
            case DATETIME: {
                return DATETIMEOP.contains((Object)compareOp);
            }
        }
        return STRINGOP.contains((Object)compareOp);
    }

    public static enum LogicOp {
        AND,
        OR;


        public String toPersistance() {
            return this.name();
        }

        public static LogicOp fromPersistance(String name) throws ModelParseException {
            try {
                return LogicOp.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown LogicOp: " + name);
            }
        }
    }

    public static enum CompareOp {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_EQUAL,
        LESS,
        LESS_EQUAL,
        INCLUDE,
        NOT_INCLUDE,
        START_WITH,
        END_WITH,
        NULL(true),
        NOT_NULL(true),
        IN,
        NOT_IN,
        RELATIVE_DATE_RANGE,
        VARIABALE_MATCH,
        CUSTOM_VARIABALE_MATCH;

        private boolean _isComparedValueNeedless;

        private CompareOp() {
            this(false);
        }

        private CompareOp(boolean isComparedValueNeedless) {
            this._isComparedValueNeedless = isComparedValueNeedless;
        }

        public boolean isComparedValueNeedless() {
            return this._isComparedValueNeedless;
        }

        public String toPersistance() {
            return this.name();
        }

        public static CompareOp fromPersistance(String name) throws ModelParseException {
            try {
                return CompareOp.valueOf(name);
            }
            catch (Exception ex) {
                throw new ModelParseException("Unknown CompareOp: " + name);
            }
        }
    }
}

