/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.common.daterange.RuntimeRelativeDateRange;
import java.sql.Timestamp;
import java.util.Set;

public interface IComparator {
    public boolean excute(Object var1);

    public void setCompareValue(Object var1);

    public static class NotInComparator
    extends InComparator {
        @Override
        public boolean excute(Object otherValue) {
            return !super.excute(otherValue);
        }
    }

    public static class InComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.compareValue == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            Set arrays = (Set)this.compareValue;
            for (Object next : arrays) {
                if (((Comparable)next).compareTo(otherValue) != 0) continue;
                return true;
            }
            return false;
        }
    }

    public static class NotIncludeComparator
    extends IncludeComparator {
        @Override
        public boolean excute(Object otherValue) {
            return !super.excute(otherValue);
        }
    }

    public static class IncludeComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            return otherValue.toString().contains(this.getComparableValue().toString());
        }
    }

    public static class EndWithComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            return otherValue.toString().endsWith(this.getComparableValue().toString());
        }
    }

    public static class StartWithComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            return otherValue.toString().startsWith(this.getComparableValue().toString());
        }
    }

    public static class RelativeDateRangeComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.compareValue == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            if (this.compareValue instanceof RuntimeRelativeDateRange) {
                RuntimeRelativeDateRange r = (RuntimeRelativeDateRange)this.compareValue;
                boolean isTimeStamp = otherValue instanceof Timestamp;
                GreaterEqualComparator startComparator = new GreaterEqualComparator();
                startComparator.setCompareValue(isTimeStamp ? new Timestamp(r.getDateStart()) : r.getCalendarStart());
                LessEqualComparator endComparator = new LessEqualComparator();
                endComparator.setCompareValue(isTimeStamp ? new Timestamp(r.getDateEnd()) : r.getCalendarEnd());
                return startComparator.excute(otherValue) && endComparator.excute(otherValue);
            }
            return false;
        }
    }

    public static class LessEqualComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            int result = this.getComparableValue().compareTo(otherValue);
            return result >= 0;
        }
    }

    public static class GreaterEqualComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            int result = this.getComparableValue().compareTo(otherValue);
            return result <= 0;
        }
    }

    public static class LessComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (otherValue == null || this.getComparableValue() == null) {
                return false;
            }
            int result = this.getComparableValue().compareTo(otherValue);
            return result > 0;
        }
    }

    public static class GreaterComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (otherValue == null || this.getComparableValue() == null) {
                return false;
            }
            int result = this.getComparableValue().compareTo(otherValue);
            return result < 0;
        }
    }

    public static class NotNullComparator
    extends NullComparator {
        @Override
        public boolean excute(Object otherValue) {
            return !super.excute(otherValue);
        }
    }

    public static class NullComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            return otherValue == null || otherValue instanceof String && "".equals(otherValue);
        }
    }

    public static class NotEqualComparator
    extends EqualComparator {
        @Override
        public boolean excute(Object otherValue) {
            return !super.excute(otherValue);
        }
    }

    public static class EqualComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            if (this.getComparableValue() == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            int result = this.getComparableValue().compareTo(otherValue);
            return result == 0;
        }
    }

    public static class UnSupportComparator
    extends AbstractComparator {
        @Override
        public boolean excute(Object otherValue) {
            return false;
        }
    }

    public static abstract class AbstractComparator
    implements IComparator {
        protected Object compareValue;

        @Override
        public void setCompareValue(Object compareValue) {
            this.compareValue = compareValue;
        }

        protected Comparable getComparableValue() {
            if (this.compareValue instanceof Comparable) {
                return (Comparable)this.compareValue;
            }
            return null;
        }
    }
}

