/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogicalFilter
implements IRuntimeFilter {
    private IRuntimeFilter _left;
    private FilterItem.LogicOp _op;
    private IRuntimeFilter _right;

    public final void init(IRuntimeFilter left, FilterItem.LogicOp op, IRuntimeFilter right) {
        this._left = left;
        this._op = op;
        this._right = right;
    }

    public final IRuntimeFilter getLeft() {
        return this._left;
    }

    public final <T extends IRuntimeFilter> void setLeft(T left) {
        this._left = left;
    }

    public final IRuntimeFilter getRight() {
        return this._right;
    }

    public final <T extends IRuntimeFilter> void setRight(T right) {
        this._right = right;
    }

    public final FilterItem.LogicOp getOp() {
        return this._op;
    }

    public final void setOp(FilterItem.LogicOp op) {
        this._op = op;
    }

    @Override
    public final void check(Set<String> fields) {
        this._left.check(fields);
        this._right.check(fields);
    }

    @Override
    public final boolean isInvalid() {
        return this._left.isInvalid() && this._right.isInvalid();
    }

    @Override
    public final void bindRuntimeInfo(QingContext qingContext, RuntimeEntity runtimeEntity, Map<String, RuntimeProperty> allProperties) {
        this._left.bindRuntimeInfo(qingContext, runtimeEntity, allProperties);
        this._right.bindRuntimeInfo(qingContext, runtimeEntity, allProperties);
    }

    @Override
    public void collectPushDownFilter(List<IRuntimeFilter> pushDownFilters) {
        if (this.isUnPushdownableFilter()) {
            if (this._op == FilterItem.LogicOp.AND) {
                if (this._left.isUnPushdownableFilter()) {
                    this._left.collectPushDownFilter(pushDownFilters);
                } else {
                    pushDownFilters.add(this._left);
                }
                if (this._right.isUnPushdownableFilter()) {
                    this._right.collectPushDownFilter(pushDownFilters);
                } else {
                    pushDownFilters.add(this._right);
                }
            }
        } else {
            pushDownFilters.add(this);
        }
    }

    @Override
    public boolean isUnPushdownableFilter() {
        return this._left.isUnPushdownableFilter() || this._right.isUnPushdownableFilter();
    }

    @Override
    public void collectUnPushdownableFilter(List<IRuntimeFilter> filterCollected) {
        if (this.isUnPushdownableFilter()) {
            if (this._op == FilterItem.LogicOp.AND) {
                if (this._left.isUnPushdownableFilter()) {
                    this._left.collectUnPushdownableFilter(filterCollected);
                }
                if (this._right.isUnPushdownableFilter()) {
                    this._right.collectUnPushdownableFilter(filterCollected);
                }
            } else {
                filterCollected.add(this);
            }
        }
    }

    @Override
    public boolean isCalculationalFilter() {
        return this._left.isCalculationalFilter() || this._right.isCalculationalFilter();
    }

    @Override
    public void collectProperties(List<RuntimeProperty> properties) {
        this._left.collectProperties(properties);
        this._right.collectProperties(properties);
    }

    @Override
    public final boolean innerExcuteFilterWtihRawValue(Map<String, Object> primaryRowData) {
        if (this.isInvalid()) {
            return true;
        }
        if (this._left.isInvalid()) {
            return this._right.innerExcuteFilterWtihRawValue(primaryRowData);
        }
        if (this._right.isInvalid()) {
            return this._left.innerExcuteFilterWtihRawValue(primaryRowData);
        }
        if (FilterItem.LogicOp.AND == this.getOp()) {
            return this._left.innerExcuteFilterWtihRawValue(primaryRowData) && this._right.innerExcuteFilterWtihRawValue(primaryRowData);
        }
        return this._left.innerExcuteFilterWtihRawValue(primaryRowData) || this._right.innerExcuteFilterWtihRawValue(primaryRowData);
    }

    @Override
    public final boolean innerExcuteFilter(Map<String, Object> primaryRowData, Map<String, Object> outputRowData) {
        if (this.isInvalid()) {
            return true;
        }
        if (this._left.isInvalid()) {
            return this._right.innerExcuteFilter(primaryRowData, outputRowData);
        }
        if (this._right.isInvalid()) {
            return this._left.innerExcuteFilter(primaryRowData, outputRowData);
        }
        if (FilterItem.LogicOp.AND == this.getOp()) {
            return this._left.innerExcuteFilter(primaryRowData, outputRowData) && this._right.innerExcuteFilter(primaryRowData, outputRowData);
        }
        return this._left.innerExcuteFilter(primaryRowData, outputRowData) || this._right.innerExcuteFilter(primaryRowData, outputRowData);
    }

    @Override
    public void setSource(AbstractSource source) {
        this._left.setSource(source);
        this._right.setSource(source);
    }

    @Override
    public String getUnpushdownFilterExpress() {
        if (this.isInvalid()) {
            return null;
        }
        if (this._left.isInvalid()) {
            return "(" + this._right.getUnpushdownFilterExpress() + ")";
        }
        if (this._right.isInvalid()) {
            return "(" + this._left.getUnpushdownFilterExpress() + ")";
        }
        if (FilterItem.LogicOp.AND == this.getOp()) {
            return "(" + this._left.getUnpushdownFilterExpress() + " AND " + this._right.getUnpushdownFilterExpress() + ")";
        }
        return "(" + this._left.getUnpushdownFilterExpress() + " OR " + this._right.getUnpushdownFilterExpress() + ")";
    }
}

