/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityFixContext {
    private Entity local;
    private Map<String, Property> localPropMap = new HashMap<String, Property>();
    private List<Property> calcProperties = new ArrayList<Property>();
    private Map<String, Property> localRelatedBaseProp = new HashMap<String, Property>();

    public EntityFixContext(Entity local) {
        this.local = local;
    }

    public Set<String> getRelatedBasePropNames() {
        return this.localRelatedBaseProp.keySet();
    }

    public Set<String> getRelatedBasePropExcludeUnExisted() {
        HashSet<String> relatedBasePropNameSet = new HashSet<String>(this.localRelatedBaseProp.size());
        for (Property property : this.localRelatedBaseProp.values()) {
            if (property.isNotExisted()) continue;
            relatedBasePropNameSet.add(property.getRelatedBaseProperty());
        }
        return relatedBasePropNameSet;
    }

    public List<Property> getCalcProperties() {
        return this.calcProperties;
    }

    public void prepare() {
        List<Property> properties = this.local.getProperties();
        for (Property property : properties) {
            this.localPropMap.put(property.getName(), property);
            String relatedBaseProp = property.getRelatedBaseProperty();
            if (StringUtils.isNotEmpty((CharSequence)relatedBaseProp)) {
                this.localRelatedBaseProp.put(relatedBaseProp, property);
            }
            if (!property.isCalculation()) continue;
            this.calcProperties.add(property);
        }
    }

    public Property findMappingProperty(String basePropName) {
        return this.localRelatedBaseProp.get(basePropName);
    }

    public void updateRelatedPropMap(Map<String, Property> newBaseRelatedPropMap) {
        this.localRelatedBaseProp.clear();
        this.localRelatedBaseProp = newBaseRelatedPropMap;
    }

    public void updateLocalPropMap(Map<String, Property> newPropMap) {
        this.localPropMap.clear();
        this.localPropMap = newPropMap;
    }

    public Map<String, Property> getLocalPropMap() {
        return this.localPropMap;
    }

    public void addProperty(Property property) {
        this.localPropMap.put(property.getName(), property);
        String relatedBaseProp = property.getRelatedBaseProperty();
        if (StringUtils.isNotEmpty((CharSequence)relatedBaseProp)) {
            this.localRelatedBaseProp.put(relatedBaseProp, property);
        }
    }

    public void removeProp(Property property) {
        this.localPropMap.remove(property.getName());
        String baseRelatedProp = property.getRelatedBaseProperty();
        if (StringUtils.isNotEmpty((CharSequence)baseRelatedProp)) {
            this.localRelatedBaseProp.remove(baseRelatedProp);
        }
        if (property.isCalculation()) {
            this.calcProperties.remove(property);
        }
    }

    public void removeEntityProps(List<Property> propToRemoves) {
        if (null == propToRemoves) {
            return;
        }
        for (Property property : propToRemoves) {
            this.removeProp(property);
        }
    }

    public Entity getLocal() {
        return this.local;
    }
}

