/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FixEntityColumnToRowProcess {
    private BoxFixScene boxFixScene;

    public FixEntityColumnToRowProcess(BoxFixScene boxFixScene) {
        this.boxFixScene = boxFixScene;
    }

    public void process(AbstractEntity dmEntity) {
        if (this.boxFixScene == BoxFixScene.extract || this.boxFixScene == BoxFixScene.preview) {
            List<ColumnToRowProperty> columnToRowProperties = dmEntity.getColumnToRowProperties();
            if (CollectionUtils.isEmpty(columnToRowProperties)) {
                return;
            }
            List<Property> properties = dmEntity.getProperties();
            FixEntityColumnToRowProcess.processProperties(columnToRowProperties, properties);
        }
    }

    public static void processProperties(List<ColumnToRowProperty> columnToRowProperties, List<Property> properties) {
        if (CollectionUtils.isEmpty(columnToRowProperties) || CollectionUtils.isEmpty(properties)) {
            return;
        }
        ArrayList<String> usedColumnToRowProperties = new ArrayList<String>();
        ArrayList<Property> addNewProperties = new ArrayList<Property>();
        for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
            usedColumnToRowProperties.addAll(columnToRowProperty.getUsedColumnToRowPropertyNames());
            addNewProperties.add(columnToRowProperty.getFieldNameProperty());
            addNewProperties.addAll(columnToRowProperty.getFieldValueProperties());
        }
        HashSet<String> propertyNames = new HashSet<String>(16);
        for (Property property : properties) {
            propertyNames.add(property.getName());
        }
        for (String colToRowUsedPropertyName : usedColumnToRowProperties) {
            if (propertyNames.contains(colToRowUsedPropertyName)) continue;
            return;
        }
        for (Property property : properties) {
            if (!usedColumnToRowProperties.contains(property.getName())) continue;
            property.setHide(true);
            property.addExtensionData("isInputProp", true);
            property.addExtensionData("isOutPutProp", false);
        }
        for (Property property : addNewProperties) {
            property.addExtensionData("isInputProp", false);
            property.addExtensionData("isOutPutProp", true);
            properties.add(property);
        }
    }

    public void reFixColumnToRowProperty(Entity liveEntity) {
        if (this.boxFixScene == BoxFixScene.extract || this.boxFixScene == BoxFixScene.preview) {
            List<ColumnToRowProperty> columnToRowProperties = liveEntity.getColumnToRowProperties();
            if (CollectionUtils.isEmpty(columnToRowProperties)) {
                return;
            }
            List<Property> properties = liveEntity.getProperties();
            if (columnToRowProperties == null || properties == null) {
                return;
            }
            ArrayList<String> removeColumnToRowPropertyNames = new ArrayList<String>();
            ArrayList<String> recoverColumnToRowUsedPropertyNames = new ArrayList<String>();
            for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
                recoverColumnToRowUsedPropertyNames.addAll(columnToRowProperty.getUsedColumnToRowPropertyNames());
                removeColumnToRowPropertyNames.add(columnToRowProperty.getFieldNameProperty().getName());
                removeColumnToRowPropertyNames.addAll(columnToRowProperty.getFieldValueNames());
            }
            Iterator<Property> propertyIterator = properties.iterator();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.next();
                if (recoverColumnToRowUsedPropertyNames.contains(property.getName())) {
                    property.setHide(false);
                    property.addExtensionData("isInputProp", true);
                    property.addExtensionData("isOutPutProp", true);
                    continue;
                }
                if (!removeColumnToRowPropertyNames.contains(property.getName())) continue;
                propertyIterator.remove();
            }
        }
    }
}

