/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Parild;
import com.kingdee.bos.qing.data.model.designtime.Property;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FixEntityParildRuntimeProcess {
    public void process(Entity dmEntity, Entity liveEntity) {
        List<Parild> dmEntityParids = dmEntity.getParilds();
        if (dmEntityParids != null && !dmEntityParids.isEmpty()) {
            HashMap<String, Set<String>> dmPCDPropertyNameSetWithPCDNameMap = new HashMap<String, Set<String>>();
            List<Property> dmEntityProperties = dmEntity.getProperties();
            HashMap<String, Property> dmPropertyNameWithPropertyMap = new HashMap<String, Property>(dmEntityProperties.size());
            for (Property dmEntityProperty : dmEntityProperties) {
                String dmEntityPropertyName = dmEntityProperty.getName();
                dmPropertyNameWithPropertyMap.put(dmEntityPropertyName, dmEntityProperty);
                String pcdName = dmEntityProperty.getGroup();
                if (pcdName == null) continue;
                HashSet<String> pcdPropertyNameSet = (HashSet<String>)dmPCDPropertyNameSetWithPCDNameMap.get(pcdName);
                if (pcdPropertyNameSet == null) {
                    pcdPropertyNameSet = new HashSet<String>();
                    dmPCDPropertyNameSetWithPCDNameMap.put(pcdName, pcdPropertyNameSet);
                }
                pcdPropertyNameSet.add(dmEntityPropertyName);
            }
            List<Parild> liveEntityParids = liveEntity.getParilds();
            if (liveEntityParids == null) {
                FixEntityParildRuntimeProcess.fixAllUserDefineParild(dmEntityParids, dmPCDPropertyNameSetWithPCDNameMap, dmPropertyNameWithPropertyMap);
            } else {
                HashMap<String, Parild> dmEntityParidMap = new HashMap<String, Parild>(dmEntityParids.size());
                for (Parild dmEntityParid : dmEntityParids) {
                    String dmEntityParidName = dmEntityParid.getName();
                    dmEntityParidMap.put(dmEntityParidName, dmEntityParid);
                    HashSet dmPCDPropertyNameSet = (HashSet)dmPCDPropertyNameSetWithPCDNameMap.get(dmEntityParidName);
                    if (dmPCDPropertyNameSet != null) continue;
                    dmPCDPropertyNameSet = new HashSet();
                    dmPCDPropertyNameSetWithPCDNameMap.put(dmEntityParidName, dmPCDPropertyNameSet);
                }
                FixEntityParildRuntimeProcess.fixSystemParildChange(dmEntity, liveEntity, dmEntityParids, liveEntityParids, dmEntityParidMap, dmPCDPropertyNameSetWithPCDNameMap);
            }
        } else {
            FixEntityParildRuntimeProcess.importAllParild(dmEntity, liveEntity);
        }
    }

    private static void fixAllUserDefineParild(List<Parild> dmEntityParids, Map<String, Set<String>> dmPCDPropertyNameSetWithPCDNameMap, Map<String, Property> dmPropertyNameWithPropertyMap) {
        if (dmEntityParids == null || dmEntityParids.isEmpty()) {
            return;
        }
        Iterator<Parild> dmEntityParidIterator = dmEntityParids.iterator();
        while (dmEntityParidIterator.hasNext()) {
            String dmEntityParidSortAccordingFieldName;
            boolean hasSortAccordingField;
            DesigningDataType pidFieldPropertyDataType;
            Parild dmEntityParid = dmEntityParidIterator.next();
            String dmEntityParidName = dmEntityParid.getName();
            Set<String> pcdPropertyNameSet = dmPCDPropertyNameSetWithPCDNameMap.get(dmEntityParidName);
            if (pcdPropertyNameSet == null || pcdPropertyNameSet.isEmpty()) {
                FixEntityParildRuntimeProcess.removeParild(dmEntityParidIterator, pcdPropertyNameSet, dmPropertyNameWithPropertyMap);
                continue;
            }
            String dmEntityParidIdFieldName = dmEntityParid.getIdField();
            Property idFieldProperty = dmPropertyNameWithPropertyMap.get(dmEntityParidIdFieldName);
            String dmEntityParidParentIdFieldName = dmEntityParid.getParentIdField();
            Property pidFieldProperty = dmPropertyNameWithPropertyMap.get(dmEntityParidParentIdFieldName);
            if (idFieldProperty == null || pidFieldProperty == null) {
                FixEntityParildRuntimeProcess.removeParild(dmEntityParidIterator, pcdPropertyNameSet, dmPropertyNameWithPropertyMap);
                continue;
            }
            DesigningDataType idFieldPropertyDataType = idFieldProperty.getDataType();
            if (idFieldPropertyDataType != (pidFieldPropertyDataType = pidFieldProperty.getDataType())) {
                FixEntityParildRuntimeProcess.removeParild(dmEntityParidIterator, pcdPropertyNameSet, dmPropertyNameWithPropertyMap);
                continue;
            }
            String dmEntityParidDefaultDisplayFieldName = dmEntityParid.getDefaultDisplayField();
            boolean hasDisplayField = pcdPropertyNameSet.contains(dmEntityParidDefaultDisplayFieldName);
            if (!hasDisplayField) {
                dmEntityParid.setDefaultDisplayField(dmEntityParidIdFieldName);
            }
            if (hasSortAccordingField = pcdPropertyNameSet.contains(dmEntityParidSortAccordingFieldName = dmEntityParid.getSortAccordingField())) continue;
            if (hasDisplayField) {
                dmEntityParid.setSortAccordingField(dmEntityParidDefaultDisplayFieldName);
                continue;
            }
            dmEntityParid.setSortAccordingField(dmEntityParidIdFieldName);
        }
    }

    private static void importAllParild(Entity dmEntity, Entity liveEntity) {
        List<Parild> liveEntityParids = liveEntity.getParilds();
        if (liveEntityParids == null || liveEntityParids.isEmpty()) {
            return;
        }
        List<Property> liveEntityProperties = liveEntity.getProperties();
        HashMap<String, Property> livePropertyNameWithPropertyMap = new HashMap<String, Property>(liveEntityProperties.size());
        HashMap<String, Set<String>> livePCDPropertyNameSetWithPCDNameMap = new HashMap<String, Set<String>>();
        for (Property liveEntityProperty : liveEntityProperties) {
            String liveEntityPropertyName = liveEntityProperty.getName();
            livePropertyNameWithPropertyMap.put(liveEntityPropertyName, liveEntityProperty);
            String livePCDName = liveEntityProperty.getGroup();
            if (livePCDName == null) continue;
            HashSet<String> livePCDPropertyNameSet = (HashSet<String>)livePCDPropertyNameSetWithPCDNameMap.get(livePCDName);
            if (livePCDPropertyNameSet == null) {
                livePCDPropertyNameSet = new HashSet<String>();
                livePCDPropertyNameSetWithPCDNameMap.put(livePCDName, livePCDPropertyNameSet);
            }
            livePCDPropertyNameSet.add(liveEntityPropertyName);
        }
        for (Parild liveEntityParid : liveEntityParids) {
            FixEntityParildRuntimeProcess.importNewParild(dmEntity, liveEntityParid, livePropertyNameWithPropertyMap, livePCDPropertyNameSetWithPCDNameMap);
        }
    }

    private static void fixSystemParildChange(Entity dmEntity, Entity liveEntity, List<Parild> dmEntityParids, List<Parild> liveEntityParids, Map<String, Parild> dmEntityParidMap, Map<String, Set<String>> dmPCDPropertyNameSetWithPCDNameMap) {
        HashSet<String> livePCDPropertyNameSet;
        if (liveEntityParids == null || liveEntityParids.isEmpty()) {
            return;
        }
        List<Property> liveEntityProperties = liveEntity.getProperties();
        HashMap<String, Property> livePropertyNameWithPropertyMap = new HashMap<String, Property>(liveEntityProperties.size());
        HashMap<String, Set<String>> livePCDPropertyNameSetWithPCDNameMap = new HashMap<String, Set<String>>();
        for (Property liveEntityProperty : liveEntityProperties) {
            String liveEntityPropertyName = liveEntityProperty.getName();
            livePropertyNameWithPropertyMap.put(liveEntityPropertyName, liveEntityProperty);
            String livePCDName = liveEntityProperty.getGroup();
            if (livePCDName == null) continue;
            livePCDPropertyNameSet = (HashSet<String>)livePCDPropertyNameSetWithPCDNameMap.get(livePCDName);
            if (livePCDPropertyNameSet == null) {
                livePCDPropertyNameSet = new HashSet<String>();
                livePCDPropertyNameSetWithPCDNameMap.put(livePCDName, livePCDPropertyNameSet);
            }
            livePCDPropertyNameSet.add(liveEntityPropertyName);
        }
        for (Parild liveEntityParid : liveEntityParids) {
            String liveEntityParidName = liveEntityParid.getName();
            Set<String> dmPCDPropertyNameSet = dmPCDPropertyNameSetWithPCDNameMap.get(liveEntityParidName);
            livePCDPropertyNameSet = (Set)livePCDPropertyNameSetWithPCDNameMap.get(liveEntityParidName);
            if (dmPCDPropertyNameSet == null) {
                FixEntityParildRuntimeProcess.importNewParild(dmEntity, liveEntityParid, livePropertyNameWithPropertyMap, livePCDPropertyNameSetWithPCDNameMap);
                continue;
            }
            if (dmPCDPropertyNameSet.isEmpty()) {
                Parild removeParild = dmEntityParidMap.remove(liveEntityParidName);
                dmEntityParids.remove(removeParild);
                FixEntityParildRuntimeProcess.importNewParild(dmEntity, liveEntityParid, livePropertyNameWithPropertyMap, livePCDPropertyNameSetWithPCDNameMap);
                continue;
            }
            Parild dmEntityParild = dmEntityParidMap.get(liveEntityParidName);
            FixEntityParildRuntimeProcess.fixOldParild(dmEntity, dmEntityParild, liveEntityParid, dmPCDPropertyNameSet, livePCDPropertyNameSet, livePropertyNameWithPropertyMap);
        }
    }

    private static void fixOldParild(Entity dmEntity, Parild dmEntityParild, Parild liveEntityParid, Set<String> dmPCDPropertyNameSet, Set<String> livePCDPropertyNameSet, Map<String, Property> livePropertyNameWithPropertyMap) {
        String livePIDFieldName;
        String dmPIDFieldName;
        String liveIDFieldName;
        String dmIDFieldName;
        HashSet<String> newLivePropertyNameSet = new HashSet<String>();
        newLivePropertyNameSet.addAll(livePCDPropertyNameSet);
        newLivePropertyNameSet.removeAll(dmPCDPropertyNameSet);
        if (!newLivePropertyNameSet.isEmpty()) {
            List<Property> dmEntityProperties = dmEntity.getProperties();
            for (String newLivePropertyName : newLivePropertyNameSet) {
                Property newLiveProperty = livePropertyNameWithPropertyMap.get(newLivePropertyName);
                dmEntityProperties.add(newLiveProperty);
            }
        }
        if (!(dmIDFieldName = dmEntityParild.getIdField()).equals(liveIDFieldName = liveEntityParid.getIdField())) {
            dmEntityParild.setIdField(liveIDFieldName);
        }
        if (!(dmPIDFieldName = dmEntityParild.getParentIdField()).equals(livePIDFieldName = liveEntityParid.getParentIdField())) {
            dmEntityParild.setParentIdField(livePIDFieldName);
        }
        String dmDisplayFieldName = dmEntityParild.getDefaultDisplayField();
        String liveDisplayFieldName = liveEntityParid.getDefaultDisplayField();
        if (dmDisplayFieldName == null || !dmDisplayFieldName.equals(liveDisplayFieldName)) {
            dmEntityParild.setDefaultDisplayField(liveDisplayFieldName);
        }
        String dmSortAccordingFieldName = dmEntityParild.getSortAccordingField();
        String liveSortAccordingFieldName = liveEntityParid.getSortAccordingField();
        if (dmSortAccordingFieldName == null || !dmSortAccordingFieldName.equals(liveSortAccordingFieldName)) {
            dmEntityParild.setSortAccordingField(liveSortAccordingFieldName);
        }
    }

    private static void importNewParild(Entity dmEntity, Parild liveEntityParid, Map<String, Property> livePropertyNameWithPropertyMap, Map<String, Set<String>> livePCDPropertyNameSetWithPCDNameMap) {
        String liveEntityParidName = liveEntityParid.getName();
        dmEntity.getParilds().add(liveEntityParid);
        Set<String> livePCDPropertyNameSet = livePCDPropertyNameSetWithPCDNameMap.get(liveEntityParidName);
        for (String livePCDPropertyName : livePCDPropertyNameSet) {
            Property liveProperty = livePropertyNameWithPropertyMap.get(livePCDPropertyName);
            dmEntity.getProperties().add(liveProperty);
        }
    }

    private static void removeParild(Iterator<Parild> dmEntityParidIterator, Set<String> pcdPropertyNameSet, Map<String, Property> dmPropertyNameWithPropertyMap) {
        dmEntityParidIterator.remove();
        if (pcdPropertyNameSet != null) {
            for (String pcdPropertyName : pcdPropertyNameSet) {
                Property pcdProperty = dmPropertyNameWithPropertyMap.get(pcdPropertyName);
                pcdProperty.setGroup(null);
            }
        }
    }
}

