/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubUnionEntityContext {
    private UnionEntity unionEntity;
    private Map<String, EntityFixContext> childrenEntityContext = new HashMap<String, EntityFixContext>();
    private Map<String, Property> localPropMap = new HashMap<String, Property>();
    private Map<String, Entity> entityMap = new HashMap<String, Entity>();
    private boolean isAllCalPropFixed = false;

    public SubUnionEntityContext(UnionEntity unionEntity) {
        this.unionEntity = unionEntity;
    }

    public EntityFixContext getEntityFixContext(String entityName) {
        return this.childrenEntityContext.get(entityName);
    }

    public boolean isAllCalPropFixed() {
        return this.isAllCalPropFixed;
    }

    public Entity findEntityByParentName(String parentEntityName) {
        for (Entity entity : this.unionEntity.getChildren()) {
            String parentName = entity.getParentName();
            if (null == parentName || !parentName.equals(parentEntityName)) continue;
            return entity;
        }
        return null;
    }

    public Map<String, Property> findMappingProperty(String basePropName) {
        HashMap<String, Property> mappingProperties = new HashMap<String, Property>();
        for (EntityFixContext entityFixContext : this.childrenEntityContext.values()) {
            Property property = entityFixContext.findMappingProperty(basePropName);
            if (null == property) continue;
            mappingProperties.put(entityFixContext.getLocal().getName(), property);
        }
        return mappingProperties;
    }

    public void setAllCalPropFixed(boolean allCalPropFixed) {
        this.isAllCalPropFixed = allCalPropFixed;
    }

    public void removeProps(List<Property> propRemoved) {
        for (Property property : propRemoved) {
            this.localPropMap.remove(property.getName());
        }
    }

    public void addNewProp(Property property) {
        this.localPropMap.put(property.getName(), property);
    }

    public Map<String, Property> getLocalPropMap() {
        return this.localPropMap;
    }

    public void prepare() {
        List<Property> properties = this.unionEntity.getProperties();
        for (Property property : properties) {
            this.localPropMap.put(property.getName(), property);
        }
        List<Entity> children = this.unionEntity.getChildren();
        for (Entity entity : children) {
            EntityFixContext entityFixContext = new EntityFixContext(entity);
            entityFixContext.prepare();
            this.childrenEntityContext.put(entity.getName(), entityFixContext);
            this.entityMap.put(entity.getName(), entity);
        }
    }

    public boolean containsEntity(String entityName) {
        return this.entityMap.containsKey(entityName);
    }
}

