/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.data.util.formate.DateFormateHelper;
import com.kingdee.bos.qing.data.util.formate.DateFormateMatchResult;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class DataTypeUtils {
    private static Pattern IntegerPattern = Pattern.compile("^-?([1-9]\\d*|0)$");
    private static Pattern NumericPattern = Pattern.compile("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$");

    public static boolean isInteger(String v) {
        return IntegerPattern.matcher(v).matches();
    }

    public static boolean isNumeric(String v) {
        return NumericPattern.matcher(v).matches();
    }

    public static boolean tryToBoolean(String v) {
        return "true".equalsIgnoreCase(v) || "false".equalsIgnoreCase(v);
    }

    public static String getDataTypeClassName(String strValue) {
        DateFormateMatchResult matchResult = DateFormateHelper.executeMatch(strValue);
        if (matchResult.isSucceed()) {
            return matchResult.isHasTime() ? "java.sql.Time" : "java.util.Date";
        }
        if (DataTypeUtils.isNumeric(strValue) || DataTypeUtils.isInteger(strValue)) {
            int dotIndex = (strValue = new BigDecimal(strValue).stripTrailingZeros().toPlainString()).lastIndexOf(46);
            if (dotIndex > 16) {
                return "java.lang.String";
            }
            if (DataTypeUtils.isInteger(strValue)) {
                double value = Double.parseDouble(strValue);
                if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                    return "java.lang.String";
                }
                return "java.lang.Long";
            }
            return "java.lang.Double";
        }
        if (DataTypeUtils.tryToBoolean(strValue)) {
            return "java.lang.Boolean";
        }
        return "java.lang.String";
    }
}

