/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.behavior;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.behavior.domain.BehaviorDomain;
import com.kingdee.bos.qing.behavior.model.BehaviorContext;
import com.kingdee.bos.qing.behavior.model.Data;
import com.kingdee.bos.qing.behavior.model.LogResult;
import com.kingdee.bos.qing.behavior.model.OperatingEnvMessage;
import com.kingdee.bos.qing.behavior.model.UserBehaviorSceneMessage;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.UserAgentUtil;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class BehaviorService
implements IQingContextable {
    private QingContext qingContext;
    private static final String CACHE_BEHAVIOR_OPERATING_ENV_KEY = "behaviorOperatingEnv";
    private static final String CACHE_BEHAVIOR_OPERATING_ENV_VALUE = "true";
    private static final String QING_BEHAVIOR_PRODUCT_NAME = System.getProperty("qing.behavior.product.name");
    private static final String QING_BEHAVIOR_PRODUCT_VERSION = System.getProperty("qing.behavior.product.version");
    private static final String QING_BEHAVIOR_PRODUCT_VERSION_PREFIX = System.getProperty("qing.behavior.product.version.prefix");
    private static final String QING_BEHAVIOR_QING_VERSION = System.getProperty("qing.behavior.bos.version");
    private static final String QING_BEHAVIOR_TEST_PRODUCTNO = "0000";

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public byte[] loadBehaviorContext(Map<String, String> params) {
        UserBehaviorSceneMessage userBehaviorSceneMessage = new UserBehaviorSceneMessage();
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)this.qingContext;
        Context ctx = qingIntegratedContext.getBosContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String accountId = qingIntegratedContext.getAccountId();
        String productNo = this.getProductNo(qingIntegratedContext);
        String qingUserId = userId + "," + accountId + "," + productNo;
        String productVersion = this.getProductVersion();
        userBehaviorSceneMessage.setQingUserId(qingUserId);
        userBehaviorSceneMessage.setUserId(userId);
        userBehaviorSceneMessage.setAccountId(accountId);
        userBehaviorSceneMessage.setProductNo(productNo);
        userBehaviorSceneMessage.setProductName(this.getProductName());
        userBehaviorSceneMessage.setProductVersion(productVersion);
        userBehaviorSceneMessage.setQingVersion(QING_BEHAVIOR_QING_VERSION);
        userBehaviorSceneMessage.setTime(System.currentTimeMillis());
        Data userBehaviorSceneData = new Data();
        userBehaviorSceneData.setLogtype(BehaviorDomain.getSceneLogType());
        userBehaviorSceneData.setMessage((Object)userBehaviorSceneMessage);
        LogResult operatingEnvLogResult = this.getOperatingEnvLogResult(this.qingContext);
        BehaviorContext behaviorContext = new BehaviorContext();
        behaviorContext.setUrl(BehaviorDomain.getBehaviorUrl());
        behaviorContext.setUserBehaviorSceneData(userBehaviorSceneData);
        behaviorContext.setOperatingEnvLogResult(operatingEnvLogResult);
        return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)behaviorContext));
    }

    private LogResult getOperatingEnvLogResult(QingContext qingContext) {
        IQingSession session = QingSessionUtil.getQingSessionImpl();
        String operatingEnvValue = session.get(CACHE_BEHAVIOR_OPERATING_ENV_KEY);
        if (null != operatingEnvValue && operatingEnvValue.equals(CACHE_BEHAVIOR_OPERATING_ENV_VALUE)) {
            return null;
        }
        session.set(CACHE_BEHAVIOR_OPERATING_ENV_KEY, CACHE_BEHAVIOR_OPERATING_ENV_VALUE);
        QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
        Context ctx = qingIntegratedContext.getBosContext();
        OperatingEnvMessage operatingEnvMessage = new OperatingEnvMessage();
        operatingEnvMessage.setIp(ContextUtil.getClientIP((Context)ctx));
        String userAgent = qingIntegratedContext.getUserAgent();
        String browserInfo = UserAgentUtil.getBrowser((String)userAgent);
        String[] browserParams = browserInfo.split("-");
        if (browserParams.length >= 2) {
            operatingEnvMessage.setBrowser(browserParams[0]);
            operatingEnvMessage.setBrowserVersion(browserParams[1]);
        } else {
            operatingEnvMessage.setBrowser("UnKnown, More-Info: " + userAgent);
            operatingEnvMessage.setBrowserVersion("UnKnown, More-Info: " + userAgent);
        }
        operatingEnvMessage.setClientOS(UserAgentUtil.getOperatingSystem((String)userAgent));
        operatingEnvMessage.setTime(System.currentTimeMillis());
        Properties properties = System.getProperties();
        operatingEnvMessage.setServerOS(properties.getProperty("os.name"));
        operatingEnvMessage.setServerOSVersion(properties.getProperty("os.version"));
        Data operatingEnvData = new Data();
        operatingEnvData.setLogtype(BehaviorDomain.getOpEnvLogType());
        operatingEnvData.setMessage((Object)operatingEnvMessage);
        ArrayList<Data> operatingEnvDataList = new ArrayList<Data>();
        operatingEnvDataList.add(operatingEnvData);
        LogResult operatingEnvLogResult = new LogResult();
        operatingEnvLogResult.setLogtype(BehaviorDomain.getOpEnvLogType());
        operatingEnvLogResult.setData(operatingEnvDataList);
        return operatingEnvLogResult;
    }

    public String getProductNo(QingContext qingContext) {
        String productNo = "";
        try {
            QingIntegratedContext qingIntegratedContext = (QingIntegratedContext)qingContext;
            Context ctx = qingIntegratedContext.getBosContext();
            LicenseBaseInfo license = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo();
            productNo = license.getSerialNum();
        }
        catch (Exception e) {
            LogUtil.error((String)"getProductNo error", (Throwable)e);
        }
        return productNo;
    }

    public String getProductVersion() {
        String productVersion = "";
        try {
            productVersion = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties((String)"EAS", (Locale)SysContext.getSysContext().getLocale());
            if (productVersion == null) {
                productVersion = QING_BEHAVIOR_PRODUCT_VERSION_PREFIX + QING_BEHAVIOR_PRODUCT_VERSION;
            } else {
                int index = productVersion.indexOf("V");
                productVersion = QING_BEHAVIOR_PRODUCT_VERSION_PREFIX + productVersion.substring(index + 1);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"getProductVersion error", (Throwable)e);
        }
        return productVersion;
    }

    public String getProductName() {
        return QING_BEHAVIOR_PRODUCT_NAME;
    }

    public byte[] loadDataSourceInfo(Map<String, String> params) {
        try {
            HashMap result = new HashMap();
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

