/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.bill.data.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.qing.bill.data.QueryDataProvider;
import com.kingdee.bos.qing.bill.data.proxy.QueryDataExecutorProxy;
import com.kingdee.bos.qing.bill.model.BillMeta;
import com.kingdee.bos.qing.bill.preparedata.DefaultFieldInfoHandler;
import com.kingdee.bos.qing.bill.preparedata.IMetaFieldNameBuilder;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.web.etl.model.QueryPageParameters;
import com.kingdee.bos.sql.ParserException;

public class ConfigurableBillDataProvider
extends QueryDataProvider {
    public ConfigurableBillDataProvider(QingContext qingContext, QueryPageParameters parameter) {
        super(qingContext, parameter);
        this.fieldHandler = new DefaultFieldInfoHandler(new IMetaFieldNameBuilder(){

            @Override
            public String buildFieldName(Field field) {
                return field.getEntity() + "." + field.getName();
            }
        });
    }

    @Override
    protected QingMeta buildQingMeta() throws PrepareDataException {
        String jsonAnalysisFields = this.parameter.getData().get("EntityAnalysisFields");
        BillMeta billMeta = (BillMeta)JsonUtil.decodeFromString((String)jsonAnalysisFields, BillMeta.class);
        QingMeta qingMeta = billMeta.toQingMeta();
        this.processQingMeta(qingMeta);
        return qingMeta;
    }

    @Override
    protected IDataProvider initQueryExecutor() throws ParserException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        LogUtil.warn((String)("qing embedded filter content:" + this.parameter.getFilterItems()));
        if (!StringUtils.isEmpty((CharSequence)this.parameter.getFilterItems())) {
            entityViewInfo.setFilter(new FilterInfo(this.parameter.getFilterItems()));
        }
        SelectorItemCollection selector = entityViewInfo.getSelector();
        for (Field field : this.getQingMeta().getColumns()) {
            if (!field.isSupportOrm()) continue;
            selector.add(field.getAssociateName().toUpperCase());
        }
        IQueryExecutor dataProvider = QueryExecutorFactory.getLocalInstance((Context)this.bosContext, (IMetaDataPK)MetaDataPK.create((String)this.parameter.getQueryPK()));
        dataProvider.setObjectView(entityViewInfo);
        dataProvider.option().isIgnoreOrder = true;
        dataProvider.option().isAutoIgnoreDuplicatedRow = true;
        dataProvider.option().isAutoTranslateBoolean = true;
        dataProvider.option().isAutoTranslateEnum = true;
        dataProvider.option().isIgnorePermissionCheck = false;
        QueryDataExecutorProxy proxy = new QueryDataExecutorProxy((IDataProvider)dataProvider, (IMetaDataPK)MetaDataPK.create((String)this.parameter.getQueryPK()), this.bosContext);
        if (proxy.isDistinct()) {
            return proxy;
        }
        return dataProvider;
    }
}

