/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.DBConnectionIntegratedException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class TXManageImpl
implements ITransactionManagement {
    private Connection _connection = null;
    private boolean _shouldCommite = true;
    private boolean _bInTx = false;
    private Context _context;

    public TXManageImpl(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public void beginRequired() throws AbstractQingIntegratedException {
        this._bInTx = true;
        try {
            this._connection = this.getConn();
        }
        catch (SQLException e) {
            LogUtil.debug((String)"faile to init connection.", (Throwable)e);
            this.closeConn();
            throw new DBConnectionIntegratedException(e.getMessage(), (Throwable)e);
        }
    }

    Connection getConn() throws SQLException {
        if (this._connection == null) {
            this._connection = EJBFactory.getConnection((Context)this._context);
            this._connection.setAutoCommit(false);
        }
        return this._connection;
    }

    public void closeConn() {
        CloseUtil.close((Connection)this._connection);
        this._connection = null;
    }

    public void markRollback() {
        this._shouldCommite = false;
        if (this._connection != null) {
            try {
                this._connection.rollback();
            }
            catch (SQLException e) {
                LogUtil.debug((String)"rollback tx faile.", (Throwable)e);
            }
        }
    }

    public void end() {
        this._bInTx = false;
        if (this._shouldCommite && this._connection != null) {
            try {
                this._connection.commit();
                this._connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                LogUtil.debug((String)"commit tx faile.", (Throwable)e);
            }
        }
        this.closeConn();
    }

    public boolean isInTX() {
        return this._bInTx;
    }
}

