/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.AbstractDashboardDesignService;
import com.kingdee.bos.qing.dashboard.domain.CommonDsbDesignDomain;
import com.kingdee.bos.qing.dashboard.extReport.domain.DsbExtReportDomain;
import com.kingdee.bos.qing.dashboard.extReport.model.ExtReportInfo;
import com.kingdee.bos.qing.dashboard.util.RefreshDataUtil;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.programablecard.domain.ProgramableCardDomain;
import com.kingdee.bos.qing.publish.appmenu.domain.AppMenuManageDomain;
import com.kingdee.bos.qing.publish.guimenu.domain.GUIMenuManageDomain;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DashboardService
extends AbstractDashboardDesignService {
    private DsbExtReportDomain extReportDomain;
    private static final String QING_PERMISSION_REPORT = "ctrl_report_management";
    private static final String REPORT_MANAGEMENT = "report_management";
    private AppMenuManageDomain appMenuManageDomain;
    private ProgramableCardDomain programableCardDomain;
    private GUIMenuManageDomain guiMenuManageDomain;
    private CommonDsbDesignDomain commonDsbDesignDomain;

    private CommonDsbDesignDomain getCommonDsbDesignDomain() {
        if (this.commonDsbDesignDomain == null) {
            this.commonDsbDesignDomain = new CommonDsbDesignDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.commonDsbDesignDomain;
    }

    private AppMenuManageDomain getAppMenuDomain() {
        if (this.appMenuManageDomain == null) {
            this.appMenuManageDomain = new AppMenuManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.appMenuManageDomain;
    }

    private GUIMenuManageDomain getGUIMenuManageDomain() {
        if (this.guiMenuManageDomain == null) {
            this.guiMenuManageDomain = new GUIMenuManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.guiMenuManageDomain;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] refreshData(Map<String, String> params) {
        try {
            ProgressModel progressModel = RefreshDataUtil.refreshDesignTimeData(params, this.qingContext, this.tx, this.dbExcuter, false);
            if (progressModel.isAsynResult()) {
                return null;
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)progressModel);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private DsbExtReportDomain getExtReportDomain() {
        if (this.extReportDomain == null) {
            this.extReportDomain = new DsbExtReportDomain();
            this.extReportDomain.setDbExcuter(this.dbExcuter);
            this.extReportDomain.setQingContext(this.qingContext);
        }
        return this.extReportDomain;
    }

    public byte[] getReportList(Map<String, String> params) {
        String reportType = params.get("reportType");
        try {
            List<ExtReportInfo> reportInfos = this.getExtReportDomain().getReportList(reportType);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(reportInfos));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getReportManagementPermission(Map<String, String> params) {
        try {
            boolean hasPermission = this.getExtReportDomain().hasPermissionByName(QING_PERMISSION_REPORT);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put(REPORT_MANAGEMENT, hasPermission);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(result));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private ProgramableCardDomain getProgramableCardDomain() {
        if (this.programableCardDomain == null) {
            this.programableCardDomain = new ProgramableCardDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.programableCardDomain;
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getAllProgramableCards(Map<String, String> params) {
        String userID = this.qingContext.getUserId();
        try {
            FolderNode root = this.getProgramableCardDomain().getAllProgramableCard(userID);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)root);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] checkProgramableChartExist(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getProgramableCardDomain().getProgramableCardAvailable(params));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public final byte[] getProgramableCardReferenceMap(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getCommonDsbDesignDomain().getReferenceMap(params, RefTypeEnum.programableCard));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAppMenuTree(Map<String, String> params) {
        try {
            Map<String, Object> treeMenuFolderNode = this.getAppMenuDomain().getAppMenuTreeForDsb();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(treeMenuFolderNode));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAppMenuTreeForExtreport(Map<String, String> params) {
        return new byte[0];
    }

    public byte[] loadAppmenuPublish(Map<String, String> params) {
        try {
            String path = params.get("path");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getAppMenuDomain().loadPublishInfosForDsb(path)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadGUIMenuTree(Map<String, String> params) {
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getGUIMenuManageDomain().getGUITreeForDsb()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadGUIMenuPublish(Map<String, String> params) {
        try {
            String path = params.get("path");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getGUIMenuManageDomain().loadPublishInfosForDsb(path)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

