/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.entityparser;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.qing.data.domain.entityparser.LinkPropertyInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.OwnPropertyInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.PropertyInfoParser;
import com.kingdee.bos.qing.data.domain.entityparser.RelationshipEntityObject;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import java.util.HashMap;
import java.util.Map;

public class EntityObjectInfoParser {
    private static Map<Class<? extends PropertyInfo>, PropertyInfoParser> propInfoParsers = new HashMap<Class<? extends PropertyInfo>, PropertyInfoParser>();

    public void parseEntityInfo(RelationshipEntityObject relationEntity, Context ctx, QingMeta qingMeta) throws Exception {
        EntryEntity entryEntity = this.createEntryEntity(relationEntity, qingMeta);
        if (null == entryEntity) {
            return;
        }
        qingMeta.addEntryEntity(entryEntity);
        EntityObjectInfo currentEntityInfo = relationEntity.getCurrentEntityInfo();
        for (PropertyInfo pi : currentEntityInfo.getInheritedProperties()) {
            PropertyInfoParser propParser = propInfoParsers.get(pi.getClass());
            if (null == propParser) continue;
            propParser.parsePropertyInfo(pi, currentEntityInfo, ctx, qingMeta);
            String value = pi.getExtendedProperty("isMainBizOrg");
            if (!"true".equalsIgnoreCase(value)) continue;
            entryEntity.setMainOrgBizProp(pi);
        }
    }

    private EntryEntity createEntryEntity(RelationshipEntityObject relationEntity, QingMeta qingMeta) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        EntityObjectInfo currentEntityInfo = relationEntity.getCurrentEntityInfo();
        EntityObjectInfo parentEntityInfo = relationEntity.getParentEntityInfo();
        String entityName = currentEntityInfo.getName();
        if (qingMeta.getEntryEntity(entityName) != null) {
            return null;
        }
        EntryEntity entryEntity = new EntryEntity();
        entryEntity.setName(entityName);
        entryEntity.setKey(currentEntityInfo.getFullName());
        IObjectValue objectValue = (IObjectValue)currentEntityInfo.getObjectValueClazzRuntime().newInstance();
        PropertyInfo propertyInfo = currentEntityInfo.getPropertyByName(objectValue.getPKField());
        if (propertyInfo != null && propertyInfo.getMappingField() != null) {
            String pkFieldName = propertyInfo.getName();
            entryEntity.setPkFieldName(pkFieldName);
        }
        if (null != parentEntityInfo) {
            EntryEntity parent = qingMeta.getEntryEntity(parentEntityInfo.getName());
            entryEntity.setParent(parent);
            parent.addChildEntry(entryEntity);
            entryEntity.setParentKey(parentEntityInfo.getFullName());
            entryEntity.setParentName(parentEntityInfo.getName());
            entryEntity.setLinkPropertyToParent((LinkPropertyInfo)relationEntity.getLinkPropertyInfo().getRelationship().getSupplierProperty());
            qingMeta.getEntryEntity(parentEntityInfo.getName()).setLinkPropertyToEntry(entryEntity.getName(), relationEntity.getLinkPropertyInfo());
        }
        String sMainEntityDisplayName = currentEntityInfo.getAlias();
        entryEntity.setAlias(sMainEntityDisplayName);
        return entryEntity;
    }

    static {
        propInfoParsers.put(LinkPropertyInfo.class, new LinkPropertyInfoParser());
        propInfoParsers.put(OwnPropertyInfo.class, new OwnPropertyInfoParser());
    }
}

