/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.scanAllEntity;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.runtime.EasRuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.process.FixProcesser;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.util.EntityNameKeySelector;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.MapUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EntityScanDomain {
    private static final int rowHeight = 24;
    private static final int colWidth = 100;
    private AbstractDataSourceDomain sourceDomain;
    private QingContext qingContext;
    private AbstractSource source;
    private List<AbstractSource> sources;
    private Sheet sheet;
    private int currentRowIndex = 0;

    public EntityScanDomain(AbstractDataSourceDomain sourceDomain, QingContext qingContext, AbstractSource source) {
        this.sourceDomain = sourceDomain;
        this.qingContext = qingContext;
        this.source = source;
        this.sources = new ArrayList<AbstractSource>();
        this.sources.add(source);
    }

    public void scanEntities(IQingFile exportFile) throws SubjectDataModelingException {
        String DEFAULT_SHEET_NAME = "Qing";
        final SXSSFWorkbook wb = new SXSSFWorkbook(50);
        try {
            AbstractNode node = this.sourceDomain.getUsableEntities(this.qingContext, this.source);
            ArrayList<String> nodePaths = new ArrayList<String>();
            this.sheet = wb.createSheet(DEFAULT_SHEET_NAME);
            this.createHeader();
            this.getDesigntimeDataObject(node, nodePaths);
            exportFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    wb.write(outputStream);
                    outputStream.flush();
                }
            }, true);
        }
        catch (Throwable e) {
            try {
                throw new SubjectDataModelingException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{wb});
                wb.dispose();
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{wb});
        wb.dispose();
    }

    private void getDesigntimeDataObject(AbstractNode node, List<String> nodePaths) {
        block4: {
            block3: {
                if (!(node instanceof FolderNode)) break block3;
                FolderNode folderNode = (FolderNode)node;
                for (AbstractNode abstractNode : folderNode.getChildren()) {
                    ArrayList<String> newNodePaths = new ArrayList<String>();
                    newNodePaths.addAll(nodePaths);
                    newNodePaths.add(abstractNode.getDisplayName());
                    this.getDesigntimeDataObject(abstractNode, newNodePaths);
                }
                break block4;
            }
            if (!(node instanceof LeafNode)) break block4;
            LeafNode leafNode = (LeafNode)node;
            DesigntimeDataObject designtimeDataObject = null;
            try {
                designtimeDataObject = this.sourceDomain.getDesigntimeDataObject(this.qingContext, this.source, leafNode.getName());
                this.getPreviewData(designtimeDataObject, nodePaths);
            }
            catch (Exception e) {
                this.createGetDesigntimeDataObjectException(leafNode, nodePaths, e);
            }
        }
    }

    private void getPreviewData(DesigntimeDataObject designtimeDataObject, List<String> nodePaths) {
        List entities = designtimeDataObject.getEntities();
        HashMap<String, AbstractEntity> parentEntities = new HashMap<String, AbstractEntity>();
        ArrayList<Entity> allEntities = new ArrayList<Entity>();
        for (AbstractEntity abstractEntity : entities) {
            if (!(abstractEntity instanceof Entity)) continue;
            allEntities.add((Entity)abstractEntity);
            parentEntities.put(abstractEntity.getName(), abstractEntity);
        }
        for (AbstractEntity abstractEntity : allEntities) {
            if (abstractEntity.getProperties().isEmpty()) continue;
            try {
                FixProcesser.fixEntityForPreview((QingContext)this.qingContext, (AbstractEntity)abstractEntity, (AbstractSource)this.source, allEntities);
                ArrayList<Entity> entityList = allEntities;
                Map allEntityNamesMap = MapUtils.collectionToMap(entityList, (MapUtils.IMapKeySelector)new EntityNameKeySelector());
                EasRuntimeEntity runtimeEntity = new EasRuntimeEntity(abstractEntity, null, this.source, this.qingContext, this.qingContext.getUserId());
                runtimeEntity.init(null);
                EasRuntimeEntity runtimeEntityTemp = runtimeEntity;
                AbstractEntity parentEntity = null;
                String parentName = abstractEntity.getParentName();
                while (parentName != null) {
                    parentEntity = (AbstractEntity)allEntityNamesMap.get(parentName);
                    parentName = parentEntity.getParentName();
                    EasRuntimeEntity parentRuntimeEntity = new EasRuntimeEntity(parentEntity, null, this.source, this.qingContext, this.qingContext.getUserId());
                    parentRuntimeEntity.init(null);
                    runtimeEntityTemp.setParentEntity(parentRuntimeEntity);
                    runtimeEntityTemp = parentRuntimeEntity;
                }
                this.sourceDomain.getPreviewData(this.qingContext, (RuntimeEntity)runtimeEntity, 10);
            }
            catch (Exception e) {
                this.createGetPreviewDataException(e, nodePaths, abstractEntity);
            }
        }
    }

    private void createHeader() {
        Row head = this.sheet.createRow(0);
        head.setHeight((short)UnitUtil.pixelToTwip((long)24L));
        int columnIndex = 0;
        Cell cell = head.createCell(columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u7c7b\u578b");
        cell = head.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u8def\u5f84");
        cell = head.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u5355\u636e\u7f16\u7801");
        cell = head.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u5b9e\u4f53\u540d\u79f0");
        cell = head.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u5b9e\u4f53\u7f16\u7801");
        cell = head.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u5f02\u5e38\u4fe1\u606f");
    }

    private void createGetDesigntimeDataObjectException(LeafNode leafNode, List<String> nodePaths, Exception e) {
        ++this.currentRowIndex;
        Row rowData = this.sheet.createRow(this.currentRowIndex);
        int columnIndex = 0;
        Cell cell = rowData.createCell(columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u83b7\u53d6\u5b9e\u4f53\u7ed3\u6784\u5931\u8d25");
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(nodePaths.toString());
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(leafNode.getName());
        ++columnIndex;
        ++columnIndex;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        String exception = sw.toString();
        int length = exception.length();
        if (exception.length() > 32760) {
            length = 32760;
        }
        cell.setCellValue(exception.substring(0, length));
    }

    private void createGetPreviewDataException(Exception e, List<String> nodePaths, AbstractEntity entity) {
        ++this.currentRowIndex;
        Row rowData = this.sheet.createRow(this.currentRowIndex);
        int columnIndex = 0;
        Cell cell = rowData.createCell(columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue("\u67e5\u8be2\u5b9e\u4f53\u6570\u636e\u5931\u8d25");
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(nodePaths.toString());
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(entity.getAssociateName());
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(entity.getAlias());
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        cell.setCellValue(entity.getName());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        cell = rowData.createCell(++columnIndex);
        this.sheet.setColumnWidth(columnIndex, (int)UnitUtil.pixelToExcelWidth((double)100.0));
        String exception = sw.toString();
        int length = exception.length();
        if (exception.length() > 32760) {
            length = 32760;
        }
        cell.setCellValue(exception.substring(0, length));
    }
}

