/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.easmeta;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.domain.BizMetaUtil;
import com.kingdee.bos.qing.data.domain.DesignObjectBuilder;
import com.kingdee.bos.qing.data.domain.entityparser.QueriedEntityObjectInfoParser;
import com.kingdee.bos.qing.data.domain.exception.DataEntityException;
import com.kingdee.bos.qing.data.domain.exception.DataMetaException;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.easmeta.AbstractMetaSourceDomain;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.QueryJoinCollectionBuilder;
import com.kingdee.bos.qing.data.domain.source.entityviewbuilder.RTQueryJoinCollectionBuilder;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.entity.EntityNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.MetaSource;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuerySourceDomain
extends AbstractMetaSourceDomain {
    private static final HashMap<ConstDataType, DesigningDataType> constDataTypeMap = new HashMap();
    private static Map<String, AbstractNode> cacheRootMetaNode;

    public static DesigningDataType toDesigningDataType(ConstDataType bosType) {
        return constDataTypeMap.get(bosType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        this.checkEASPermission(qingContext);
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        String language = ctx.getLocale().toString();
        AbstractNode rootMetaNode = cacheRootMetaNode.get(language);
        if (rootMetaNode == null) {
            Map<String, AbstractNode> map = cacheRootMetaNode;
            synchronized (map) {
                rootMetaNode = cacheRootMetaNode.get(language);
                if (rootMetaNode != null) {
                    return rootMetaNode;
                }
                IBriefViewTreeNode rootNode = BizMetaUtil.getQueryTreeRootNode(ctx);
                rootMetaNode = this.convertToQingNode(rootNode, MetaSource.MetaType.EASQuery.name());
                cacheRootMetaNode.put(language, rootMetaNode);
            }
        }
        return rootMetaNode;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractSourceException, AbstractQingIntegratedException {
        PreviewDataModel result = null;
        try {
            result = super.getPreviewData(qingContext, runtimeEntity, rows);
        }
        catch (DataMetaException e) {
            String msg = "preview query " + e.getMessage();
            throw DataEntityException.fail2Preview((Throwable)((Object)e), msg);
        }
        return result;
    }

    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String tableName) throws AbstractSourceException, AbstractQingIntegratedException {
        Context ctx = ((QingIntegratedContext)qingContext).getBosContext();
        QueryInfo queryInfo = (QueryInfo)this.getMetaInfo(ctx, tableName);
        if (queryInfo == null) {
            throw new EntityNotFoundException("query entity not found,name:" + tableName);
        }
        QingMeta qingMeta = new QingMeta();
        QueriedEntityObjectInfoParser entityObjectInfoParser = new QueriedEntityObjectInfoParser();
        entityObjectInfoParser.parseEntityInfo(ctx, queryInfo, qingMeta);
        String associateName = queryInfo.getFullName();
        try {
            IQingTableMetaProcessor metaProcessor = this.getTableMetaProcessor(associateName);
            HashMap<String, Object> contextDatas = new HashMap<String, Object>();
            contextDatas.put("bosContext", ctx);
            contextDatas.put("qingContext", qingContext);
            contextDatas.put("isForQuery", Boolean.TRUE);
            TableMetaKey metaKey = new TableMetaKey(associateName, contextDatas);
            metaProcessor.processTableMeta(new TableMetaObject((Object)qingMeta, metaKey));
        }
        catch (Exception e) {
            throw DataMetaException.fail2Modeling(e, "process qing meta error");
        }
        return new DesignObjectBuilder().buildFromQingMeta(qingMeta, source);
    }

    @Override
    protected RTQueryJoinCollectionBuilder getJoinCollectionBuilder(RuntimeEntity runtimeEntity, Context ctx) {
        return new QueryJoinCollectionBuilder(ctx, runtimeEntity);
    }

    @Override
    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, AbstractQingIntegratedException {
        try {
            super.extractData(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
        }
        catch (DataMetaException e) {
            String msg = "extract query " + e.getMessage();
            throw DataEntityException.fail2Extract((Throwable)((Object)e), msg);
        }
        return null;
    }

    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
    }

    @Override
    protected boolean checkAvailabel(IBriefViewTreeNode bvNode) {
        return true;
    }

    @Override
    protected AbstractMetaDataValue getMetaInfo(Context ctx, String fullName) {
        return this.getDataLoader(ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)fullName));
    }

    @Override
    protected IDataProvider getMetaExecutor(Context ctx, String fullName) {
        return QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)fullName));
    }

    static {
        constDataTypeMap.put(ConstDataType.INT, DesigningDataType.INT);
        constDataTypeMap.put(ConstDataType.NUMBER, DesigningDataType.NUMBER);
        constDataTypeMap.put(ConstDataType.STRING, DesigningDataType.STRING);
        constDataTypeMap.put(ConstDataType.DATE, DesigningDataType.DATE);
        constDataTypeMap.put(ConstDataType.TIME, DesigningDataType.DATETIME);
        constDataTypeMap.put(ConstDataType.TIMESTAMP, DesigningDataType.DATETIME);
        constDataTypeMap.put(ConstDataType.BOOLEAN, DesigningDataType.BOOLEAN);
        constDataTypeMap.put(ConstDataType.ENUM, DesigningDataType.STRING);
        constDataTypeMap.put(ConstDataType.OBJECT, DesigningDataType.STRING);
        constDataTypeMap.put(ConstDataType.UNKNOWN, DesigningDataType.STRING);
        constDataTypeMap.put(null, DesigningDataType.STRING);
        cacheRootMetaNode = new HashMap<String, AbstractNode>();
    }
}

