/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.entityviewbuilder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.runtime.EasEntityExtension;
import com.kingdee.bos.qing.data.model.runtime.IMetaRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.RuleUtil;
import java.util.ArrayList;

public class SqlFilterInfoBuilder {
    private QingContext qingContext;
    private RuntimeEntity runtimeEntity;

    public SqlFilterInfoBuilder(QingContext qingContext, RuntimeEntity runtimeEntity) {
        this.qingContext = qingContext;
        this.runtimeEntity = runtimeEntity;
    }

    public FilterInfo buildFilter() throws ParserException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        IMetaRuntimeFilter iMetaRuntimeFilter = (IMetaRuntimeFilter)this.runtimeEntity.getPushdownableFilter();
        if (iMetaRuntimeFilter != null && !iMetaRuntimeFilter.isInvalid()) {
            ArrayList<FilterItemInfo> itemInfos = new ArrayList<FilterItemInfo>();
            iMetaRuntimeFilter.setFilterItemInfos(itemInfos);
            String sqlWhere = iMetaRuntimeFilter.toSqlWhere(this.runtimeEntity);
            if (sqlWhere != null && sqlWhere.length() > 0) {
                filterInfo.setMaskString(sqlWhere);
                for (FilterItemInfo itemInfo : itemInfos) {
                    filterInfo.getFilterItems().add(itemInfo);
                }
            }
        }
        RuntimeEntity currentEntity = this.runtimeEntity;
        do {
            String permissionRule;
            String bizOrgFieldName;
            EasEntityExtension extension;
            if (null == (extension = (EasEntityExtension)currentEntity.getExtension(EasEntityExtension.class))) {
                currentEntity = currentEntity.getParentEntity();
                continue;
            }
            Property pkProperty = extension.getLocalPkProperty();
            if (null != pkProperty) {
                String fieldName = pkProperty.getAssociateName();
                FilterItemInfo itemInfo = new FilterItemInfo(fieldName + " is not null");
                FilterInfo filterField = new FilterInfo();
                filterField.getFilterItems().add(itemInfo);
                filterInfo = RuleUtil.mergeFilterInfo((FilterInfo)filterInfo, (FilterInfo)filterField, (String)"and");
            }
            if (!StringUtil.isEmptyString((String)(bizOrgFieldName = extension.getBizOrgPropName()))) {
                String sql = " (select forgid from t_pm_orgrange where fuserid = '" + this.qingContext.getUserId() + "' and ftype = 10)";
                FilterItemInfo itemInfo = new FilterItemInfo(bizOrgFieldName + " in " + sql);
                FilterInfo filterField = new FilterInfo();
                filterField.getFilterItems().add(itemInfo);
                filterInfo = RuleUtil.mergeFilterInfo((FilterInfo)filterInfo, (FilterInfo)filterField, (String)"and");
            }
            if (!StringUtil.isEmptyString((String)(permissionRule = extension.getPermisionDataRule()))) {
                EntityViewInfo entityPermRule = new EntityViewInfo(permissionRule);
                FilterInfo filterPermRule = entityPermRule.getFilter();
                if (null != filterPermRule) {
                    String parentPropertyName = extension.getParentFullFieldName();
                    if (parentPropertyName != null) {
                        filterPermRule.setEntryName(parentPropertyName);
                    }
                    filterPermRule.setEntryilterType(EntryFilterType.NORMAL);
                    filterPermRule = new FilterInfo(filterPermRule.toSql());
                    filterInfo = RuleUtil.mergeFilterInfo((FilterInfo)filterInfo, (FilterInfo)filterPermRule, (String)"and");
                } else {
                    LogUtil.warn((String)("get entity permission filter error:" + permissionRule));
                }
            }
            currentEntity = currentEntity.getParentEntity();
        } while (currentEntity != null);
        return filterInfo;
    }
}

