/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource;

import com.kingdee.bos.qing.data.domain.source.db.DataTypeToDesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.MetaInfoDecodeUtil;
import com.kingdee.bos.qing.datasource.meta.view.AbstractDSViewItem;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaEntitySubView;
import com.kingdee.bos.qing.datasource.meta.view.DSMetaFieldItem;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCloseListener;
import com.kingdee.bos.qing.datasource.spec.qs.QingStorageWriterWraper;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceCloseListener
implements IDataSourceCloseListener {
    private RuntimeEntity runtimeEntity;
    private Map<Integer, ITreePropertyHandler> treePropertyHandlerMap = new HashMap<Integer, ITreePropertyHandler>();

    public DataSourceCloseListener(RuntimeEntity runtimeEntity) {
        this.runtimeEntity = runtimeEntity;
    }

    private void fixMetaInfoSubviewAndItems(RuntimeEntity runtimeEntity, MetaInfo metaInfo) {
        Entity entity = (Entity)runtimeEntity.getOrinalEntity();
        List treeProperties = entity.getTreeNodeProperties();
        HashSet<String> excludePropertySet = new HashSet<String>();
        for (TreeProperty treeProperty : treeProperties) {
            ITreePropertyHandler treePropertyHandler = this.treePropertyHandlerMap.get(treeProperty.getTreeType());
            treePropertyHandler.handleSubViewAndViewItems(treeProperty, metaInfo, excludePropertySet);
        }
        this.setViewItems(runtimeEntity, metaInfo, excludePropertySet);
    }

    private void setViewItems(RuntimeEntity runtimeEntity, MetaInfo metaInfo, Set<String> handledPropertySet) {
        if (metaInfo.getSubViews() == null || metaInfo.getSubViews().isEmpty()) {
            return;
        }
        Entity dmEntity = (Entity)runtimeEntity.getOrinalEntity();
        ArrayList subItems = new ArrayList(10);
        ArrayList<DSMetaFieldItem> dateSubViewItems = new ArrayList<DSMetaFieldItem>(10);
        ArrayList<DSMetaFieldItem> stringSubViewItems = new ArrayList<DSMetaFieldItem>(10);
        ArrayList<DSMetaFieldItem> numberSubViewItems = new ArrayList<DSMetaFieldItem>(10);
        List selectedPropertyList = dmEntity.getProperties();
        for (Property property : selectedPropertyList) {
            if (property.isInvalidForParent() || !property.isDataModelSupported() || handledPropertySet.contains(property.getName())) continue;
            switch (property.getDataType()) {
                case DATE: 
                case DATETIME: {
                    dateSubViewItems.add(new DSMetaFieldItem(property.getName()));
                    break;
                }
                case STRING: 
                case BOOLEAN: {
                    stringSubViewItems.add(new DSMetaFieldItem(property.getName()));
                    break;
                }
                case NUMBER: 
                case INT: {
                    numberSubViewItems.add(new DSMetaFieldItem(property.getName()));
                    break;
                }
            }
        }
        subItems.addAll(dateSubViewItems);
        subItems.addAll(stringSubViewItems);
        subItems.addAll(numberSubViewItems);
        metaInfo.setViewItems(subItems);
    }

    private void addMetaFieldForNew(RuntimeEntity runtimeEntity, MetaInfo metaInfo) {
        MetaInfo original = runtimeEntity.getMetaInfo();
        int totalFieldSize = original.getSize();
        ArrayList newHideInfos = new ArrayList(original.getFieldIsHides());
        Entity entity = (Entity)runtimeEntity.getOrinalEntity();
        Map treePropertyMap = MapUtils.collectionToMap((Collection)entity.getTreeNodeProperties(), (MapUtils.IMapKeySelector)new MapUtils.IMapKeySelector<TreeProperty>(){

            public String getKey(TreeProperty treeProperty) {
                return treeProperty.getName();
            }
        });
        Map allPropertiesMap = runtimeEntity.getAllPropertiesMap();
        for (int i = 0; i < totalFieldSize; ++i) {
            String fieldName = original.getFieldName(i);
            RuntimeProperty runtimeProperty = (RuntimeProperty)allPropertiesMap.get(fieldName);
            if (null == runtimeProperty || runtimeProperty.getParentProp() != null) continue;
            boolean isTreeProperty = runtimeProperty.hasChild();
            boolean isHide = isTreeProperty ? true : (Boolean)newHideInfos.get(i);
            metaInfo.addField(fieldName, original.getFieldDisplayName(i), original.getFieldDataType(i), isHide);
            if (!isTreeProperty) continue;
            TreeProperty treeProperty = (TreeProperty)treePropertyMap.get(fieldName);
            ITreePropertyHandler treePropertyHandler = this.treePropertyHandlerMap.get(treeProperty.getTreeType());
            treePropertyHandler.handleMetaField(treeProperty, metaInfo);
        }
    }

    public void doCloseBefore(QingStorageWriterWraper writerWraper) {
        MetaInfo newMeta = new MetaInfo();
        this.treePropertyHandlerMap.put(0, new FlexFieldTreePropertyHandler(this.runtimeEntity));
        this.addMetaFieldForNew(this.runtimeEntity, newMeta);
        this.fixMetaInfoSubviewAndItems(this.runtimeEntity, newMeta);
        newMeta.setDsParentChildDimensions(this.runtimeEntity.getMetaInfo().getDsParentChildDimensions());
        newMeta.setEliminations(this.runtimeEntity.getMetaInfo().getEliminations());
        writerWraper.addExtraData(".metadata.", MetaInfoDecodeUtil.encode((MetaInfo)newMeta));
    }

    private class FlexFieldTreePropertyHandler
    implements ITreePropertyHandler {
        private RuntimeEntity runtimeEntity;

        public FlexFieldTreePropertyHandler(RuntimeEntity runtimeEntity) {
            this.runtimeEntity = runtimeEntity;
        }

        @Override
        public void handleMetaField(TreeProperty treeProperty, MetaInfo metaInfo) {
            List children = treeProperty.getChildren();
            Map allPropertiesMap = this.runtimeEntity.getAllPropertiesMap();
            for (Property property : children) {
                if (treeProperty.isHideInAnalysis()) {
                    metaInfo.addField(property.getName(), property.getAlias(), DataTypeToDesigningDataType.designtimeToRuntime((DesigningDataType)property.getOutputDataType()), true);
                    continue;
                }
                RuntimeProperty childRuntimeProp = (RuntimeProperty)allPropertiesMap.get(property.getName());
                boolean isHide = childRuntimeProp.isChildPropHideInAnalysis();
                metaInfo.addField(property.getName(), property.getAlias(), DataTypeToDesigningDataType.designtimeToRuntime((DesigningDataType)property.getOutputDataType()), isHide);
            }
        }

        @Override
        public void handleSubViewAndViewItems(TreeProperty treeProperty, MetaInfo metaInfo, Set<String> handledPropertySet) {
            Map allPropertiesMap = this.runtimeEntity.getAllPropertiesMap();
            DSMetaEntitySubView newFlexFieldSubView = new DSMetaEntitySubView(treeProperty.getName(), treeProperty.getInnerProp().getAlias(), 1);
            for (Property child : treeProperty.getChildren()) {
                handledPropertySet.add(child.getName());
                RuntimeProperty childRuntimeProp = (RuntimeProperty)allPropertiesMap.get(child.getName());
                boolean isHide = childRuntimeProp.isChildPropHideInAnalysis();
                if (isHide) continue;
                newFlexFieldSubView.addViewItem((AbstractDSViewItem)new DSMetaFieldItem(child.getName()));
            }
            if (treeProperty.isHideInAnalysis()) {
                return;
            }
            if (null == metaInfo.getSubViews()) {
                metaInfo.setSubViews(new ArrayList());
            }
            metaInfo.getSubViews().add(newFlexFieldSubView);
        }
    }

    private static interface ITreePropertyHandler {
        public void handleMetaField(TreeProperty var1, MetaInfo var2);

        public void handleSubViewAndViewItems(TreeProperty var1, MetaInfo var2, Set<String> var3);
    }
}

