/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.biz.voucher;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.Scene;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.flexfield.domain.FlexMetaSourceDomain;
import com.kingdee.bos.qing.data.flexfield.model.FlexProperty;
import com.kingdee.bos.qing.preparedata.handler.controller.model.ComplexField;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.web.i18n.Messages;
import com.kingdee.eas.base.permission.PermissionFactory;
import java.util.List;

public class VoucherMetaProcessor
implements IQingTableMetaProcessor {
    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        Scene scene = (Scene)tableMetaObject.getMetaKey().getMetaContextInfo("processScene");
        DefaultI18nContext ii18nContext = new DefaultI18nContext();
        String entryEntityName = scene == Scene.EMBBEDED ? "entries" : "VoucherEntry";
        Field flexField = qingMeta.getField("assGrp", entryEntityName);
        if (null != flexField) {
            QingContext qingContext = (QingContext)tableMetaObject.getMetaKey().getMetaContextInfo("qingContext");
            ComplexField complexField = new ComplexField();
            complexField.setName(flexField.getName());
            complexField.setAlias(flexField.getAlias());
            complexField.setEntity(flexField.getEntity());
            complexField.setAssociateName(flexField.getAssociateName());
            complexField.setFieldType(QingFieldType.String.toNumber());
            complexField.setHide(true);
            Context boxCtx = (Context)tableMetaObject.getMetaKey().getMetaContextInfo("bosContext");
            List<FlexProperty> flexPropertys = FlexMetaSourceDomain.getFlexFieldMeta(boxCtx);
            if (flexPropertys.size() == 0) {
                LogUtil.error((String)"empty flex field inner props");
                return;
            }
            for (FlexProperty flexProp : flexPropertys) {
                Field numberField = new Field();
                numberField.setName(complexField.getName() + "." + flexProp.getNumber() + "." + "FNumber");
                String numberAlias = Messages.getLangMessage((II18nContext)ii18nContext, "base_flex_number", "Number");
                numberField.setAlias(flexProp.getName() + "." + numberAlias);
                numberField.setEntity(complexField.getEntity());
                numberField.setSupportOrm(false);
                numberField.setFieldType(QingFieldType.String.toNumber());
                numberField.setHide(true);
                complexField.addInnerField(numberField);
                Field nameField = new Field();
                nameField.setName(complexField.getName() + "." + flexProp.getNumber() + "." + "FName");
                String nameAlias = Messages.getLangMessage((II18nContext)ii18nContext, "base_flex_name", "Name");
                nameField.setAlias(flexProp.getName() + "." + nameAlias);
                nameField.setEntity(complexField.getEntity());
                nameField.setSupportOrm(false);
                nameField.setFieldType(QingFieldType.String.toNumber());
                nameField.setHide(true);
                complexField.addInnerField(nameField);
            }
            qingMeta.replaceField("assGrp", entryEntityName, complexField);
            if (!this.hasAssActTypeViewPermission(qingContext)) {
                return;
            }
            Field recordEntryIdField = new Field();
            recordEntryIdField.setName("assistRecords.id");
            recordEntryIdField.setFieldType(QingFieldType.String.toNumber());
            recordEntryIdField.setHide(true);
            recordEntryIdField.setAlias("\u8f85\u52a9\u5e10ID");
            recordEntryIdField.setEntity(entryEntityName);
            recordEntryIdField.setSupportQingDataModel(false);
            recordEntryIdField.setAssociateName(entryEntityName.toUpperCase() + "." + "assistRecords.id".toUpperCase());
            qingMeta.getEntryEntity(entryEntityName).addField(recordEntryIdField);
            qingMeta.addColumn(recordEntryIdField);
            Field assGrpIdField = new Field();
            assGrpIdField.setName("assistRecords.assGrp.id");
            assGrpIdField.setFieldType(QingFieldType.String.toNumber());
            assGrpIdField.setHide(true);
            assGrpIdField.setAlias("\u6838\u7b97\u9879\u76eeID");
            assGrpIdField.setEntity(entryEntityName);
            assGrpIdField.setSupportQingDataModel(false);
            assGrpIdField.setAssociateName(entryEntityName.toUpperCase() + "." + "assistRecords.assGrp.id".toUpperCase());
            qingMeta.getEntryEntity(entryEntityName).addField(assGrpIdField);
            qingMeta.addColumn(assGrpIdField);
            Field assNumberGrpField = new Field();
            assNumberGrpField.setName("assistRecords.assGrp.numberGroup");
            assNumberGrpField.setFieldType(QingFieldType.String.toNumber());
            assNumberGrpField.setHide(true);
            assNumberGrpField.setAlias("\u6838\u7b97\u9879\u76ee\u7ec4\u5408");
            assNumberGrpField.setEntity(entryEntityName);
            assNumberGrpField.setSupportQingDataModel(false);
            assNumberGrpField.setAssociateName(entryEntityName.toUpperCase() + "." + "assistRecords.assGrp.numberGroup".toUpperCase());
            qingMeta.getEntryEntity(entryEntityName).addField(assNumberGrpField);
            qingMeta.addColumn(assNumberGrpField);
        }
    }

    protected boolean hasAssActTypeViewPermission(QingContext qingContext) {
        Context bosCtx = ((QingIntegratedContext)qingContext).getBosContext();
        ObjectUuidPK userPK = new ObjectUuidPK(qingContext.getUserId());
        ObjectUuidPK orgPK = new ObjectUuidPK(qingContext.getSystemVar(SystemVarType.ORG_ID).toString());
        try {
            return PermissionFactory.getRemoteInstanceWithObjectContext((Context)bosCtx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "bd_accaux_asstActType_view");
        }
        catch (Exception e) {
            LogUtil.error((String)"", (Throwable)e);
            return false;
        }
    }

    public void dispose() {
    }
}

