/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.data.domain.source.easmeta.AbstractMetaSourceDomain;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingFieldType;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.web.i18n.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BillMetaFieldProcessor
implements IQingTableMetaProcessor {
    private static final String TRUE_KEY = "true_key";
    private static final String FALSE_KEY = "false_key";

    public void processTableMeta(TableMetaObject tableMetaObject) {
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        String queryPk = metaKey.getMetaKey();
        if (StringUtils.isBlank((CharSequence)queryPk)) {
            return;
        }
        Context boxCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        IMetaDataLoader dataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)boxCtx);
        QueryInfo query = dataLoader.getQuery((IMetaDataPK)MetaDataPK.create((String)queryPk));
        SubObjectInfo mainObject = null;
        try {
            if (query instanceof JoinQueryInfo) {
                mainObject = QueryUtil.getMainObject((JoinQueryInfo)((JoinQueryInfo)query));
                Map<String, PropertyInfo> fieldInfoMap = this.getAllFieldInfoByQueryPK(mainObject);
                QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
                List<Field> fields = qingMeta.getColumns();
                DefaultI18nContext ii18nContext = new DefaultI18nContext();
                for (Field field : fields) {
                    String associateName = field.getAssociateName();
                    PropertyInfo pi = fieldInfoMap.get(associateName.toUpperCase());
                    boolean aliableEnum = this.isAliableEnum(pi);
                    if (aliableEnum) {
                        field.setFieldType(QingFieldType.String.toNumber());
                        try {
                            Map<String, String> enumMap = AbstractMetaSourceDomain.getEnumMap(boxCtx, pi);
                            if (enumMap == null || enumMap.size() <= 0) continue;
                            field.setEnumItems(enumMap);
                        }
                        catch (BOSException e) {
                            String msg = pi.getName() + " getEnum " + e.getMessage();
                            LogUtil.error((String)msg, (Throwable)e);
                        }
                        continue;
                    }
                    if (field.getFieldType() != QingFieldType.Boolean.toNumber()) continue;
                    HashMap<String, String> boolMap = new HashMap<String, String>();
                    boolMap.put(Boolean.TRUE.toString(), Messages.getLangMessage((II18nContext)ii18nContext, TRUE_KEY, "\u662f"));
                    boolMap.put(Boolean.FALSE.toString(), Messages.getLangMessage((II18nContext)ii18nContext, FALSE_KEY, "\u5426"));
                    field.setEnumItems(boolMap);
                }
            }
        }
        catch (BOSException e) {
            LogUtil.error((String)"", (Throwable)e);
        }
    }

    private boolean isAliableEnum(PropertyInfo fld) {
        return fld != null && fld instanceof OwnPropertyInfo && ((OwnPropertyInfo)fld).getDataType().equals((Object)DataType.ENUM);
    }

    private Map<String, PropertyInfo> getAllFieldInfoByQueryPK(SubObjectInfo mainObject) throws BOSException {
        HashMap<String, PropertyInfo> fieldInfoMap = new HashMap<String, PropertyInfo>();
        if (mainObject instanceof SubEntityInfo) {
            for (PropertyInfo pi : ((SubEntityInfo)mainObject).getEntityRef().getInheritedNoDuplicatedProperties()) {
                if (pi instanceof LinkPropertyInfo) {
                    LinkPropertyInfo info = (LinkPropertyInfo)pi;
                    RelationshipInfo relationshipInfo = info.getRelationship();
                    EntityObjectInfo supplierObject = relationshipInfo.getSupplierObject();
                    for (PropertyInfo piInfo : supplierObject.getPropertiesRuntime()) {
                        String fullPropName = info.getName() + "." + piInfo.getName();
                        fieldInfoMap.put(fullPropName.toUpperCase(), piInfo);
                    }
                    continue;
                }
                String fullPropName = mainObject.getName() + "." + pi.getName();
                fieldInfoMap.put(fullPropName.toUpperCase(), pi);
            }
        }
        return fieldInfoMap;
    }

    public void dispose() {
    }
}

