/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local.inner;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.data.domain.BizMetaUtil;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.util.List;

public class EntityBizOrgPropNameProcessor
implements IQingTableMetaProcessor {
    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        Context bosCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        List<EntryEntity> entitys = qingMeta.getEntryEntities();
        for (EntryEntity entryEntity : entitys) {
            String associateName = entryEntity.getKey();
            AbstractMetaDataValue entityObj = this.getMetaInfo(bosCtx, associateName);
            this.setBizOrgPropName(qingMeta, entryEntity, entityObj);
        }
    }

    private AbstractMetaDataValue getMetaInfo(Context ctx, String fullName) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityObj = metaDataLoader.getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        return entityObj;
    }

    private void setBizOrgPropName(QingMeta qingMeta, EntryEntity entryEntity, AbstractMetaDataValue metaInfo) {
        EntityObjectInfo entityInfo = (EntityObjectInfo)metaInfo;
        OrgType mainOrgType = PermissionCommonUtil.getMainBizOrgType((EntityObjectInfo)entityInfo);
        if (OrgType.NONE.equals((Object)mainOrgType)) {
            return;
        }
        try {
            IObjectValue objectValue = (IObjectValue)entityInfo.getObjectValueClazzRuntime().newInstance();
            if (objectValue instanceof CoreBillBaseInfo) {
                this.setBizOrgNameForHeadEntry(qingMeta, entryEntity, (CoreBillBaseInfo)objectValue);
                return;
            }
            if (objectValue instanceof CoreBillEntryBaseInfo) {
                this.setBizOrgNameForSubEntry(qingMeta, entryEntity, (CoreBillEntryBaseInfo)objectValue);
                return;
            }
            this.setBizOrgNameIfExtendInfoExist(entryEntity);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private void setBizOrgNameForSubEntry(QingMeta qingMeta, EntryEntity entryEntity, CoreBillEntryBaseInfo objectValue) {
        String bizOrgName = objectValue.getBizOrgPropertyName();
        boolean isLinkedProp = bizOrgName.contains(".");
        if (isLinkedProp) {
            bizOrgName = bizOrgName.split(".")[0];
        }
        if (!this.setBizOrgNameIfFieldExist(qingMeta, entryEntity, bizOrgName)) {
            this.setBizOrgNameIfExtendInfoExist(entryEntity);
        }
    }

    private boolean setBizOrgNameIfFieldExist(QingMeta qingMeta, EntryEntity entryEntity, String orgName) {
        if (StringUtil.isEmptyString((String)orgName)) {
            return false;
        }
        Field field = qingMeta.getField(orgName, entryEntity.getName());
        if (null != field) {
            String fieldPrefix = BizMetaUtil.getFieldPrefix(entryEntity);
            PropertyInfo pi = (PropertyInfo)field.getCustomInfo("propertyInfo");
            if (pi instanceof LinkPropertyInfo) {
                entryEntity.setBizOrgPropName(fieldPrefix + orgName + ".id");
            } else {
                entryEntity.setBizOrgPropName(fieldPrefix + orgName);
            }
            return true;
        }
        return false;
    }

    private void setBizOrgNameForHeadEntry(QingMeta qingMeta, EntryEntity entryEntity, CoreBillBaseInfo billBaseInfo) {
        String orgName = billBaseInfo.getBizOrgPropertyName();
        if (!this.setBizOrgNameIfFieldExist(qingMeta, entryEntity, orgName)) {
            this.setBizOrgNameIfExtendInfoExist(entryEntity);
        }
    }

    private void setBizOrgNameIfExtendInfoExist(EntryEntity entryEntity) {
        PropertyInfo mainOrgBizProp = entryEntity.getMainOrgBizProp();
        if (mainOrgBizProp != null) {
            String fieldPrefix = BizMetaUtil.getFieldPrefix(entryEntity);
            if (mainOrgBizProp instanceof LinkPropertyInfo) {
                entryEntity.setBizOrgPropName(fieldPrefix + mainOrgBizProp.getName() + ".id");
            } else {
                entryEntity.setBizOrgPropName(fieldPrefix + mainOrgBizProp.getName());
            }
        }
    }

    private String getOrgNameFromBizUnitInfo(EntityObjectInfo entityInfo) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CoreBillEntryBaseInfo billBaseInfo;
        IObjectValue objectValue = (IObjectValue)entityInfo.getObjectValueClazzRuntime().newInstance();
        String orgName = null;
        if (objectValue instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo billBaseInfo2 = (CoreBillBaseInfo)objectValue;
            orgName = billBaseInfo2.getBizOrgPropertyName();
        } else if (objectValue instanceof CoreBillEntryBaseInfo && null != (orgName = (billBaseInfo = (CoreBillEntryBaseInfo)objectValue).getBizOrgPropertyName()) && orgName.contains(".")) {
            orgName = orgName.split(".")[0];
        }
        return orgName;
    }

    public void dispose() {
    }
}

