/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local.inner;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableMetaProcessor;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.util.List;

public class QueriedEntityBizOrgPropNameProcessor
implements IQingTableMetaProcessor {
    protected void setBizOrgPropName(QingMeta qingMeta, EntryEntity entryEntity, AbstractMetaDataValue metaInfo) {
        EntityObjectInfo entityInfo = this.getMainEntityInfo(metaInfo);
        if (entityInfo == null || metaInfo instanceof UnionQueryInfo) {
            return;
        }
        OrgType mainOrgType = PermissionCommonUtil.getMainBizOrgType((EntityObjectInfo)entityInfo);
        if (OrgType.NONE.equals((Object)mainOrgType)) {
            return;
        }
        try {
            IObjectValue objectValue = (IObjectValue)entityInfo.getObjectValueClazzRuntime().newInstance();
            if (objectValue instanceof CoreBillBaseInfo) {
                CoreBillBaseInfo billBaseInfo = (CoreBillBaseInfo)objectValue;
                String name = billBaseInfo.getBizOrgPropertyName();
                if (!this.setBizOrgIfFieldExistInEntity(entryEntity, entityInfo, name)) {
                    this.setBizOrgIfExistInExpandProp(entryEntity, entityInfo);
                }
                return;
            }
            if (objectValue instanceof CoreBillEntryBaseInfo) {
                String orgName = ((CoreBillEntryBaseInfo)objectValue).getBizOrgPropertyName();
                if (!this.setBizOrgIfFieldExistInEntity(entryEntity, entityInfo, orgName = this.getPropertyName(entityInfo, metaInfo, orgName))) {
                    this.setBizOrgIfExistInExpandProp(entryEntity, entityInfo);
                }
                return;
            }
            this.setBizOrgIfExistInExpandProp(entryEntity, entityInfo);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private void setBizOrgIfExistInExpandProp(EntryEntity entryEntity, EntityObjectInfo entityInfo) {
        for (PropertyInfo pi : entityInfo.getInheritedNoDuplicatedPropertiesRuntime()) {
            String value = pi.getExtendedProperty("isMainBizOrg");
            if (!"true".equalsIgnoreCase(value)) continue;
            if (pi instanceof LinkPropertyInfo) {
                entryEntity.setBizOrgPropName(pi.getName() + ".id");
                break;
            }
            entryEntity.setBizOrgPropName(pi.getName());
            break;
        }
    }

    private boolean setBizOrgIfFieldExistInEntity(EntryEntity entryEntity, EntityObjectInfo entityInfo, String name) {
        Object pi = null;
        for (PropertyInfo propertyInfo : entityInfo.getInheritedProperties()) {
            if (!propertyInfo.getName().equals(name)) continue;
            if (propertyInfo instanceof LinkPropertyInfo) {
                entryEntity.setBizOrgPropName(propertyInfo.getName() + ".id");
            } else {
                entryEntity.setBizOrgPropName(propertyInfo.getName());
            }
            return true;
        }
        return false;
    }

    protected String getPropertyName(EntityObjectInfo entityInfo, AbstractMetaDataValue metaInfo, String name) {
        String[] attrs;
        if (metaInfo instanceof QueryInfo && name != null && name.indexOf(".") > 0 && entityInfo.getPropertyByName((attrs = name.split("\\."))[0]) != null) {
            SubEntityInfo sub = this.findEntityInfoByName((QueryInfo)metaInfo, attrs[0]);
            if (sub != null) {
                if (sub.getEntityRef().getPropertyByName(attrs[1]) instanceof LinkPropertyInfo) {
                    sub = this.findEntityInfoByName((QueryInfo)metaInfo, attrs[1]);
                    name = sub != null ? name + ".id" : null;
                }
                return name;
            }
            return null;
        }
        return name;
    }

    private SubEntityInfo findEntityInfoByName(QueryInfo queryInfo, String name) {
        for (SubObjectInfo objectInfo : queryInfo.getSubObjects()) {
            SubEntityInfo sub;
            if (!(objectInfo instanceof SubEntityInfo) || !(sub = (SubEntityInfo)objectInfo).getName().equalsIgnoreCase(name)) continue;
            return sub;
        }
        return null;
    }

    protected EntityObjectInfo getMainEntityInfo(AbstractMetaDataValue metaInfo) {
        try {
            SubObjectInfo mainObject = ((QueryInfo)metaInfo).getMainObject();
            if (mainObject instanceof SubEntityInfo) {
                SubEntityInfo subInfo = (SubEntityInfo)mainObject;
                return subInfo.getEntityRef();
            }
        }
        catch (BOSException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected AbstractMetaDataValue getMetaInfo(Context ctx, String fullName) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return metaDataLoader.getQuery((IMetaDataPK)MetaDataPK.create((String)fullName));
    }

    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        Context bosCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        List<EntryEntity> entitys = qingMeta.getEntryEntities();
        for (EntryEntity entryEntity : entitys) {
            String associateName = entryEntity.getKey();
            AbstractMetaDataValue entityObj = this.getMetaInfo(bosCtx, associateName);
            this.setBizOrgPropName(qingMeta, entryEntity, entityObj);
        }
    }

    public void dispose() {
    }
}

