/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.extension.local.inner;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.qing.api.customtable.model.TableMetaKey;
import com.kingdee.bos.qing.api.customtable.model.TableMetaObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.extension.local.inner.EntityPermissionDataRuleProcessor;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;

public class QueriedEntityPermissionDataRuleProcessor
extends EntityPermissionDataRuleProcessor {
    @Override
    public void processTableMeta(TableMetaObject tableMetaObject) {
        QingMeta qingMeta = (QingMeta)tableMetaObject.getQingMeta();
        TableMetaKey metaKey = tableMetaObject.getMetaKey();
        Context bosCtx = (Context)metaKey.getMetaContextInfo("bosContext");
        QingContext qingCtx = (QingContext)metaKey.getMetaContextInfo("qingContext");
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
        List<EntryEntity> entitys = qingMeta.getEntryEntities();
        for (EntryEntity entryEntity : entitys) {
            String associateName = entryEntity.getKey();
            QueryInfo metaInfo = metaDataLoader.getQuery((IMetaDataPK)MetaDataPK.create((String)associateName));
            if (metaInfo instanceof UnionQueryInfo) continue;
            EntityObjectInfo entityObj = this.getMainEntityInfo((AbstractMetaDataValue)metaInfo);
            try {
                this.setPermissionRule(entryEntity, entityObj, qingCtx, bosCtx);
            }
            catch (Exception e) {
                LogUtil.error((String)"", (Throwable)e);
            }
        }
    }

    protected EntityObjectInfo getMainEntityInfo(AbstractMetaDataValue metaInfo) {
        try {
            SubObjectInfo mainObject = ((QueryInfo)metaInfo).getMainObject();
            if (mainObject instanceof SubEntityInfo) {
                SubEntityInfo subInfo = (SubEntityInfo)mainObject;
                return subInfo.getEntityRef();
            }
        }
        catch (BOSException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

