/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfo;
import com.kingdee.bos.qing.dbmanage.model.DBRefInfoVO;
import com.kingdee.bos.qing.dbmanage.reference.IProviderDBRefDetail;
import com.kingdee.bos.qing.macro.dao.MacroManageDao;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;

public class DBRefDetailProvider
implements IProviderDBRefDetail {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private MacroManageDao macroManageDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private MacroManageDao getMacroManageDao() {
        if (this.macroManageDao == null) {
            this.macroManageDao = new MacroManageDao(this.dbExcuter);
        }
        return this.macroManageDao;
    }

    public DBRefInfoVO getDBRefDetail(DBRefInfo dbRefInfo) throws AbstractQingIntegratedException, SQLException {
        DBRefInfoVO dbRefInfoVO = new DBRefInfoVO();
        String macroId = dbRefInfo.getFromId();
        Macro macro = this.getMacroManageDao().loadMacro(macroId);
        if (macro == null) {
            return null;
        }
        dbRefInfoVO.setName(macro.getName());
        dbRefInfoVO.setFullPath(macro.getName());
        dbRefInfoVO.setCreatorName(IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)dbRefInfo.getCreatorId()));
        dbRefInfoVO.setCreateTime(dbRefInfo.getCreateTime().getTime());
        dbRefInfoVO.setRefFromType(dbRefInfo.getFromType());
        return dbRefInfoVO;
    }
}

