/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.ormrpc;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.init.QingInitializeHelper;
import com.kingdee.bos.qing.common.session.AbstractGlobalQingSession;
import com.kingdee.bos.qing.common.session.AbstractQingSession;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.strategy.session.JVMSessionFactoryStrategyImpl;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.ormrpc.IBudgetService;
import com.kingdee.bos.qing.ormrpc.IGlobalQingSessionService;
import com.kingdee.bos.qing.ormrpc.IQingORMRPCDispatcher;
import com.kingdee.bos.qing.ormrpc.IQingSessionService;
import com.kingdee.bos.qing.ormrpc.RPCResultWrapper;
import com.kingdee.bos.qing.publish.AbstractPublishManageService;
import com.kingdee.bos.qing.publish.PublishServcieFactory;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MethodInvokeUtil;
import com.kingdee.bos.qing.util.QingIntegratedUtil;
import com.kingdee.bos.qing.util.QingServerRequestDispatcher;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.util.BOSObjectType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class QingORMRPCDispatcher
extends AbstractBOSObject
implements IQingORMRPCDispatcher,
IBudgetService,
IQingSessionService,
IGlobalQingSessionService {
    protected static Logger logger;
    private static JVMSessionFactoryStrategyImpl jvmSessionFactory;
    private static volatile AbstractGlobalQingSession globalQingSession;
    private int offset;
    private byte[] resultStr;
    private boolean isORMRPC;

    public QingORMRPCDispatcher(Context ctx) {
        super(ctx);
    }

    @Override
    public void setORMRPC(boolean isORMRPC) {
        this.isORMRPC = isORMRPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IGlobalQingSession getGlobalQingSession() {
        if (globalQingSession != null) return globalQingSession;
        Class<QingORMRPCDispatcher> clazz = QingORMRPCDispatcher.class;
        synchronized (QingORMRPCDispatcher.class) {
            if (globalQingSession != null) return globalQingSession;
            globalQingSession = jvmSessionFactory.createSessionlessCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalQingSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RPCResultWrapper dispatch(QingIntegratedContext qingCtx, String method, Object ... parameters) throws AbstractQingException {
        byte[] temp;
        QingIntegratedUtil.initQingIntegratedContext(qingCtx);
        int maxSize = 0xA00000;
        if (this.resultStr == null) {
            QingServerRequestDispatcher serverRequestDispatcher = new QingServerRequestDispatcher(qingCtx);
            this.resultStr = (byte[])MethodInvokeUtil.invoke((QingContext)qingCtx, (Object)((Object)serverRequestDispatcher), (String)method, (Object[])parameters);
            if (this.resultStr == null) {
                return new RPCResultWrapper(null, Boolean.TRUE);
            }
            if (!this.isORMRPC || this.resultStr.length <= maxSize) {
                try {
                    RPCResultWrapper rPCResultWrapper = new RPCResultWrapper(this.resultStr, Boolean.TRUE);
                    return rPCResultWrapper;
                }
                finally {
                    this.resultStr = null;
                }
            }
        }
        if (this.offset + maxSize < this.resultStr.length) {
            temp = new byte[maxSize];
            System.arraycopy(this.resultStr, this.offset, temp, 0, maxSize);
            this.offset += maxSize;
            return new RPCResultWrapper(temp, Boolean.FALSE);
        }
        temp = new byte[this.resultStr.length - this.offset];
        System.arraycopy(this.resultStr, this.offset, temp, 0, temp.length);
        this.resultStr = null;
        return new RPCResultWrapper(temp, Boolean.TRUE);
    }

    @Override
    public byte[] deletePublishInfo(QingIntegratedContext qingCtx, Map<String, String> params) throws AbstractQingException {
        QingIntegratedUtil.initQingIntegratedContext(qingCtx);
        String sPublishTargetType = params.get("publishTargetType");
        Integer iPublishTargetType = null;
        if (sPublishTargetType != null && !"".equals(sPublishTargetType)) {
            iPublishTargetType = Integer.valueOf(sPublishTargetType);
        }
        AbstractPublishManageService publishManageService = PublishServcieFactory.createPublishServcie(iPublishTargetType);
        return (byte[])MethodInvokeUtil.invoke((QingContext)qingCtx, (Object)publishManageService, (String)"deletePublishInfo", (Object[])new Object[]{params});
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public byte[] downloadBudgetDataFile(QingIntegratedContext qingCtx, String filePath) throws IOException {
        QingIntegratedUtil.initQingIntegratedContext(qingCtx);
        IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)filePath);
        if (qingFileVisitor.exists()) {
            return FileFactory.getFileContent((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)filePath);
        }
        return null;
    }

    @Override
    public void uploadBudgetDataFile(QingIntegratedContext qingCtx, String filePath, byte[] in) throws IOException {
        QingIntegratedUtil.initQingIntegratedContext(qingCtx);
        IQingFileUpdater qingFileUpdater = FileFactory.newFileUpdater(null, (AbstractQingFileType)QingPersistentFileType.BUDGET, (String)filePath);
        if (qingFileUpdater.exists()) {
            qingFileUpdater.delete();
        }
        LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, filePath);
        qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new ByteArrayInputStream(in), true), true);
    }

    @Override
    public void uploadBudgetDataFileFinish(QingIntegratedContext qingCtx, final String filePath, final int fileCount) throws IOException {
        LocalPersistentQingFile qingFile = new LocalPersistentQingFile(QingPersistentFileType.BUDGET, filePath);
        if (qingFile.exists()) {
            qingFile.delete();
        }
        qingFile.write(new IWriteCall(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(OutputStream outputStream) throws IOException {
                try {
                    BufferedInputStream inputStream = null;
                    for (int i = 0; i < fileCount; ++i) {
                        String subFileNameKey = filePath + "." + i;
                        IQingFileVisitor subQingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.BUDGET, (String)subFileNameKey);
                        inputStream = new BufferedInputStream((InputStream)subQingFile.getInputStream());
                        try {
                            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    }
                }
                finally {
                    for (int i = 0; i < fileCount; ++i) {
                        IQingFileUpdater qingFileUpdater = FileFactory.newFileUpdater(null, (AbstractQingFileType)QingPersistentFileType.BUDGET, (String)(filePath + "." + i));
                        if (!qingFileUpdater.exists()) continue;
                        qingFileUpdater.delete();
                    }
                }
            }
        }, true);
    }

    @Override
    public boolean deleteBudgetDataFile(QingIntegratedContext qingCtx, String filePath) {
        QingIntegratedUtil.initQingIntegratedContext(qingCtx);
        IQingFileUpdater qingFileUpdater = FileFactory.newFileUpdater(null, (AbstractQingFileType)QingPersistentFileType.BUDGET, (String)filePath);
        if (qingFileUpdater.exists()) {
            return qingFileUpdater.delete();
        }
        return true;
    }

    @Override
    public boolean getQsFileStatus(QingIntegratedContext qingCtx, String filePath) {
        IQingFileUpdater qingFileUpdater = FileFactory.newFileUpdater(null, (AbstractQingFileType)QingPersistentFileType.BUDGET, (String)filePath);
        int fileCheckTimeLimit = SystemPropertyUtil.getInt((String)"qing_budget_file_check_time_limit", (int)120);
        int fileCheckTimeOut = 0;
        boolean isFileExist = qingFileUpdater.exists();
        while (!isFileExist) {
            isFileExist = qingFileUpdater.exists();
            try {
                Thread.sleep(1000L);
                if (++fileCheckTimeOut < fileCheckTimeLimit) continue;
                break;
            }
            catch (InterruptedException e) {
                LogUtil.error((String)e.getMessage());
            }
        }
        return isFileExist;
    }

    @Override
    public String get(String sessionId, String key) {
        AbstractQingSession qingSession = jvmSessionFactory.createSessionableCache(sessionId);
        return qingSession.get(key);
    }

    @Override
    public void set(String sessionId, String key, String value) {
        AbstractQingSession qingSession = jvmSessionFactory.createSessionableCache(sessionId);
        qingSession.set(key, value);
    }

    @Override
    public void remove(String sessionId, String key) {
        AbstractQingSession qingSession = jvmSessionFactory.createSessionableCache(sessionId);
        qingSession.remove(key);
    }

    @Override
    public String get(String key) {
        return QingORMRPCDispatcher.getGlobalQingSession().get(key);
    }

    @Override
    public byte[] getByteData(String key) {
        return QingORMRPCDispatcher.getGlobalQingSession().getByteData(key);
    }

    @Override
    public void remove(String key) {
        QingORMRPCDispatcher.getGlobalQingSession().remove(key);
    }

    @Override
    public void set(String key, String value, int timeout, TimeUnit timeUnit) {
        QingORMRPCDispatcher.getGlobalQingSession().set(key, value, timeout, timeUnit);
    }

    @Override
    public void expireAfter(String paramString, int paramInt, TimeUnit paramTimeUnit) {
        QingORMRPCDispatcher.getGlobalQingSession().expireAfter(paramString, paramInt, paramTimeUnit);
    }

    @Override
    public void hSet(String key, String subKey, String value, int timeout, TimeUnit timeUnit) {
        QingORMRPCDispatcher.getGlobalQingSession().hSet(key, subKey, value, timeout, timeUnit);
    }

    @Override
    public String hGet(String key, String subKey) {
        return QingORMRPCDispatcher.getGlobalQingSession().hGet(key, subKey);
    }

    @Override
    public void hRemove(String key, String subKey) {
        QingORMRPCDispatcher.getGlobalQingSession().hRemove(key, subKey);
    }

    @Override
    public List<String> hKeys(String key) {
        return QingORMRPCDispatcher.getGlobalQingSession().hKeys(key);
    }

    @Override
    public long incrBy(String key, int count) {
        return QingORMRPCDispatcher.getGlobalQingSession().incrBy(key, count);
    }

    @Override
    public void addToSet(String key, String[] values) {
        QingORMRPCDispatcher.getGlobalQingSession().addToSet(key, values);
    }

    @Override
    public void addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        QingORMRPCDispatcher.getGlobalQingSession().addToSet(key, values, timeout, timeUnit);
    }

    @Override
    public String[] getSetValues(String key) {
        return QingORMRPCDispatcher.getGlobalQingSession().getSetValues(key);
    }

    @Override
    public void removeSetValue(String key, String[] valuesToRemove) {
        QingORMRPCDispatcher.getGlobalQingSession().removeSetValue(key, valuesToRemove);
    }

    static {
        QingInitializeHelper.initializeOnStart();
        logger = Logger.getLogger(QingORMRPCDispatcher.class);
        jvmSessionFactory = new JVMSessionFactoryStrategyImpl();
    }
}

