/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.datasource.meta.DSElimination;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.preparedata.exception.BillFormException;
import com.kingdee.bos.qing.preparedata.handler.IPageDataProvider;
import com.kingdee.bos.qing.preparedata.handler.QingMetaToDSEliminations;
import com.kingdee.bos.qing.preparedata.handler.controller.IQingDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingData;
import com.kingdee.bos.qing.preparedata.handler.controller.model.QingMeta;
import com.kingdee.bos.qing.preparedata.model.Pager;
import com.kingdee.bos.qing.preparedata.util.FieldTypeUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.web.etl.model.ControllerPageParameters;
import com.kingdee.eas.common.EASBizException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControllerDataProvider
implements IPageDataProvider {
    private Context ctx;
    private ControllerPageParameters controllerPageParameters;
    private String tag;
    private MetaInfo metaInfo;
    private QingMeta qingMeta;
    private List<String> originalFieldNames = new ArrayList<String>();
    private List<DataType> unmodifiableFieldDataTypes = new ArrayList<DataType>();
    private Map<String, Map<String, String>> enumItemsMap = new HashMap<String, Map<String, String>>();
    private IQingDataProvider iQingDataProvider;
    private Pager pager;

    public ControllerDataProvider(String tag, Context ctx, ControllerPageParameters controllerPageParameters) {
        this.tag = tag;
        this.ctx = ctx;
        this.controllerPageParameters = controllerPageParameters;
        this.pager = new Pager();
    }

    public QingMeta getQingMeta() {
        return this.qingMeta;
    }

    @Override
    public MetaInfo getMeta() throws BillFormException {
        try {
            this.qingMeta = this.getQingDataProvider().getMeta(this.controllerPageParameters.getTag());
        }
        catch (EASBizException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap repeatedNameIndex = new HashMap();
        List<Field> columns = this.qingMeta.getColumns();
        this.metaInfo = new MetaInfo();
        for (Field field : columns) {
            String originalName = field.getName();
            this.originalFieldNames.add(originalName);
            String pureFieldName = NameUtil.getPureName((String)originalName, repeatedNameIndex);
            nameMap.put(originalName, pureFieldName);
            this.metaInfo.addField(pureFieldName, field.getAlias(), FieldTypeUtil.changeQingFieldTypeToDataType(field.getFieldType()), field.isHide());
            if (field.getEnumItems() == null) continue;
            this.enumItemsMap.put(originalName, field.getEnumItems());
        }
        QingMetaToDSEliminations converter = new QingMetaToDSEliminations(this.qingMeta);
        List<DSElimination> eliminations = converter.getDSEliminations(nameMap);
        this.metaInfo.setEliminations(eliminations);
        this.unmodifiableFieldDataTypes = this.metaInfo.getFieldDataTypes();
        return this.metaInfo;
    }

    @Override
    public Pager nextPage() throws BillFormException {
        this.pager.nextPage();
        int pageSize = (int)this.pager.getPageSize();
        int startIndex = this.pager.getStartIndex();
        long startTime = System.currentTimeMillis();
        QingData qingData = null;
        try {
            qingData = this.getQingDataProvider().getData(this.controllerPageParameters.getTag(), startIndex, pageSize);
            LogUtil.info((String)("qing ControllerDataProvider one page size = " + qingData.getRows().size() + "; bizTag = " + this.controllerPageParameters.getBizTag()));
        }
        catch (EASBizException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new BillFormException(e.getMessage(), e);
        }
        LogUtil.info((String)("getQingDataOfObject cost time:" + (System.currentTimeMillis() - startTime) + " className:" + this.iQingDataProvider.getClass().getName() + "; tag:" + this.tag));
        List<Object[]> datas = this.parseData(qingData.getDataindex(), qingData.getRows());
        this.pager.setData(datas);
        return this.pager;
    }

    @Override
    public void dispose() throws BillFormException {
        try {
            this.getQingDataProvider().dispose(this.controllerPageParameters.getTag());
        }
        catch (Exception e) {
            throw new BillFormException(e.getMessage(), e);
        }
    }

    private IQingDataProvider getQingDataProvider() throws BillFormException {
        if (this.iQingDataProvider == null) {
            try {
                String className = this.controllerPageParameters.getClassName();
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(Context.class);
                this.iQingDataProvider = (IQingDataProvider)constructor.newInstance(this.ctx);
            }
            catch (Exception e) {
                throw new BillFormException(e.getMessage(), e);
            }
        }
        return this.iQingDataProvider;
    }

    private List<Object[]> parseData(Map<String, Integer> dataIndex, List<Object[]> rows) {
        if (rows == null || rows.isEmpty()) {
            return rows;
        }
        HashMap<String, Integer> dataIndexCleared = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : dataIndex.entrySet()) {
            dataIndexCleared.put(entry.getKey(), entry.getValue());
        }
        dataIndex = dataIndexCleared;
        int[] fieldIndexs = new int[this.originalFieldNames.size()];
        for (int i = 0; i < this.originalFieldNames.size(); ++i) {
            String fieldName = this.originalFieldNames.get(i);
            fieldIndexs[i] = !dataIndex.containsKey(fieldName) || dataIndex.get(fieldName) == null ? -1 : dataIndex.get(fieldName);
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int indexOfRow = 0; indexOfRow < rows.size(); ++indexOfRow) {
            Object[] rowGot = rows.get(indexOfRow);
            Object[] rowStoraged = new Object[this.originalFieldNames.size()];
            for (int j = 0; j < fieldIndexs.length; ++j) {
                String sValue;
                int indexAtRowGot = fieldIndexs[j];
                if (indexAtRowGot < 0) continue;
                DataType dataType = this.unmodifiableFieldDataTypes.get(j);
                Object value = rowGot[indexAtRowGot];
                if (value == null) continue;
                if (dataType == DataType.DATE) {
                    rowStoraged[j] = this.getAsDate(value);
                    continue;
                }
                if (dataType == DataType.DATETIME) {
                    rowStoraged[j] = this.getAsDate(value);
                    continue;
                }
                if (dataType == DataType.INT) {
                    sValue = value.toString();
                    rowStoraged[j] = new Long(sValue);
                    continue;
                }
                if (dataType == DataType.NUMBER) {
                    sValue = value.toString();
                    rowStoraged[j] = new BigDecimal(sValue);
                    continue;
                }
                if (dataType == DataType.BOOLEAN) {
                    sValue = value.toString();
                    rowStoraged[j] = Boolean.valueOf(sValue);
                    continue;
                }
                rowStoraged[j] = value;
                if (!this.enumItemsMap.containsKey(this.originalFieldNames.get(j))) continue;
                Map<String, String> enumMap = this.enumItemsMap.get(this.originalFieldNames.get(j));
                String[] valueArr = String.valueOf(value).split(",");
                if (enumMap.containsKey(value.toString())) {
                    rowStoraged[j] = enumMap.get(value.toString());
                    continue;
                }
                if (valueArr.length <= 1) continue;
                String enumStr = "";
                for (int i = 0; i < valueArr.length; ++i) {
                    if (enumMap.get(valueArr[i]) == null) continue;
                    enumStr = enumStr + enumMap.get(valueArr[i]);
                    if (i == valueArr.length - 1) continue;
                    enumStr = enumStr + ",";
                }
                rowStoraged[j] = enumStr;
            }
            data.add(rowStoraged);
        }
        return data;
    }

    private Date getAsDate(Object value) {
        Long dateValue;
        if (value instanceof Double) {
            dateValue = ((Double)value).longValue();
        } else if (value instanceof Long) {
            dateValue = (Long)value;
        } else if (value instanceof Integer) {
            dateValue = new Long(((Integer)value).intValue());
        } else {
            throw new RuntimeException("expected " + value + " to be a Long, but got " + value.getClass());
        }
        Date date = new Date();
        date.setTime(dateValue);
        return date;
    }
}

