/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.programablecard.util;

import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ChartRequestUtil {
    private static String urlPrefix;
    private static final String CHART_DEL_URL = "/easweb/webframework/dynamic/chart.do?method=operateCustomChart&type=delete";
    private static final String CHART_COPY_URL = "/easweb/webframework/dynamic/chart.do?method=copyChart";
    private static final String CHART_EXPORT_URL = "/easweb/webframework/dynamic/chart.do?method=exportChart";
    private static final String CHART_IMPORT_URL = "/easweb/webframework/dynamic/chart.do?method=importChart&themeId=aaa";
    private static final String KEY_FILE_NAME = "fileName";
    private static final String KEY_CHARTID = "chartId";

    public static String copyChartContent(String oldChartId) throws IntegratedRuntimeException {
        CloseableHttpClient httpClient;
        block8: {
            String chartId;
            String requestCookies = QingSessionUtil.get((String)"lastRequestCookies");
            if (requestCookies == null) {
                throw new IntegratedRuntimeException("get cookies failed");
            }
            httpClient = HttpClients.createDefault();
            String fullPath = urlPrefix + CHART_COPY_URL;
            fullPath = ChartRequestUtil.appendParamToUrl(fullPath, KEY_CHARTID, oldChartId);
            HttpGet get = new HttpGet(fullPath);
            get.setHeader("Cookie", requestCookies);
            CloseableHttpResponse res = httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = res.getEntity();
            if (entity == null) break block8;
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            String string = chartId = (String)jsonObject.get("data");
            CloseUtil.close((Closeable[])new Closeable[]{httpClient});
            return string;
        }
        try {
            try {
                throw new IntegratedRuntimeException("request copy programable chart failed, invalid response");
            }
            catch (ClientProtocolException e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
            catch (JSONException e) {
                throw new IntegratedRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{httpClient});
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void requestDelete(String chartId) throws IntegratedRuntimeException {
        String requestCookies = QingSessionUtil.get((String)"lastRequestCookies");
        if (requestCookies == null) {
            throw new IntegratedRuntimeException("get cookies failed");
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            String fullPath = urlPrefix + CHART_DEL_URL;
            fullPath = ChartRequestUtil.appendParamToUrl(fullPath, KEY_CHARTID, chartId);
            HttpGet get = new HttpGet(fullPath);
            get.setHeader("Cookie", requestCookies);
            httpClient.execute((HttpUriRequest)get);
        }
        catch (ClientProtocolException e) {
            try {
                LogUtil.error((String)("request delete programable chart failed,chartId=" + chartId));
                throw new IntegratedRuntimeException((Throwable)e);
                catch (IOException e2) {
                    LogUtil.error((String)("request delete programable chart failed,chartId=" + chartId));
                    throw new IntegratedRuntimeException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{httpClient});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{httpClient});
    }

    public static byte[] requestExportChart(String chartId) throws IntegratedRuntimeException {
        String newChartId;
        CloseableHttpClient httpClient;
        block8: {
            byte[] byArray;
            block9: {
                byte[] chartContent;
                String requestCookies = QingSessionUtil.get((String)"lastRequestCookies");
                if (requestCookies == null) {
                    throw new IntegratedRuntimeException("get cookies failed");
                }
                httpClient = HttpClients.createDefault();
                String fullPath = urlPrefix + CHART_EXPORT_URL;
                newChartId = null;
                newChartId = ChartRequestUtil.copyChartContent(chartId);
                fullPath = ChartRequestUtil.appendParamToUrl(fullPath, KEY_CHARTID, newChartId);
                HttpGet get = new HttpGet(fullPath);
                get.setHeader("Cookie", requestCookies);
                CloseableHttpResponse res = httpClient.execute((HttpUriRequest)get);
                HttpEntity entity = res.getEntity();
                if (entity == null) break block8;
                byArray = chartContent = EntityUtils.toByteArray((HttpEntity)entity);
                if (newChartId == null) break block9;
                ChartRequestUtil.requestDelete(newChartId);
            }
            CloseUtil.close((Closeable[])new Closeable[]{httpClient});
            return byArray;
        }
        try {
            try {
                throw new IntegratedRuntimeException("request export programable chart failed, invalid response");
            }
            catch (ClientProtocolException e) {
                LogUtil.error((String)("request export programable chart failed,chartId=" + chartId));
                throw new IntegratedRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                LogUtil.error((String)("request export programable chart failed,chartId=" + chartId));
                throw new IntegratedRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (newChartId != null) {
                ChartRequestUtil.requestDelete(newChartId);
            }
            CloseUtil.close((Closeable[])new Closeable[]{httpClient});
            throw throwable;
        }
    }

    public static String requestImportChart(String fileName) throws IntegratedRuntimeException, IOException {
        String requestCookies = QingSessionUtil.get((String)"lastRequestCookies");
        if (requestCookies == null) {
            throw new IntegratedRuntimeException("get cookies failed");
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String fullPath = urlPrefix + CHART_IMPORT_URL;
        try {
            List chartIds;
            fullPath = ChartRequestUtil.appendParamToUrl(fullPath, KEY_FILE_NAME, fileName);
            HttpGet get = new HttpGet(fullPath);
            get.setHeader("Cookie", requestCookies);
            CloseableHttpResponse res = httpClient.execute((HttpUriRequest)get);
            String result = EntityUtils.toString((HttpEntity)res.getEntity(), (String)"utf-8");
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            Object data = jsonObject.get("data");
            if (data != null && data instanceof List && (chartIds = (List)data).size() > 0) {
                return (String)chartIds.get(0);
            }
            throw new IntegratedRuntimeException("request import programable chart failed, invalid response");
        }
        catch (ClientProtocolException e) {
            LogUtil.error((String)"request import programable chart failed");
            throw new IntegratedRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (JSONException e) {
            throw new IntegratedRuntimeException((Throwable)e);
        }
    }

    private static String appendParamToUrl(String sUrl, String paramKey, String paramValue) throws UnsupportedEncodingException {
        if (paramValue != null && !"".equals(paramValue.trim())) {
            sUrl = sUrl + (sUrl.indexOf("?") < 0 ? "?" : "&");
            sUrl = sUrl + paramKey;
            sUrl = sUrl + "=";
            paramValue = URLEncoder.encode(paramValue, "utf-8");
            paramValue = paramValue.replace("+", "%20");
            sUrl = sUrl + paramValue;
        }
        return sUrl;
    }

    static {
        String url = System.getProperty("cas.server.url");
        if (url.indexOf("/eassso") > 0) {
            url = url.substring(0, url.indexOf("/eassso"));
        }
        urlPrefix = url;
    }
}

