/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.appmenu.dao.AppMenuDao;
import com.kingdee.bos.qing.publish.appmenu.exception.AppMenuException;
import com.kingdee.bos.qing.publish.appmenu.model.AppmenuPublishWithPublishName;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AppMenuManageDomain
extends AbstractPublishManageDomain {
    private AppMenuDao appMenuDao;

    public AppMenuManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.appMenuDao = new AppMenuDao(qingContext, dbExcuter);
    }

    public TreeMenuFolderNode getAppMenuTree(boolean isManage, boolean isRefresh) throws AppMenuException, AbstractQingIntegratedException {
        try {
            TreeMenuFolderNode appCenterMenuTree = this.appMenuDao.getAppMenuTree(isRefresh);
            if (isManage) {
                List allPaths = this.getPublishInfoDao().loadAllPublishPath(this.qingContext.getUserId(), 0);
                boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
                if (isCurrentUserInQingAdminRole) {
                    List allPresetPaths = this.getPublishInfoDao().loadAllPublishPath(IntegratedHelper.getPresetUserId(), 0);
                    allPaths.addAll(0, allPresetPaths);
                }
                return TreeMenuFolderNode.rebulidMenuTree(appCenterMenuTree, allPaths);
            }
            return appCenterMenuTree;
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public List<PublishVO> loadPublishInfos(String path) throws AbstractQingIntegratedException, AppMenuException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = this.appMenuDao.loadPublishInfos(userId, path);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List<PublishVO> presetPublishVOs = this.appMenuDao.loadPublishInfos(IntegratedHelper.getPresetUserId(), path);
                publishVOs.addAll(0, presetPublishVOs);
            }
            this.buildTreeMenuFolderNode(publishVOs);
            return publishVOs;
        }
        catch (PublishException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public List<PublishVO> loadAllPublishInfos() throws AbstractQingIntegratedException, PublishException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = this.appMenuDao.loadAllPublishInfos(userId);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List<PublishVO> presetPublishVOs = this.appMenuDao.loadAllPublishInfos(IntegratedHelper.getPresetUserId());
                publishVOs.addAll(0, presetPublishVOs);
            }
            this.buildTreeMenuFolderNode(publishVOs);
            this.setPublishPermissionInfo(publishVOs);
            return publishVOs;
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    private void buildTreeMenuFolderNode(List<PublishVO> publishVOs) throws PublishException, AbstractQingIntegratedException, SQLException {
        if (publishVOs != null && !publishVOs.isEmpty()) {
            for (int i = 0; i < publishVOs.size(); ++i) {
                this.setPublishPermissionInfo(publishVOs.get(i));
            }
            Iterator<PublishVO> iter = publishVOs.iterator();
            TreeMenuFolderNode appCenterMenuTree = this.appMenuDao.getAppMenuTree(false);
            while (iter.hasNext()) {
                PublishVO vo = iter.next();
                String allPath = vo.getPath();
                allPath = allPath.replaceFirst("/2b7f4215-aa17-4d89-952e-efc97833cee6", "");
                String pathText = TreeMenuFolderNode.buildPathText(appCenterMenuTree, allPath);
                vo.setPathText(pathText);
            }
        }
    }

    public Map<String, Object> getAppMenuTreeForDsb() throws AppMenuException, AbstractQingIntegratedException {
        try {
            TreeMenuFolderNode appCenterMenuTree = this.appMenuDao.getAppMenuTree(false);
            String userId = this.qingContext.getUserId();
            List allPaths = this.getPublishInfoDao().loadPublishForDsb(userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter), 0);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List allPresetPaths = this.getPublishInfoDao().loadPublishForDsb(IntegratedHelper.getPresetUserId(), new HashSet(), 0);
                allPaths.addAll(0, allPresetPaths);
            }
            TreeMenuFolderNode root = TreeMenuFolderNode.rebulidMenuTree(appCenterMenuTree, allPaths);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("appmenu", root);
            result.put("publish", this.loadPublishInfosForDsb(null));
            return result;
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public List<AppmenuPublishWithPublishName> loadPublishInfosForDsb(String path) throws AbstractQingIntegratedException, AppMenuException {
        try {
            String userId = this.qingContext.getUserId();
            List<PublishVO> publishVOs = null;
            publishVOs = path == null ? this.appMenuDao.loadPublishInfosForDsb(userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter)) : this.appMenuDao.loadPublishInfosForDsb(path, userId, IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter));
            ArrayList<AppmenuPublishWithPublishName> appmenuPublishWithPublishNames = new ArrayList<AppmenuPublishWithPublishName>();
            if (publishVOs != null && !publishVOs.isEmpty()) {
                for (int i = 0; i < publishVOs.size(); ++i) {
                    PublishVO publishVO = publishVOs.get(i);
                    this.setPublishPermissionInfo(publishVO);
                    AppmenuPublishWithPublishName appmenuPublishWithPublishName = new AppmenuPublishWithPublishName();
                    String publishPersonName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)publishVO.getCreatorId());
                    appmenuPublishWithPublishName.setPublishVO(publishVO);
                    appmenuPublishWithPublishName.setPublisherName(publishPersonName);
                    appmenuPublishWithPublishNames.add(appmenuPublishWithPublishName);
                }
                Iterator<PublishVO> iter = publishVOs.iterator();
                TreeMenuFolderNode appCenterMenuTree = this.appMenuDao.getAppMenuTree(false);
                while (iter.hasNext()) {
                    PublishVO vo = iter.next();
                    String allPath = vo.getPath();
                    allPath = allPath.replaceFirst("/2b7f4215-aa17-4d89-952e-efc97833cee6", "");
                    String pathText = TreeMenuFolderNode.buildPathText(appCenterMenuTree, allPath);
                    vo.setPathText(pathText);
                }
            }
            return appmenuPublishWithPublishNames;
        }
        catch (PublishException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }
}

