/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.domain;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.publish.appmenu.dao.AppMenuDao;
import com.kingdee.bos.qing.publish.appmenu.domain.AbstractAppMenuPublishTargetDomain;
import com.kingdee.bos.qing.publish.appmenu.exception.AppMenuException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class AppMenuPublishTargetDomain
extends AbstractAppMenuPublishTargetDomain {
    private AppMenuDao appMenuDao;
    private IRefHandler appMenuHandler;

    public AppMenuPublishTargetDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.appMenuDao = new AppMenuDao(qingContext, dbExcuter);
    }

    public PublishPO savePublish(String tag, PublishSourceEnum source, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        try {
            this.updateRefToId(publishInfo);
            this.appMenuDao.saveAppMenu(publishInfo.getId(), publishInfo.getName(), publishInfo.getPath());
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
        return publishInfo;
    }

    private IRefHandler getRefHandler() {
        if (this.appMenuHandler == null) {
            this.appMenuHandler = RefHandlerFactory.createHandler((RefTypeEnum)RefTypeEnum.appmenu, (IDBExcuter)this.dbExcuter, (QingContext)this.qingContext, (ITransactionManagement)this.tx);
        }
        return this.appMenuHandler;
    }

    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        try {
            this.appMenuDao.deleteAppMenu(info.getId());
            this.updateRefFullPath(info);
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew) throws AbstractQingIntegratedException, PublishException {
        try {
            this.appMenuDao.updateAppMenu(updateType, publishInfoNew);
            this.updateRefToId(publishInfoNew);
        }
        catch (SQLException e) {
            throw new AppMenuException(e.getMessage(), e);
        }
    }

    public void overwritePublish(String tag, int updateType, PublishPO publishInfoNew, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        this.updatePublish(updateType, publishInfoNew);
    }

    private void updateRefFullPath(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            IRefHandler handler;
            String publishId = publishInfo.getId();
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType() && (handler = this.getRefHandler()) instanceof ISwitchPathAndIdHandler) {
                ISwitchPathAndIdHandler switchHandler = (ISwitchPathAndIdHandler)handler;
                String fullPath = this.getPathName(publishInfo.getPath()) + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                switchHandler.replacePersistentIdToPath(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
        catch (BOSException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    private void updateRefToId(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            IRefHandler handler;
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType() && (handler = this.getRefHandler()) instanceof ISwitchPathAndIdHandler) {
                String publishId = publishInfo.getId();
                String fullPath = this.getPathName(publishInfo.getPath()) + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                ISwitchPathAndIdHandler switchHandler = (ISwitchPathAndIdHandler)handler;
                switchHandler.replacePersistentPathToId(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
        catch (BOSException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    private String getPathName(String path) throws BOSException, SQLException {
        String[] allPath = path.split("/");
        String publishFolderPathName = "";
        for (int i = 1; i < allPath.length; ++i) {
            publishFolderPathName = publishFolderPathName + this.appMenuDao.getPageFolderByPageId(allPath[i]) + "-";
        }
        return publishFolderPathName;
    }

    public String loadOrCreatePath(String userId, String pathId, String pathName) throws AbstractQingIntegratedException, SQLException {
        return pathId;
    }

    public String loadPathNamePOByPathId(String path) throws AbstractQingIntegratedException, SQLException {
        return path;
    }

    public String loadPathNameByPath(String allPath, String publishId) throws AbstractQingIntegratedException, SQLException {
        try {
            allPath = allPath.replaceFirst("/2b7f4215-aa17-4d89-952e-efc97833cee6", "");
            String[] path = allPath.split("/");
            String pathText = "";
            for (int i = 1; i < path.length; ++i) {
                pathText = pathText + this.appMenuDao.getPageFolderByPageId(path[i]);
                if (i >= path.length - 1) continue;
                pathText = pathText + "/";
            }
            String prefix = EASMessages.getMLS(this.qingContext, "appMenu", "\u95e8\u6237\u5e94\u7528\u83dc\u5355") + " : ";
            return prefix + pathText;
        }
        catch (BOSException e) {
            LogUtil.error((String)"Qing get appmenu tree failed", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"Qing get appmenu tree failed", (Throwable)e);
        }
        return null;
    }
}

