/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.appmenu.portal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.entity.TreeBaseEntity;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.CnToSpell;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.portal.common.util.JSONUtil;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.sf.json.JSONObject;

public class PortalFacade {
    public static String getPageFolderByPageId(Context ctx, String pageId) throws BOSException, SQLException {
        if (pageId != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("select FDisplayName from T_JP_Page where fid ='" + pageId + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                DisplayName displayName = new DisplayName(rs.getString("FDisplayName"));
                return displayName.getZh_CN();
            }
        }
        return null;
    }

    public static boolean deletePageFromPortal(Context ctx, String pageId) throws PortalBizException {
        try {
            if (StringUtils.isEmpty((CharSequence)pageId)) {
                throw new PortalBizException("201");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FId,FNodePath,FNodeType from T_JP_Page where fid='" + pageId + "'"));
            if (rs == null) {
                throw new PortalBizException("207");
            }
            Page page = null;
            while (rs.next()) {
                page = new Page();
                page.setId(rs.getString("FId"));
                page.setNodePath(rs.getString("FNodePath"));
                page.setNodeType(NodeTypeEnum.valueOf((String)rs.getString("FNodeType")));
            }
            if (page == null) {
                throw new NullPointerException();
            }
            if (page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK || page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK_G || page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK_OA) {
                DbUtil.execute((Context)ctx, (String)("delete from T_JP_Page where fid='" + pageId + "'"));
                return true;
            }
            throw new Exception("nodeType \u4e3a\uff1a" + page.getNodeType().name() + "\u4e0d\u80fd\u5220\u9664");
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String savePageToPortal(Context ctx, String pageJson, String parentId) {
        boolean success = false;
        LocalErr localErr = null;
        List<Page> pageList = null;
        try {
            pageList = PortalFacade.innersavePageToPortal(ctx, pageJson, parentId);
            if (pageList != null && pageList.size() > 0) {
                success = true;
                PortalCacheFacade.updateCacheFlag((Context)ctx, (String)"FClientFlag");
                CustomCacheService cacheService = new CustomCacheService("login.all_menu");
                cacheService.remove("allMenuRowSet");
            } else {
                localErr = new LocalErr();
                localErr.setDesc("Add Page Error");
                LogUtil.error((String)"innersavePageToPortal Add Page Error");
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"innersavePageToPortal error", (Throwable)e);
            localErr = new LocalErr();
            localErr.setDesc(e.getMessage());
        }
        return PortalFacade.transferToJson(success, localErr, pageList);
    }

    private static List<Page> innersavePageToPortal(Context ctx, String pageJson, String parentId) throws PortalBizException {
        ArrayList<Page> resultList = new ArrayList<Page>();
        Page parentPage = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FNodeLevel,FId,FDisplayName,FNodePath,FNodeType,FNodeExt,FNodeOrder from T_JP_Page where fid='" + parentId + "'"));
            if (rs != null) {
                while (rs.next()) {
                    parentPage = new Page();
                    parentPage.setNodeLevel(Integer.valueOf(rs.getInt("FNodeLevel")));
                    parentPage.setId(rs.getString("FId"));
                    parentPage.setDisplayName(rs.getString("FDisplayName"));
                    parentPage.setNodePath(rs.getString("FNodePath"));
                    parentPage.setNodeType(NodeTypeEnum.valueOf((String)rs.getString("FNodeType")));
                    parentPage.setNodeExt(rs.getString("FNodeExt"));
                    parentPage.setNodeOrder(Integer.valueOf(rs.getInt("FNodeOrder")));
                }
            }
        }
        catch (Exception e1) {
            throw new PortalBizException("210");
        }
        if (parentPage == null) {
            throw new PortalBizException("210");
        }
        JSONObject obj = JSONObject.fromObject((Object)pageJson);
        String dispalyName = obj.getString("displayName");
        if (dispalyName.startsWith("\"") && dispalyName.endsWith("\"")) {
            dispalyName = dispalyName.substring(1, dispalyName.length() - 1);
        }
        String url = obj.getString("url");
        String permItem = null;
        Page page = new Page();
        page.setDisplayName(dispalyName);
        page.setDescription(dispalyName);
        page.setNodeType(NodeTypeEnum.EXTERNAL_LINK);
        page.setParentNode((TreeBaseEntity)parentPage);
        page.setStatus(StatusEnum.ENABLE);
        page.setPageNumber(PageHelper.generatePageNumber());
        page.setPermViewCtrl(Boolean.valueOf(false));
        page.setPermEditCtrl(Boolean.valueOf(false));
        page.setCanAddFav(Boolean.valueOf(true));
        page.setCanSearch(Boolean.valueOf(true));
        page.setPreferences("2");
        String externalId = PortalFacade.savePageToEAS(ctx, url, dispalyName, permItem);
        ELinkNodeExt ext = new ELinkNodeExt();
        ext.setUrl(url);
        ext.setExternalId(externalId);
        ext.setLeaf(Boolean.valueOf(true));
        ext.setTarget("TAB");
        page.setNodeExt(ext.toString());
        page.setResLevel(ResLevelEnum.EXT);
        page.setNodeOrder(Integer.valueOf(10000));
        page.setPortalContext(PortalFacade.buildPortalContext(ctx));
        page.setUserId("portal_template_user");
        page.setAllSpell(PortalFacade.getCnSpell(dispalyName, false));
        page.setFirstSpell(PortalFacade.getCnSpell(dispalyName, true));
        try {
            StringBuilder saveSql = new StringBuilder();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowTime = df.format(new Date());
            String id = UUID.randomUUID().toString();
            saveSql.append("Insert Into T_JP_Page(FID,FCREATETIME,FCREATOR,FLASTUPDATETIME,FLASTUPDATER,FHIDDEN,FNODELEVEL,FNODEORDER,FNODEPATH,FPARENTNODEID,FPAGENUMBER,FDISPLAYNAME,FNODETYPE,FNODEEXT,FDESCRIPTION,FSETTINGINFO,FSTATUS,FICON,FPERMVIEWCTRL,FPERMEDITCTRL,FRESLEVEL,FUSERID,FPREFERENCES,FDEFAULTPAGEID,FCONTROLPARAM,FSHOWPLTBUTTON,FFIRSTSPELL,FALLSPELL,FCANSEARCH,FCANADDFAV)").append(" Values('").append(id).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("0,5,10000,").append("'").append(parentPage.getNodePath()).append("/").append(id).append("',").append("'").append(parentPage.getId()).append("',").append("'").append(PageHelper.generatePageNumber()).append("',").append("'").append(dispalyName).append("',").append("'EXTERNAL_LINK',").append("'").append(ext.toString()).append("',").append("'").append(dispalyName).append("',").append("null,'ENABLE',null,1,1,'EXT','portal_template_user','2',").append("null,null,null,").append("'").append(PortalFacade.getCnSpell(dispalyName, true)).append("',").append("'").append(PortalFacade.getCnSpell(dispalyName, false)).append("',").append("1,1)");
            DbUtil.execute((Context)ctx, (String)saveSql.toString());
            page.setId(id);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            throw new PortalBizException("202");
        }
        resultList.add(page);
        return resultList;
    }

    private static String savePageToEAS(Context ctx, String url, String displayName, String permItem) throws PortalBizException {
        String externalId = null;
        try {
            MainMenuItemInfo parent = MainMenuItemFactory.getLocalInstance((Context)ctx).getMainMenuItemInfo((IObjectPK)new ObjectUuidPK("6u3K38SWTu6Z1Fjesbpc5f033J8="));
            if (parent == null) {
                throw new PortalBizException("210");
            }
            MainMenuItemInfo menu = new MainMenuItemInfo();
            menu.setAvailable(true);
            BOSUuid uuId = BOSUuid.create((BOSObjectType)menu.getBOSType());
            menu.setId(uuId);
            String number = PageHelper.generatePageNumber();
            number = number.substring(2, number.length());
            menu.setNumber(number);
            menu.setLongNumber("portalAuto!" + number);
            menu.setOrder("255");
            menu.setMenutype(BizTypeEnum.webmenu);
            menu.setVisible(true);
            menu.setEnabled(true);
            DisplayName nameInfo = new DisplayName(displayName);
            menu.setName(nameInfo.getZh_CN());
            menu.setLevel(2);
            menu.setParent(parent);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            menu.setCU(cu);
            MainMenuItemFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)menu);
            externalId = uuId.toString();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            throw new PortalBizException("212");
        }
        return externalId;
    }

    private static PortalContext buildPortalContext(Context ctx) {
        PortalContext portalContext = new PortalContext();
        portalContext.setIp("127.0.0.1");
        portalContext.setLocale(Locale.CHINA);
        portalContext.setLoginDate(new Date());
        User loginUser = new User();
        loginUser.setId(ctx.getCaller().toString());
        loginUser.setCode(ctx.getUserName());
        portalContext.setLoginUser(loginUser);
        portalContext.getMetaInfo().put("eas_context", ctx);
        DSObserver.putDSName((String)ctx.getAIS());
        return portalContext;
    }

    private static String getCnSpell(String displayName, boolean onlyFirstSpell) {
        DisplayName nameInfo = new DisplayName(displayName);
        String cnName = nameInfo.getZh_CN();
        return CnToSpell.getSpell((String)cnName, (boolean)onlyFirstSpell);
    }

    private static String transferToJson(boolean success, LocalErr errinfo, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("errinfo", errinfo);
        ajaxData.put("result", tempResult);
        return JSONUtil.getJson4Object(ajaxData);
    }
}

