/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.publish.appmenu.domain.AbstractAppMenuPublishTargetDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.guimenu.dao.GUIMenuDao;
import com.kingdee.bos.qing.publish.guimenu.exception.GUIMenuException;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.List;

public class GUIMenuPublishTargetDomain
extends AbstractAppMenuPublishTargetDomain {
    private GUIMenuDao guiMenuDao;
    private IRefHandler guiMenuHandler;

    public GUIMenuPublishTargetDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.guiMenuDao = new GUIMenuDao(qingContext, dbExcuter);
    }

    public PublishPO savePublish(String tag, PublishSourceEnum source, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        try {
            this.updateRefToId(publishInfo);
            this.guiMenuDao.saveGUIMenu(publishInfo.getId(), publishInfo.getName(), publishInfo.getPath());
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
        return publishInfo;
    }

    private IRefHandler getRefHandler() {
        if (this.guiMenuHandler == null) {
            this.guiMenuHandler = RefHandlerFactory.createHandler((RefTypeEnum)RefTypeEnum.guimenu, (IDBExcuter)this.dbExcuter, (QingContext)this.qingContext, (ITransactionManagement)this.tx);
        }
        return this.guiMenuHandler;
    }

    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        try {
            this.guiMenuDao.deleteGUIMenu(info.getId());
            this.updateRefFullPath(info);
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew) throws AbstractQingIntegratedException, PublishException {
        try {
            this.guiMenuDao.updateGUIMenu(updateType, publishInfoNew);
            this.updateRefToId(publishInfoNew);
        }
        catch (SQLException e) {
            throw new GUIMenuException(e.getMessage(), e);
        }
    }

    public void overwritePublish(String tag, int updateType, PublishPO publishInfoNew, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        this.updatePublish(updateType, publishInfoNew);
    }

    private void updateRefFullPath(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            IRefHandler handler;
            String publishId = publishInfo.getId();
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType() && (handler = this.getRefHandler()) instanceof ISwitchPathAndIdHandler) {
                ISwitchPathAndIdHandler switchHandler = (ISwitchPathAndIdHandler)handler;
                String fullPath = this.getPathName(publishInfo.getPath()) + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                switchHandler.replacePersistentIdToPath(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    private void updateRefToId(PublishPO publishInfo) throws AbstractQingIntegratedException {
        try {
            IRefHandler handler;
            if (PublishSourceEnum.subject == publishInfo.getPublishSourceType() && (handler = this.getRefHandler()) instanceof ISwitchPathAndIdHandler) {
                String publishId = publishInfo.getId();
                String fullPath = this.getPathName(publishInfo.getPath()) + "/" + publishInfo.getName();
                String fullPath_old = this.getPathName_old(publishInfo.getPath()) + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                String fullPathWithNameSpace_old = NameSpace.user.toPersistance() + "/" + fullPath_old;
                ISwitchPathAndIdHandler switchHandler = (ISwitchPathAndIdHandler)handler;
                switchHandler.replacePersistentPathToId(fullPathWithNameSpace, publishId, this.qingContext.getUserId());
                switchHandler.replacePersistentPathToId(fullPathWithNameSpace_old, publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    public String loadOrCreatePath(String userId, String pathId, String pathName) throws AbstractQingIntegratedException, SQLException {
        return pathId;
    }

    public String loadPathNamePOByPathId(String path) throws AbstractQingIntegratedException, SQLException {
        return path;
    }

    public String loadPathNameByPath(String path, String publishId) throws AbstractQingIntegratedException, SQLException {
        TreeMenuFolderNode guiCenterMenuTree = this.guiMenuDao.getGUIMenuTree(false);
        String pathText = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
        if (StringUtils.isNotEmpty((CharSequence)(pathText = TreeMenuFolderNode.buildPathText(guiCenterMenuTree, pathText))) && pathText.indexOf(47) == 0) {
            pathText = pathText.substring(1);
        }
        String prefix = EASMessages.getMLS(this.qingContext, "guiMenu", "\u5ba2\u6237\u7aef\u5e94\u7528\u83dc\u5355") + " : ";
        return prefix + pathText;
    }

    private String getPathName_old(String path) throws SQLException {
        TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
        String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
        publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
        return publishFolderPathName;
    }

    private String getPathName(String path) throws SQLException {
        TreeMenuFolderNode guiMenuTree = this.guiMenuDao.getGUIMenuTree(false);
        path = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
        String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
        publishFolderPathName = publishFolderPathName.replaceAll("/", "-");
        return publishFolderPathName;
    }
}

