/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.guimenu.refHandler;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.ExtreportAppHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.QingRefHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.exporter.qhf.domain.scene.publish.PublishLongerSquareQHFExporter;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.guimenu.dao.GUIMenuDao;
import com.kingdee.bos.qing.publish.guimenu.refHandler.GUIMenuSwitchPathAndIdHandler;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuFolderNode;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.jdom2.JDOMException;

public class GUIMenuRefHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable,
ITimingPushable,
IPrepareDataable {
    private static final String SCHEMA_CACHE_SUFFIX = "_guimenu";
    private PublishInfoDao publishInfoDao;
    private SubjectManageDomain subjectManageDomain;
    private GUIMenuDao guiMenuDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private Map<RefTypeEnum, AbstractRefHandler> refHandlerMap = new HashMap<RefTypeEnum, AbstractRefHandler>(3);
    private CommonPublishDomain commonPublishDomain;

    public GUIMenuRefHandler(RefTypeEnum refType) {
        this.setRefType(refType);
    }

    public GUIMenuRefHandler() {
        this.setRefType(RefTypeEnum.guimenu);
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.context, null, this.dbExcuter, null);
        }
        return this.subjectManageDomain;
    }

    private GUIMenuDao getGUIMenuDao() {
        if (this.guiMenuDao == null) {
            this.guiMenuDao = new GUIMenuDao(this.context, this.dbExcuter);
        }
        return this.guiMenuDao;
    }

    public ReferenceMap createRefMap(String refToId) throws AbstractQingException {
        return this.getRefHandler(this.getRealRefType(refToId)).createRefMap(refToId);
    }

    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
        String refToId = params.get("refToId");
        this.getRefHandler(this.getRealRefType(refToId)).addRefContent(params, result);
    }

    protected String getSchemaCacheSuffix() {
        return SCHEMA_CACHE_SUFFIX;
    }

    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException, QingImglibException {
    }

    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, IOException, QingImglibException {
        ((IExImportable)this.getRefHandler(this.refType)).importRefContent(dsbId, dsbImportModel, successImportFile);
    }

    private AbstractRefHandler getRefHandler(RefTypeEnum refType) {
        if (this.refHandlerMap.get(refType) == null) {
            Object refHandler = refType == RefTypeEnum.appmenu_rpt ? new ExtreportAppHandler(RefTypeEnum.appmenu_rpt) : (refType == RefTypeEnum.appmenu_qing ? new QingRefHandler(RefTypeEnum.appmenu_qing) : new QingRefHandler(RefTypeEnum.appmenu_qing));
            refHandler.setDbExcuter(this.dbExcuter);
            refHandler.setContext(this.context);
            refHandler.setTx(this.tx);
            this.refHandlerMap.put(refType, (AbstractRefHandler)refHandler);
        }
        return this.refHandlerMap.get(refType);
    }

    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws IOException, SQLException, QingImglibException, AbstractQingIntegratedException {
    }

    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dsbImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws ImportThemeException, AbstractQingIntegratedException {
        List refMapList = ((IExImportPublishable)this.getRefHandler(this.refType)).importPublishedRefContent(publishId, dsbImportModel, dashboardPublishImportModel, successImportFile);
        return refMapList;
    }

    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        ((IExImportable)this.getRefHandler(this.refType)).separateImportModel(dsbImportModel, dsbSchemaProperty, schemaFileKey);
    }

    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
    }

    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        return null;
    }

    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        ((IExImportPublishable)this.getRefHandler(this.refType)).separateImportModel(dsbPublishImportModel, dsbSchemaProperty, schemaFileKey);
    }

    public void exportSource(String refTag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("publishId", referenceMap.getRefToId());
        params.put("tag", refTag);
        PublishLongerSquareQHFExporter dsbRefPublishQHFExporter = new PublishLongerSquareQHFExporter(this.context, this.dbExcuter, this.tx);
        dsbRefPublishQHFExporter.export(params, meta);
    }

    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws DashboardException, AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.guimenu) {
            this.getRefHandler(RefTypeEnum.guimenu).saveOrUpdateReference(dsbId, refMap);
        } else {
            this.getRefHandler(refType).saveOrUpdateReference(dsbId, refMap);
        }
    }

    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        this.getRefHandler(this.getRealRefType(refMap)).copyReference(fromDsbId, toDsbId, refMap, rollbackCollector);
    }

    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        this.getRefHandler(this.getRealRefType(refMap)).copyExecutionReference(fromDsbId, toDsbId, refMap, rollbackCollector, type);
    }

    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.appmenu) {
            this.getRefHandler(RefTypeEnum.appmenu_rpt).deleteReference(dsbId, refMap);
            this.getRefHandler(RefTypeEnum.appmenu_qing).deleteReference(dsbId, refMap);
        } else {
            this.getRefHandler(refType).deleteReference(dsbId, refMap);
        }
    }

    public String loadRefFullPath(ReferenceMap refMap, String userId) throws AbstractQingIntegratedException, SQLException {
        String refToId = refMap.getRefToId();
        String fullPath = null;
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (publishPO != null) {
            TreeMenuFolderNode guiMenuTree = this.getGUIMenuDao().getGUIMenuTree(false);
            String path = publishPO.getPath();
            path = path.replaceFirst("/EAS_GUI_CENTER_ROOT_UUID", "");
            String publishFolderPathName = TreeMenuFolderNode.buildPathText(guiMenuTree, path);
            publishFolderPathName = publishFolderPathName.replaceFirst("/", "");
            fullPath = publishFolderPathName + "/" + publishPO.getName();
        }
        return fullPath;
    }

    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new GUIMenuSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    public String getPrepareDataTag(String tag, String refToId) throws AbstractQingIntegratedException, SQLException {
        return ((IPrepareDataable)this.getRefHandler(this.getRealRefType(refToId))).getPrepareDataTag(tag, refToId);
    }

    public IPrepareDataContext getDataPrepareContext(String tag, String refToId, boolean isStartBySchedule, boolean isFirstFromCache, ProgressModel progressModel) {
        return ((IPrepareDataable)this.getRefHandler(this.getRealRefType(refToId))).getDataPrepareContext(tag, refToId, isStartBySchedule, isFirstFromCache, progressModel);
    }

    public AbstractPrepareDataHandler getDataPrepareHandler(IPrepareDataContext prepareDataContext) {
        return ((IPrepareDataable)this.getRefHandler(this.refType)).getDataPrepareHandler(prepareDataContext);
    }

    public String getQHFUniqueRefId(String refToId, PackageMeta packageMeta) {
        return ((IPrepareDataable)this.getRefHandler(this.getRealRefType(refToId))).getQHFUniqueRefId(refToId, packageMeta);
    }

    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws PrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
        this.getRefHandler(this.getRealRefType(referenceMap)).createPublishedCarryDataDataSource(tag, publishPO, referenceMap);
    }

    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        ((IPublishable)this.getRefHandler(this.getRealRefType(refMap))).savePublishReference(dsbId, publishId, refMap, modelBook);
    }

    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(publishId);
        if (refType == RefTypeEnum.guimenu) {
            ((IPublishable)this.getRefHandler(RefTypeEnum.guimenu)).deletePublishContent(publishId);
        } else {
            ((IPublishable)this.getRefHandler(refType)).deletePublishContent(publishId);
        }
    }

    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        RefTypeEnum refType = this.getRealRefType(publishId);
        if (refType == RefTypeEnum.guimenu) {
            ((IPublishable)this.getRefHandler(RefTypeEnum.guimenu)).deletePublishContent(publishId);
        } else {
            ((IPublishable)this.getRefHandler(refType)).deletePublishContent(publishId);
        }
    }

    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(publishId);
        if (refType == RefTypeEnum.guimenu) {
            ((IPublishable)this.getRefHandler(RefTypeEnum.guimenu)).deletePublishContent(publishId);
        } else {
            ((IPublishable)this.getRefHandler(refType)).deletePublishContent(publishId);
        }
    }

    public void saveTimingPushReference(String dashboardUniqueId, String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        ((ITimingPushable)this.getRefHandler(this.getRealRefType(refItem))).saveTimingPushReference(dashboardUniqueId, sourceId, sourceType, refItem);
    }

    public void updateTimingPushReference(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException {
        RefTypeEnum refType = this.getRealRefType(refItem);
        if (refType == RefTypeEnum.guimenu) {
            ((ITimingPushable)this.getRefHandler(RefTypeEnum.guimenu)).updateTimingPushReference(sourceId, sourceType, refItem);
        } else {
            ((ITimingPushable)this.getRefHandler(refType)).updateTimingPushReference(sourceId, sourceType, refItem);
        }
    }

    public void deleteTimingPushReference(String sourceId, ReferenceMap refMap, int sourceType) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.guimenu) {
            ((ITimingPushable)this.getRefHandler(RefTypeEnum.guimenu)).deleteTimingPushReference(sourceId, refMap, sourceType);
        } else {
            ((ITimingPushable)this.getRefHandler(refType)).deleteTimingPushReference(sourceId, refMap, sourceType);
        }
    }

    private RefTypeEnum getRealRefType(ReferenceMap referenceMap) {
        if (this.refType == RefTypeEnum.appmenu) {
            try {
                PublishPO publishPO;
                DashboardModelBookCache dashboardCache = new DashboardModelBookCache(referenceMap.getFileKey());
                if (dashboardCache.exists()) {
                    referenceMap.setRefType(RefTypeEnum.appmenu_qing.toPersistance());
                } else if (null != referenceMap.getRefToId() && null != this.getPublishInfoDao() && (publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(referenceMap.getRefToId())) != null) {
                    if (PublishSourceEnum.extreport == publishPO.getPublishSourceType()) {
                        referenceMap.setRefType(RefTypeEnum.appmenu_rpt.toPersistance());
                    } else {
                        referenceMap.setRefType(RefTypeEnum.appmenu_qing.toPersistance());
                    }
                }
                return RefTypeEnum.fromPersistance((String)referenceMap.getRefType());
            }
            catch (Exception e) {
                return RefTypeEnum.fromPersistance((String)referenceMap.getRefType());
            }
        }
        return this.refType;
    }

    private RefTypeEnum getRealRefType(String refToId) {
        if (this.refType == RefTypeEnum.appmenu) {
            try {
                PublishPO publishPO;
                if (null != refToId && null != this.getPublishInfoDao() && (publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId)) != null) {
                    if (PublishSourceEnum.extreport == publishPO.getPublishSourceType()) {
                        return RefTypeEnum.appmenu_rpt;
                    }
                    return RefTypeEnum.appmenu_qing;
                }
                return this.refType;
            }
            catch (Exception e) {
                return this.refType;
            }
        }
        return this.refType;
    }
}

