/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.integrated.model;

import com.kingdee.bos.qing.publish.integrated.model.AbstractTreeMenuNode;
import com.kingdee.bos.qing.publish.integrated.model.TreeMenuLeafNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeMenuFolderNode
extends AbstractTreeMenuNode {
    private List<AbstractTreeMenuNode> children;

    public void addChild(AbstractTreeMenuNode child) {
        if (this.children == null) {
            this.children = new ArrayList<AbstractTreeMenuNode>();
        }
        this.children.add(child);
    }

    public void setChildren(List<AbstractTreeMenuNode> children) {
        this.children = children;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public List<AbstractTreeMenuNode> getChildren() {
        return this.children;
    }

    public static String buildPathText(TreeMenuFolderNode rootNode, String allPath) {
        String pathText = "/";
        List<AbstractTreeMenuNode> children = rootNode.getChildren();
        for (AbstractTreeMenuNode node : children) {
            String tempPath = "/" + node.getName();
            if (!allPath.startsWith(tempPath)) continue;
            if (node instanceof TreeMenuFolderNode) {
                allPath = allPath.replaceFirst(tempPath, "");
                pathText = pathText + node.getDisplayName();
                return pathText + TreeMenuFolderNode.buildPathText((TreeMenuFolderNode)node, allPath);
            }
            pathText = pathText + node.getDisplayName();
            return pathText;
        }
        return pathText;
    }

    public static TreeMenuFolderNode rebulidMenuTree(TreeMenuFolderNode srcRootNode, List<String> allPaths) {
        TreeMenuFolderNode targetRootNode = new TreeMenuFolderNode();
        targetRootNode.setName(srcRootNode.getName());
        targetRootNode.setDisplayName(srcRootNode.getDisplayName());
        if (allPaths != null && !allPaths.isEmpty()) {
            HashMap<String, AbstractTreeMenuNode> allNodePath = new HashMap<String, AbstractTreeMenuNode>();
            HashMap<String, AbstractTreeMenuNode> newNodePath = new HashMap<String, AbstractTreeMenuNode>();
            newNodePath.put("/" + targetRootNode.getName(), targetRootNode);
            TreeMenuFolderNode.bulidNodePathMap(srcRootNode, "", allNodePath);
            TreeMenuFolderNode.getFolderNodeByPaths(allNodePath, newNodePath, allPaths);
        }
        return targetRootNode;
    }

    private static void getFolderNodeByPaths(Map<String, AbstractTreeMenuNode> allNodePath, Map<String, AbstractTreeMenuNode> newNodePath, List<String> allPaths) {
        for (String allPath : allPaths) {
            if (!allNodePath.containsKey(allPath)) continue;
            String[] tempPaths = allPath.split("/");
            String nodePath = "";
            for (int index = 1; index < tempPaths.length; ++index) {
                String tempPath = tempPaths[index];
                TreeMenuFolderNode parentNode = null;
                parentNode = (TreeMenuFolderNode)newNodePath.get(nodePath);
                if (newNodePath.containsKey(nodePath = nodePath + "/" + tempPath)) continue;
                AbstractTreeMenuNode childNode = allNodePath.get(nodePath);
                AbstractTreeMenuNode newNode = null;
                if (childNode instanceof TreeMenuFolderNode) {
                    newNode = new TreeMenuFolderNode();
                } else {
                    newNode = new TreeMenuLeafNode();
                    TreeMenuLeafNode TreeMenuLeafNode2 = (TreeMenuLeafNode)childNode;
                    ((TreeMenuLeafNode)newNode).setType(TreeMenuLeafNode2.getType());
                }
                newNode.setDisplayName(childNode.getDisplayName());
                newNode.setName(childNode.getName());
                if (parentNode != null) {
                    parentNode.addChild(newNode);
                }
                newNodePath.put(nodePath, newNode);
            }
        }
    }

    private static void bulidNodePathMap(AbstractTreeMenuNode node, String parentPath, Map<String, AbstractTreeMenuNode> nodePathMap) {
        TreeMenuFolderNode folderNode;
        String path = parentPath + "/" + node.getName();
        nodePathMap.put(path, node);
        if (node instanceof TreeMenuFolderNode && (folderNode = (TreeMenuFolderNode)node).getChildCount() > 0) {
            for (AbstractTreeMenuNode tempNode : folderNode.getChildren()) {
                TreeMenuFolderNode.bulidNodePathMap(tempNode, path, nodePathMap);
            }
        }
    }
}

