/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.lapp.domain;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.publish.lapp.domain.ILappContextHelper;
import com.kingdee.bos.qing.publish.lapp.model.LappUser;
import com.kingdee.bos.qing.publish.lapp.thirdapp.AbstractThirdAppContext;
import com.kingdee.bos.qing.publish.lapp.thirdapp.ThirdAppFactory;
import com.kingdee.bos.qing.publish.target.lapp.AbstractLappService;
import com.kingdee.bos.qing.publish.target.lapp.LappDomain;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.PermissionLappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfig;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LappContextDomain {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private IScheduleEngine scheduleEngine;
    private LappDao lappDao;
    private ILappContextHelper lappContextHelper;
    private ThirdPartyConfig thirdPartyConfig;
    private LappDomain lappDomain;

    public LappContextDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.scheduleEngine = scheduleEngine;
    }

    public LappContextDomain() {
    }

    public void setLappDomain(LappDomain lappDomain) {
        this.lappDomain = lappDomain;
    }

    private LappDomain getLappDomain() {
        if (this.lappDomain == null) {
            this.lappDomain = new LappDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.lappDomain;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    private ILappContextHelper getLappContextHelper() {
        if (this.lappContextHelper == null) {
            this.lappContextHelper = new ILappContextHelper(){

                @Override
                public ThirdPartyConfig getThirdPartyConfig() {
                    if (LappContextDomain.this.thirdPartyConfig == null) {
                        try {
                            LappContextDomain.this.thirdPartyConfig = LappContextDomain.this.getLappDao().getThirdPartyConfig();
                        }
                        catch (AbstractQingIntegratedException e) {
                            LogUtil.error((String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        catch (SQLException e) {
                            LogUtil.error((String)"\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                    }
                    return LappContextDomain.this.thirdPartyConfig;
                }
            };
        }
        return this.lappContextHelper;
    }

    public LappContext getLappContext(Context ctx) {
        String currentUserId = this.qingContext.getUserId();
        LappContext.UserType userType = this.getType();
        AbstractThirdAppContext lappContext = ThirdAppFactory.getInstanceByUserType(userType);
        return lappContext.getLappContext(ctx, currentUserId, this.getLappContextHelper());
    }

    public LappContext getLappContext(Context ctx, String appTypeStr) {
        String currentUserId = this.qingContext.getUserId();
        LappContext.UserType userType = null;
        userType = StringUtils.isEmpty((CharSequence)appTypeStr) ? this.getType() : LappContext.AppType.valueOf((String)appTypeStr).toPersistance();
        AbstractThirdAppContext lappContext = ThirdAppFactory.getInstanceByUserType(userType);
        return lappContext.getLappContext(ctx, currentUserId, this.getLappContextHelper());
    }

    public LappContext getLappContext(Context ctx, String appTypeStr, List<PublishLappConfigVO> publishLappConfigVOs) {
        String currentUserId = this.qingContext.getUserId();
        LappContext.UserType userType = null;
        if (StringUtils.isEmpty((CharSequence)appTypeStr)) {
            return this.loadPublishLappConfigVOs(ctx, publishLappConfigVOs, currentUserId);
        }
        userType = LappContext.AppType.valueOf((String)appTypeStr).toPersistance();
        AbstractThirdAppContext lappContext = ThirdAppFactory.getInstanceByUserType(userType);
        return lappContext.getLappContext(ctx, currentUserId, this.getLappContextHelper());
    }

    public List<LappContext> getLappContexts(Context ctx, List<String> userIds, String appType) {
        LappContext.UserType userType = null;
        userType = StringUtils.isNotBlank((CharSequence)appType) ? LappContext.AppType.valueOf((String)appType).toPersistance() : this.getType();
        AbstractThirdAppContext thirdLappContext = ThirdAppFactory.getInstanceByUserType(userType);
        return thirdLappContext.getLappContexts(ctx, userIds, this.getLappContextHelper());
    }

    public AbstractLappService.LappContextResult getLappContextsByIds(Context ctx, List<String> userIds, String appType) {
        ArrayList<String> failedUserIds = new ArrayList<String>();
        AbstractLappService.LappContextResult result = new AbstractLappService.LappContextResult();
        ArrayList authorizedUsers = new ArrayList();
        int count = 0;
        if (userIds != null && userIds.size() > 0) {
            List<LappContext> lappContexts = this.getLappContexts(ctx, userIds, appType);
            LappContext lappContext = null;
            for (int i = 0; i < lappContexts.size(); ++i) {
                lappContext = lappContexts.get(i);
                if (StringUtils.isEmpty((CharSequence)lappContext.getLappUserId())) {
                    failedUserIds.add(lappContext.getUserId());
                    ++count;
                    continue;
                }
                HashMap<String, String> user = new HashMap<String, String>();
                user.put("lappUserId", lappContext.getLappUserId());
                user.put("lappUserType", lappContext.getLappUserType());
                authorizedUsers.add(user);
            }
        }
        if (count > 0) {
            result.setSuccess(false);
        }
        if (failedUserIds.size() > 0) {
            try {
                List failedUserNames = IntegratedHelper.getUserNames((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, failedUserIds);
                result.setFailedUserNames(failedUserNames);
                result.setFailedUserIds(failedUserIds);
            }
            catch (IntegratedRuntimeException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        result.setAuthorizedUsers(authorizedUsers);
        return result;
    }

    public Map<String, Object> loadPermissionLappContexts(Context ctx, Map<String, Set<String>> permissionUserMap, Set<String> allUserIds, String appType) throws AbstractQingIntegratedException {
        List<LappContext> lappContexts = this.getLappContexts(ctx, new ArrayList<String>(allUserIds), appType);
        HashMap<String, LappContext> lappContextMap = new HashMap<String, LappContext>();
        HashMap<String, String> permissionUsers = new HashMap<String, String>();
        ArrayList<String> failedUserIds = new ArrayList<String>();
        for (LappContext lappContext : lappContexts) {
            if (StringUtils.isBlank((CharSequence)lappContext.getLappUserId())) {
                failedUserIds.add(lappContext.getUserId());
                continue;
            }
            lappContextMap.put(lappContext.getUserId(), lappContext);
            permissionUsers.put(lappContext.getLappUserId(), lappContext.getUserId());
        }
        ArrayList<PermissionLappContext> permissionLappContexts = new ArrayList<PermissionLappContext>();
        for (Map.Entry<String, Set<String>> entry : permissionUserMap.entrySet()) {
            ArrayList authorizedUsers = new ArrayList();
            for (String userId : entry.getValue()) {
                LappContext lappContext = (LappContext)lappContextMap.get(userId);
                if (lappContext == null) continue;
                HashMap<String, String> lappUser = new HashMap<String, String>();
                lappUser.put("lappUserId", lappContext.getLappUserId());
                lappUser.put("lappUserType", lappContext.getLappUserType());
                authorizedUsers.add(lappUser);
            }
            if (authorizedUsers.isEmpty()) continue;
            PermissionLappContext permissionLappContext = new PermissionLappContext();
            permissionLappContext.setPublishId(entry.getKey());
            permissionLappContext.setAuthorizedUsers(authorizedUsers);
            permissionLappContexts.add(permissionLappContext);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("permissionLappContexts", permissionLappContexts);
        hashMap.put("permissionUsers", permissionUsers);
        hashMap.put("authorizedUserNum", allUserIds.size() - failedUserIds.size());
        if (!failedUserIds.isEmpty()) {
            try {
                List list = IntegratedHelper.getUserNames((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, failedUserIds);
                hashMap.put("failedUserNames", list);
            }
            catch (IntegratedRuntimeException integratedRuntimeException) {
                LogUtil.error((String)integratedRuntimeException.getMessage(), (Throwable)integratedRuntimeException);
            }
        }
        return hashMap;
    }

    private LappContext.UserType getType() {
        List publishLappConfigs = this.getLappDomain().loadPublishLappConfigs(this.getAllConfigedAppType());
        LappContext.UserType userType = LappContext.UserType.YZJ_OPENID;
        if (!publishLappConfigs.isEmpty()) {
            userType = ((PublishLappConfig)publishLappConfigs.get(0)).getAppType().toPersistance();
        }
        return userType;
    }

    private LappContext loadPublishLappConfigVOs(Context ctx, List<PublishLappConfigVO> publishLappConfigVOs, String currentUserId) {
        List publishLappConfigs = this.getLappDomain().loadPublishLappConfigs(this.getAllConfigedAppType());
        LappContext currentLappContext = null;
        for (PublishLappConfig publishLappConfig : publishLappConfigs) {
            PublishLappConfigVO publishLappConfigVO = new PublishLappConfigVO();
            publishLappConfigVO.setAppType(publishLappConfig.getAppType());
            publishLappConfigVO.setId(publishLappConfig.getId());
            publishLappConfigVO.setOrderId(publishLappConfig.getOrderId());
            AbstractThirdAppContext thirdLappContext = ThirdAppFactory.getInstanceByUserType(publishLappConfig.getAppType().toPersistance());
            LappContext lappContext = thirdLappContext.getLappContext(ctx, currentUserId, this.getLappContextHelper());
            if (currentLappContext == null) {
                currentLappContext = lappContext;
            }
            publishLappConfigVO.setLappUserId(lappContext.getLappUserId());
            publishLappConfigVO.setLappUserType(lappContext.getLappUserType());
            publishLappConfigVO.setCorpId(lappContext.getCorpId());
            if (publishLappConfig.getAppType() == LappContext.AppType.thirdparty) {
                publishLappConfigVO.setAppImageFile(this.getLappContextHelper().getThirdPartyConfig().getAppImageFile());
            }
            publishLappConfigVOs.add(publishLappConfigVO);
        }
        if (currentLappContext == null) {
            AbstractThirdAppContext thirdLappContext = ThirdAppFactory.getInstanceByUserType(LappContext.UserType.YZJ_OPENID);
            return thirdLappContext.getLappContext(ctx, currentUserId, this.getLappContextHelper());
        }
        return currentLappContext;
    }

    private List<LappContext.AppType> getAllConfigedAppType() {
        ArrayList<LappContext.AppType> appTypes = new ArrayList<LappContext.AppType>();
        for (LappContext.UserType userType : ThirdAppFactory.getAllUserType()) {
            if (!ThirdAppFactory.getInstanceByUserType(userType).enable(this.qingContext, this.dbExcuter, this.getLappContextHelper())) continue;
            appTypes.add(LappContext.AppType.getAppTypeByUserType((LappContext.UserType)userType));
        }
        return appTypes;
    }

    public Map<String, List<LappUser>> getAllLappContextsByUserIds(Context ctx, List<String> userIds) {
        HashMap<String, List<LappUser>> result = new HashMap<String, List<LappUser>>(2);
        for (String userId : userIds) {
            result.put(userId, new ArrayList());
        }
        for (LappContext.UserType userType : ThirdAppFactory.getAllUserType()) {
            AbstractThirdAppContext thirdAppContext = ThirdAppFactory.getInstanceByUserType(userType);
            if (!thirdAppContext.enable(this.qingContext, this.dbExcuter, this.getLappContextHelper())) continue;
            List<LappContext> lappContexts = thirdAppContext.getLappContexts(ctx, userIds, this.getLappContextHelper());
            for (LappContext lappContext : lappContexts) {
                if (!StringUtils.isNotBlank((CharSequence)lappContext.getLappUserId())) continue;
                LappUser lappUser = new LappUser();
                lappUser.setLappUserId(lappContext.getLappUserId());
                lappUser.setLappUserType(lappContext.getLappUserType());
                ((List)result.get(lappContext.getUserId())).add(lappUser);
            }
        }
        return result;
    }

    public Map<String, String> getLappContextToken(Context ctx, String appTypeStr) {
        LappContext.AppType appType = LappContext.AppType.valueOf((String)appTypeStr);
        LappContext.UserType userType = appType.toPersistance();
        AbstractThirdAppContext lappContext = ThirdAppFactory.getInstanceByUserType(userType);
        String token = lappContext.getLappContextToken(ctx, this.getLappContextHelper());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("token", token);
        result.put("lappHomePageUrl", LappHelper.getLappHomePageUrl());
        return result;
    }
}

