/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OldScheduleUpdater {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private static final String oldFunctionName = "qing.data.schedule";
    private static final String newFunctionName = "qing.schedule";
    private static final String methodName = "<parameter name='methodName' alias='' type='STRING' entityMetaData='' value='extractData' valueText=''/></doc>";

    public OldScheduleUpdater(IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOldSchedule() {
        try {
            this.tx.beginRequired();
            List<String> oldSchedules = this.getOldSchedules();
            for (String jobDefId : oldSchedules) {
                this.updateScheduleInfo(jobDefId);
            }
        }
        catch (Throwable e) {
            this.tx.markRollback();
            LogUtil.error((String)"\u66f4\u65b0\u65e7\u7684\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    private List<String> getOldSchedules() throws SQLException, AbstractQingIntegratedException {
        String sql = "select *from t_job_def where fhandlerwrapper like '%com.kingdee.bos.qing.data.schedule.app.QingScheduleFunction-extractData%'";
        List oldSchedules = (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> schedules = new ArrayList<String>();
                while (rs.next()) {
                    schedules.add(rs.getString("fjobdefid"));
                }
                return schedules;
            }
        });
        return oldSchedules;
    }

    private void updateScheduleInfo(String jobDefId) throws SQLException, IOException, AbstractQingIntegratedException {
        String sql1 = "select fhandlerwrapper from t_job_def where fjobdefid=?";
        Object[] param = new Object[]{jobDefId};
        Reader reader = (Reader)this.dbExcuter.query(sql1, param, (ResultHandler)new ResultHandler<Reader>(){

            public Reader handle(ResultSet rs) throws SQLException {
                Reader r = null;
                if (rs.next()) {
                    r = rs.getCharacterStream("fhandlerwrapper");
                }
                return r;
            }
        });
        BufferedReader br = new BufferedReader(reader);
        String handlerWrapper = "";
        String line = "";
        while ((line = br.readLine()) != null) {
            handlerWrapper = handlerWrapper + line + "\r\n";
        }
        reader.close();
        handlerWrapper = handlerWrapper.replaceAll(oldFunctionName, newFunctionName);
        handlerWrapper = handlerWrapper.replaceAll("themeId", "params");
        handlerWrapper = handlerWrapper.replaceAll("extractData", "execute");
        handlerWrapper = handlerWrapper.replaceAll("</doc>", methodName);
        Object[] params = new Object[2];
        String sql2 = "update t_job_def set fhandlerwrapper=? where fjobdefid=?";
        params[0] = handlerWrapper;
        params[1] = jobDefId;
        this.dbExcuter.execute(sql2, params);
    }
}

