/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule.executer.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.datasource.DataSourceCreatorFactory;
import com.kingdee.bos.qing.common.i18n.EASMessages;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataThreadLocalUtil;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.SubjectPrepareDataContext;
import com.kingdee.bos.qing.preparedata.task.DataExtractTask;
import com.kingdee.bos.qing.preparedata.task.FromType;
import com.kingdee.bos.qing.publish.lapp.domain.LappContextDomain;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.thumbnail.ThumbnailDomainForExcuteDomain;
import com.kingdee.bos.qing.schedule.app.ScheduleException;
import com.kingdee.bos.qing.schedule.executer.AbstractScheduleExecuter;
import com.kingdee.bos.qing.schedule.model.ExecuteStateEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecutePO;
import com.kingdee.bos.qing.subject.exception.SubjectNotFoundException;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.UUID;

public class SubjectExtractDataScheduleExecuter
extends AbstractScheduleExecuter {
    public static final String SUBJECT_EXTRACT_DATA_SCHEDULE = "subject_extract_data_schedule_lock_";
    private LappContextDomain lappContextDomain;

    private LappContextDomain getLappContextDomain() {
        if (this.lappContextDomain == null) {
            this.lappContextDomain = new LappContextDomain(this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
        }
        return this.lappContextDomain;
    }

    @Override
    public void execute(Context ctx, String themeId, String userId, String orgId) throws Exception {
        ILock subejctScheduleLock = null;
        try {
            MultiDataThreadLocalUtil.setAsyncJoin((Boolean)false);
            subejctScheduleLock = LockFactory.createLock((String)(SUBJECT_EXTRACT_DATA_SCHEDULE + themeId));
            boolean isLock = subejctScheduleLock.tryLock();
            if (!isLock) {
                return;
            }
            String tag = UUID.randomUUID().toString();
            SubjectPrepareDataContext subjectPrepareDataContext = new SubjectPrepareDataContext();
            subjectPrepareDataContext.setQingContext(this.qingContext);
            subjectPrepareDataContext.setDbExcuter(this.dbExcuter);
            subjectPrepareDataContext.setTx(this.tx);
            subjectPrepareDataContext.setTag(tag);
            subjectPrepareDataContext.setTimeStamp(System.currentTimeMillis());
            subjectPrepareDataContext.setFromType(FromType.subject);
            subjectPrepareDataContext.setDealProgresss(false);
            subjectPrepareDataContext.setStartBySchedule(true);
            subjectPrepareDataContext.setThemeId(themeId);
            subjectPrepareDataContext.setSaveMode(true);
            DataExtractTask dataExtractTask = new DataExtractTask((AbstractPrepareDataContext)subjectPrepareDataContext);
            dataExtractTask.call();
            this.batchGenerateAndUpdateMobileImage(ctx, themeId, userId, tag);
        }
        catch (SubjectNotFoundException e) {
            String msg = "schedule extract data failed.,userId =" + userId + ",themeId=" + themeId;
            try {
                this.scheduleEngine.deleteJob(this.qingContext, null, themeId + userId);
            }
            catch (Exception e1) {
                LogUtil.error((String)e1.getMessage(), (Throwable)e1);
            }
            throw new ScheduleException(msg, e);
        }
        catch (Exception e) {
            String msg = "schedule extract data failed.,userId =" + userId + ",themeId=" + themeId;
            throw new ScheduleException(msg, e);
        }
        finally {
            MultiDataThreadLocalUtil.remove();
            if (subejctScheduleLock != null) {
                subejctScheduleLock.unlock();
            }
        }
    }

    private void batchGenerateAndUpdateMobileImage(Context ctx, String themeId, String userId, String tag) throws ScheduleException {
        LappContext lappCtx = this.getLappContextDomain().getLappContext(ctx);
        try {
            AbstractDomain.IDataSourceCreator dataSourceCreator = DataSourceCreatorFactory.getDataSourceCreator((QingContext)this.qingContext, (String)tag);
            ThemeDomain themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
            ThemePO themePO = themeDomain.getThemeByID(themeId);
            if (themePO != null && themePO.getUserID().equals(userId)) {
                ThumbnailDomainForExcuteDomain thumbnailDomainForExcuteDomain = new ThumbnailDomainForExcuteDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
                thumbnailDomainForExcuteDomain.batchGenerateAndUpdateMobileImage(dataSourceCreator, themeId, lappCtx);
            }
        }
        catch (Exception e) {
            String msg = "schedule extract data failed.,userId =" + userId + ",themeId=" + themeId;
            throw new ScheduleException(msg, e);
        }
    }

    @Override
    public ScheduleExecutePO getScheduleExecutePO(QingContext qingContext, String params, ExecuteStateEnum executeStateEnum) {
        String sourceId = params;
        String scheduleName = EASMessages.getMLS(qingContext, "subjectExtractDataSchedule", "\u8f7b\u5206\u6790\u6570\u636e\u5efa\u6a21\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        String sourceName = EASMessages.getMLS(qingContext, "subjectExtractDataSchedule", "\u8f7b\u5206\u6790\u6570\u636e\u5efa\u6a21\u5b9a\u65f6\u4efb\u52a1-") + sourceId;
        try {
            ThemeDaoImpl themeDao = new ThemeDaoImpl(this.dbExcuter);
            ThemePO themePO = themeDao.getThemeByID(sourceId);
            sourceName = themePO.getThemeName();
        }
        catch (Exception themeDao) {
            // empty catch block
        }
        String scheduleNameEnum = "extractThemeData";
        ScheduleExecutePO scheduleExecutePO = new ScheduleExecutePO();
        scheduleExecutePO.setTenantId(qingContext.getTenantId());
        scheduleExecutePO.setUserId(qingContext.getUserId());
        scheduleExecutePO.setScheduleName(scheduleName);
        scheduleExecutePO.setSourceId(sourceId);
        scheduleExecutePO.setSourceName(sourceName);
        scheduleExecutePO.setScheduleExecuterNameEnum(scheduleNameEnum);
        scheduleExecutePO.setExecuteStateEnum(executeStateEnum);
        return scheduleExecutePO;
    }
}

