/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.context.QingIntegratedContext;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.LanguageManager;
import com.kingdee.bos.qing.common.session.AbstractQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.session.JVMSessionFactoryStrategyImpl;
import com.kingdee.bos.qing.common.systemvar.DepartmentSystemVarValue;
import com.kingdee.bos.qing.common.systemvar.DeptAndSubSystemValue;
import com.kingdee.bos.qing.common.systemvar.OrgRangeSystemVarValue;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.common.systemvar.SystemVarValue;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.UnsupportedEncodingException;

public class QingIntegratedUtil {
    private static JVMSessionFactoryStrategyImpl jvmSessionFactory = new JVMSessionFactoryStrategyImpl();
    private static LicenseBaseInfo license = null;

    public static QingIntegratedContext initQingIntegratedContext(Context ctx, String userAgent) {
        QingIntegratedContext saContext = new QingIntegratedContext();
        saContext.setBosContext(ctx);
        saContext.setAccountId(ctx.getAIS());
        saContext.setTenantId(ctx.getAIS());
        saContext.setSessionID(ctx.getContextID());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        saContext.addSystemVar(SystemVarType.USER_ID, new SystemVarValue((Object)userInfo.getId().toString()));
        saContext.addSystemVar(SystemVarType.USER_NAME, new SystemVarValue((Object)userInfo.getName()));
        saContext.addSystemVar(SystemVarType.DEPARTMENT_IDS, new DepartmentSystemVarValue(userInfo));
        saContext.addSystemVar(SystemVarType.DEPARTMENT_AND_SUBORDINATE_IDS, new DeptAndSubSystemValue(userInfo));
        OrgUnitInfo orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        saContext.addSystemVar(SystemVarType.ORG_ID, new SystemVarValue((Object)orgInfo.getId().toString()));
        saContext.addSystemVar(SystemVarType.ORG_NAME, new SystemVarValue((Object)orgInfo.getName()));
        saContext.addSystemVar(SystemVarType.ORG_RANGE_ID, new OrgRangeSystemVarValue(userInfo, OrgRangeType.BIZ_ORG_TYPE));
        saContext.addSystemVar(SystemVarType.ADMIN_ORG_RANGE_ID, new OrgRangeSystemVarValue(userInfo, OrgRangeType.ADMIN_ORG_TYPE));
        IQingSession qingSession = QingSessionUtil.getQingSession((String)ctx.getContextID());
        qingSession.login(ctx.getContextID());
        String enterpriseName = null;
        try {
            if (license == null) {
                license = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo();
            }
            saContext.setLicenseNO(license.getSerialNum());
            enterpriseName = new String(Base64.decode((String)license.getLicenseTo()), "gbk");
            saContext.setEnterpriseName(enterpriseName);
        }
        catch (LicenseException e) {
            LogUtil.error((String)("LicenseException : " + (Object)((Object)e)));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error((String)("UnsupportedEncodingException : " + e));
        }
        LanguageManager lanManager = new LanguageManager();
        lanManager.setLocale(ctx.getOriginLocale());
        DefaultI18nContext i18nContext = new DefaultI18nContext();
        i18nContext.setLanManager(lanManager);
        saContext.setIi18nContext((II18nContext)i18nContext);
        saContext.setUserAgent(userAgent);
        return saContext;
    }

    public static void initQingIntegratedContext(QingIntegratedContext saContext) {
        Context context = saContext.getBosContext();
        AbstractQingSession qingSession = jvmSessionFactory.createSessionableCache(context.getContextID());
        qingSession.login(context.getContextID());
        QingSessionUtil.setQingSessionImpl((IQingSession)qingSession);
    }
}

