/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.cache;

import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.qing.common.cache.FormDataSource;
import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.cache.LinkageFormInfo;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AbstractDataSource
implements ISessionCacheable,
Serializable {
    private static final long serialVersionUID = -7570082834126838445L;
    private static final String KEY = "Qing.Datasource.";
    private static JsonUtil.CustomJsonParser customJsonParser = new JsonUtil.CustomJsonParser();
    private String tag;
    private long lastVisitTime;
    private long extractDataTime;
    private String originalCreatorId;
    private boolean hasDirectModeTable = false;
    private LinkageContext linkageContext = new LinkageContext();
    private transient List<TraceSpan> extractDataTraceSpans;
    private String extractDataTraceSpansFile;

    public static void addCustomDecoder(Class<?> clz, JsonUtil.AbstractJsonDecoder<?> decoder) {
        customJsonParser.addCustomDecoder(clz, decoder);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getLastVisitTime() {
        return this.lastVisitTime;
    }

    public void setLastVisitTime(long lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public long getExtractDataTime() {
        return this.extractDataTime;
    }

    public void setExtractDataTime(long extractDataTime) {
        this.extractDataTime = extractDataTime;
    }

    public String getOriginalCreatorId() {
        return this.originalCreatorId;
    }

    public void setOriginalCreatorId(String originalCreatorId) {
        this.originalCreatorId = originalCreatorId;
    }

    public boolean hasDirectModeTable() {
        return this.hasDirectModeTable;
    }

    public void setHasDirectModeTable(boolean hasDirectModeTable) {
        this.hasDirectModeTable = hasDirectModeTable;
    }

    public void addLinkageFormInfo(String entityName, LinkageFormInfo formInfo) {
        this.linkageContext.addLinkageFormInfo(entityName, formInfo);
    }

    public void addAllLinkageFormInfo(Map<String, LinkageFormInfo> linkFormInfo) {
        this.linkageContext.addAllLinkageFormInfo(linkFormInfo);
    }

    public void setEmbedLinkage(boolean isEmbedLinkage) {
        this.linkageContext.setEmbed(isEmbedLinkage);
    }

    public LinkageContext getLinkageContext() {
        return this.linkageContext;
    }

    public String getCacheKey() {
        return KEY + this.tag;
    }

    public static String getCacheKey(String tag) {
        return KEY + tag;
    }

    public List<TraceSpan> getExtractDataTraceSpans() {
        if (this.extractDataTraceSpans != null) {
            return this.extractDataTraceSpans;
        }
        if (this.extractDataTraceSpansFile == null) {
            return Collections.emptyList();
        }
        try {
            byte[] bytes = FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.DS_CACHE, (String)this.extractDataTraceSpansFile);
            String json = new String(bytes, StandardCharsets.UTF_8);
            return (List)customJsonParser.getGson().fromJson(json, new TypeToken<List<TraceSpan>>(){}.getType());
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void setExtractDataTraceSpans(List<TraceSpan> extractDataTraceSpans) {
        this.extractDataTraceSpans = extractDataTraceSpans;
    }

    public boolean isMetaChanged(AbstractDataSource dataSource) throws AbstractDataSourceException {
        return false;
    }

    public String toJson() {
        if (this.extractDataTraceSpansFile == null) {
            IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.DS_CACHE);
            try {
                qingFile.write(new IWriteCall(){

                    public void call(OutputStream outputStream) throws IOException {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(JsonUtil.encodeToString((Object)AbstractDataSource.this.extractDataTraceSpans).getBytes(StandardCharsets.UTF_8));
                        IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                }, true);
                this.extractDataTraceSpansFile = qingFile.getName();
            }
            catch (IOException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return JsonUtil.encodeToString((Object)this);
    }

    public AbstractDataSource fromJson(String json) {
        return (AbstractDataSource)JsonUtil.decodeFromString((JsonUtil.CustomJsonParser)customJsonParser, (String)json, AbstractDataSource.class);
    }

    public int getTimeoutSeconds() {
        return 60;
    }

    public boolean supportPublishWithCarryData() {
        return true;
    }

    static {
        customJsonParser.addCustomDecoder(AbstractQingFileType.class, (JsonUtil.AbstractJsonDecoder)new AbstractQingFileTypeJsonDecoder());
        customJsonParser.addCustomDecoder(AbstractDataSource.class, (JsonUtil.AbstractJsonDecoder)new DefaultDataSourceJsonDecoder());
    }

    private static class AbstractQingFileTypeJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractQingFileType> {
        private AbstractQingFileTypeJsonDecoder() {
        }

        protected AbstractQingFileType decode(JsonUtil.AbstractJsonDecoder.Json json) {
            return FileTypeUtil.getInstanceByTypeIndex((int)Integer.parseInt(json.getAttrValue("typeIndex")));
        }
    }

    public static abstract class AbstractDataSourceJsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractDataSource> {
        protected abstract AbstractDataSource doOtherDecode(JsonUtil.AbstractJsonDecoder.Json var1);

        protected AbstractDataSource decode(JsonUtil.AbstractJsonDecoder.Json json) {
            if (json.hasAttr("fileName")) {
                return (AbstractDataSource)this.fromJson(json, FormDataSource.class);
            }
            if (json.hasAttr("boxXMLModelFile") && !json.hasAttr("reportDataSourceTag")) {
                return (AbstractDataSource)this.fromJson(json, ThemeDataSource.class);
            }
            return this.doOtherDecode(json);
        }
    }

    public static class DefaultDataSourceJsonDecoder
    extends AbstractDataSourceJsonDecoder {
        @Override
        protected AbstractDataSource doOtherDecode(JsonUtil.AbstractJsonDecoder.Json json) {
            throw new RuntimeException("Unknown AbstractDataSource.");
        }
    }
}

