/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.cache;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.CacheJoinDataFile;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public abstract class MultiFileDataSource
extends AbstractDataSource {
    private static final long serialVersionUID = -8133653327459475013L;
    private String boxXMLModelFile;
    private transient Box box;
    private Map<String, String> dataFiles;
    private List<CacheJoinDataFile> cacheJoinDataFiles;
    private transient Map<Set<String>, AbstractSingleDataSourceVisitor> dataSourcesMap;

    public abstract String getThemeId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Box getBoxModel() {
        if (this.box != null) {
            return this.box;
        }
        if (this.boxXMLModelFile == null) {
            return null;
        }
        QingInputStream inputStream = null;
        try {
            this.box = new Box();
            IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.DS_CACHE, (String)this.boxXMLModelFile);
            inputStream = qingFile.getInputStream();
            Element element = XmlUtil.loadRootElement((InputStream)inputStream);
            this.box.fromXml(element, true);
        }
        catch (Exception e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return this.box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBoxXMLModel() {
        String boxXMLModel = null;
        if (this.boxXMLModelFile != null) {
            Object inputStream = null;
            try {
                boxXMLModel = new String(FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.DS_CACHE, (String)this.boxXMLModelFile), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                try {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        }
        if (this.box != null && boxXMLModel == null) {
            boxXMLModel = new String(XmlUtil.toByteArray((Element)this.box.toXml()), StandardCharsets.UTF_8);
        }
        return boxXMLModel;
    }

    public void setBox(Box box) {
        this.box = box;
        List abstractEntities = box.getEntities();
        for (AbstractEntity abstractEntity : abstractEntities) {
            if (!abstractEntity.hasDirectModel()) continue;
            this.setHasDirectModeTable(true);
            break;
        }
    }

    public void setDataFiles(Map<String, String> dataFiles) {
        this.dataFiles = dataFiles;
    }

    public Map<String, String> getDataFiles() {
        return this.dataFiles;
    }

    @Override
    public String toJson() {
        if (this.boxXMLModelFile == null) {
            IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.DS_CACHE);
            try {
                qingFile.write(new IWriteCall(){

                    public void call(OutputStream outputStream) throws IOException {
                        XmlUtil.save((Element)MultiFileDataSource.this.box.toXml(), (OutputStream)outputStream);
                    }
                }, true);
                this.boxXMLModelFile = qingFile.getName();
            }
            catch (IOException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return super.toJson();
    }

    public void addCacheJoinDataFiles(Set<String> key, String fileName) {
        if (this.cacheJoinDataFiles == null) {
            this.cacheJoinDataFiles = new LinkedList<CacheJoinDataFile>();
        }
        CacheJoinDataFile cacheJoinDataFile = new CacheJoinDataFile();
        cacheJoinDataFile.setKeys(key);
        cacheJoinDataFile.setName(fileName);
        this.cacheJoinDataFiles.add(cacheJoinDataFile);
    }

    public Map<Set<String>, String> getCacheJoinDataFiles() {
        Map<Set<String>, String> cacheJoinDataFilesMap = Collections.emptyMap();
        if (this.cacheJoinDataFiles != null) {
            cacheJoinDataFilesMap = new HashMap<Set<String>, String>(this.cacheJoinDataFiles.size());
            for (CacheJoinDataFile cacheJoinDataFile : this.cacheJoinDataFiles) {
                cacheJoinDataFilesMap.put(cacheJoinDataFile.getKeys(), cacheJoinDataFile.getName());
            }
        }
        return cacheJoinDataFilesMap;
    }

    @Override
    public boolean isMetaChanged(AbstractDataSource dataSource) throws AbstractDataSourceException {
        if (!(dataSource instanceof MultiFileDataSource)) {
            return true;
        }
        MultiFileDataSource multiFileDataSource = (MultiFileDataSource)dataSource;
        String boxXMLModel = this.getBoxXMLModel();
        String otherBoxXMLModel = multiFileDataSource.getBoxXMLModel();
        if (boxXMLModel == null && otherBoxXMLModel == null) {
            return true;
        }
        if (boxXMLModel == null || otherBoxXMLModel == null) {
            return false;
        }
        return !boxXMLModel.equals(otherBoxXMLModel);
    }

    public Map<Set<String>, AbstractSingleDataSourceVisitor> getDataFileVisitorMaps() throws AbstractDataSourceException {
        if (this.dataSourcesMap == null) {
            this.dataSourcesMap = new HashMap<Set<String>, AbstractSingleDataSourceVisitor>(16);
            Map<String, String> dataFiles = this.getDataFiles();
            for (Map.Entry<String, String> dataFilesEntry : dataFiles.entrySet()) {
                String filePath = dataFilesEntry.getValue();
                IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)filePath);
                HashSet<String> key = new HashSet<String>();
                key.add(dataFilesEntry.getKey());
                this.dataSourcesMap.put(key, (AbstractSingleDataSourceVisitor)new QSDataSourceVisitor(dataFile));
            }
            Map<Set<String>, String> cacheJoinDataFiles = this.getCacheJoinDataFiles();
            for (Map.Entry<Set<String>, String> cacheJoinDataFileEntry : cacheJoinDataFiles.entrySet()) {
                String fileName = cacheJoinDataFileEntry.getValue();
                IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)fileName);
                this.dataSourcesMap.put(cacheJoinDataFileEntry.getKey(), (AbstractSingleDataSourceVisitor)new QSDataSourceVisitor(dataFile));
            }
        }
        return this.dataSourcesMap;
    }
}

