/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.datasource;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.ExhibitionCacheException;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.datasource.cache.DataSourceCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataSourceWriter;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.PostExecuteDomain;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ExportStatus;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class AbstractImpl
implements AbstractDomain.IDataSourceCreator {
    public final IDataSourceVisitor createCachedDataSourceVisitor(String key) throws AbstractDataSourceException {
        DataSourceCache dataSourceCache = new DataSourceCache(key);
        if (!dataSourceCache.exists()) {
            throw new IllegalArgumentException("dataSourceCache not found:" + key);
        }
        return dataSourceCache.createVisitor();
    }

    public final PostExecuteDomain.AbstractExhibitionCacheWriter createExhibitionCacheWriter(QingContext ctx) {
        return new QSExhibitionCacheWriter(ctx);
    }

    public final PostExecuteDomain.AbstractExhibitionCacheReader createExhibitionCacheReader() {
        return new QSExhibitionCacheReader();
    }

    public static class QSExhibitionCacheReader
    extends PostExecuteDomain.AbstractExhibitionCacheReader {
        private int _headCount = 0;
        private int _cellCount = 0;
        private IDataIterator _iterator;
        private Map<String, Object> _rowData;
        private int _rowIdx;
        private long _rowSize;

        protected void seekCachedRow(String cacheKey, int rowIdx) throws ExhibitionCacheException {
            this._rowIdx = rowIdx;
            String sExportStatus = null;
            while (true) {
                sExportStatus = QingSessionUtil.get((String)ExportStatus.getExportStatusKey((String)cacheKey));
                if (!ExportStatus.EXPORTING.name().equals(sExportStatus)) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            if (ExportStatus.EXCEPTION.name().equals(sExportStatus)) {
                int iErrorCode = Integer.parseInt(QingSessionUtil.get((String)ExportStatus.getExportErrorCodeKey((String)cacheKey)));
                String sErrorMessage = QingSessionUtil.get((String)ExportStatus.getExportErrorMessageKey((String)cacheKey));
                throw ExhibitionCacheException.forWrite((String)sErrorMessage);
            }
            QingSessionUtil.remove((String)ExportStatus.getExportStatusKey((String)cacheKey));
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.EXHIBITION, (String)cacheKey);
            try {
                QSDataSourceVisitor sourceVisitor = new QSDataSourceVisitor(qingFileVisitor);
                this._rowSize = sourceVisitor.getRowCount();
                this._iterator = sourceVisitor.iterator();
                MetaInfo metaInfo = sourceVisitor.getMetaInfo();
                this._headCount = 0;
                this._cellCount = 0;
                HashSet<DSFieldKey> fields = new HashSet<DSFieldKey>(metaInfo.getFieldNames().size());
                for (String fieldName : metaInfo.getFieldNames()) {
                    if (fieldName.startsWith("H")) {
                        ++this._headCount;
                    } else if (fieldName.startsWith("C")) {
                        ++this._cellCount;
                    }
                    fields.add(new DSFieldKey(fieldName));
                }
                HashSet<UnderDSContinuousFilter> filters = new HashSet<UnderDSContinuousFilter>();
                UnderDSContinuousFilter filter = new UnderDSContinuousFilter(new DSFieldKey("SE"));
                filter.setFloor((Object)new BigDecimal(rowIdx));
                filters.add(filter);
                this._iterator.init(fields, filters, null);
                if (this._iterator.hasNextRow()) {
                    this._rowData = this._iterator.nextRow();
                }
            }
            catch (AbstractDataSourceException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
            catch (InterruptedException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
        }

        protected int getLeftHeadColumns() {
            return this._headCount;
        }

        protected int getCellColumns() {
            return this._cellCount;
        }

        protected boolean hasNextCachedRow() throws ExhibitionCacheException {
            try {
                return (long)(this._rowIdx + 1) < this._rowSize && this._iterator.hasNextRow();
            }
            catch (AbstractDataSourceException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
            catch (InterruptedException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
        }

        protected void nextCachedRow() throws ExhibitionCacheException {
            ++this._rowIdx;
            try {
                this._rowData = this._iterator.nextRow();
            }
            catch (AbstractDataSourceException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
            catch (InterruptedException e) {
                throw ExhibitionCacheException.forRead((Throwable)e);
            }
        }

        protected Object getCachedValue(String fieldName) {
            return this._rowData.get(fieldName);
        }
    }

    public static class QSExhibitionCacheWriter
    extends PostExecuteDomain.AbstractExhibitionCacheWriter
    implements Callable<Object> {
        private QingContext _ctx;
        private TableView _tableView;
        private boolean _isWithTree;
        private IQingFile _cacheFile;
        private QSDataSourceWriter _writer;
        private MetaInfo _metaInfo;
        private Object[] _data;
        private long _rowIndex = -1L;

        public QSExhibitionCacheWriter(QingContext ctx) {
            this._ctx = ctx;
            this._cacheFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXHIBITION);
            this._writer = new QSDataSourceWriter(this._cacheFile);
        }

        @Override
        public final Object call() {
            try {
                QingSessionUtil.set((String)ExportStatus.getExportStatusKey((String)this.createCacheKey()), (String)ExportStatus.EXPORTING.name());
                this.cache(this._tableView);
                QingSessionUtil.set((String)ExportStatus.getExportStatusKey((String)this.createCacheKey()), (String)ExportStatus.FINISH.name());
            }
            catch (ExhibitionCacheException e) {
                this.setExportExcetion(this.createCacheKey(), (AbstractQingException)e);
            }
            catch (Throwable e) {
                ExhibitionCacheException ex = ExhibitionCacheException.forWrite((Throwable)e);
                this.setExportExcetion(this.createCacheKey(), (AbstractQingException)ex);
            }
            return null;
        }

        public final void asyncCache(TableView tv, boolean isWithTree) {
            this._tableView = tv;
            this._isWithTree = isWithTree;
            ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, (Callable)this, (QingContext)this._ctx);
        }

        public String createCacheKey() {
            return this._cacheFile.getName();
        }

        protected void cacheMeta(int leftHeadColumns, int cellColumns) throws ExhibitionCacheException {
            String fieldName;
            int headIndex;
            this._metaInfo = new MetaInfo();
            this._metaInfo.addField("SE", "SE", DataType.INT);
            for (headIndex = 0; headIndex < leftHeadColumns; ++headIndex) {
                fieldName = "H" + headIndex;
                this._metaInfo.addField(fieldName, fieldName, DataType.STRING);
            }
            if (this._isWithTree) {
                for (headIndex = 0; headIndex < leftHeadColumns; ++headIndex) {
                    fieldName = "L" + headIndex;
                    this._metaInfo.addField(fieldName, fieldName, DataType.INT);
                }
            }
            for (int cellIndex = 0; cellIndex < cellColumns; ++cellIndex) {
                fieldName = "C" + cellIndex;
                this._metaInfo.addField(fieldName, fieldName, DataType.STRING);
            }
            this._writer.start(this._metaInfo);
        }

        protected void cacheOneRowStart() throws ExhibitionCacheException {
            ++this._rowIndex;
            this._data = new Object[this._metaInfo.getSize()];
            this._data[0] = this._rowIndex;
        }

        protected void cacheValue(String fieldName, Object value) throws ExhibitionCacheException {
            int fieldNameIndex = this._metaInfo.getFieldNameIndex(fieldName);
            this._data[fieldNameIndex] = value;
        }

        protected void cacheOneRowEnd() throws ExhibitionCacheException {
            try {
                this._writer.writeData(this._data);
            }
            catch (AbstractDataSourceException e) {
                throw ExhibitionCacheException.forWrite((Throwable)e);
            }
            catch (InterruptedException e) {
                throw ExhibitionCacheException.forWrite((Throwable)e);
            }
        }

        protected void cacheAllEnd(Exception e) throws ExhibitionCacheException {
            try {
                this._writer.finishWriteData();
            }
            catch (DataSourcePersistenceException e1) {
                throw ExhibitionCacheException.forWrite((Throwable)e);
            }
            this._writer.close(e);
        }

        private void setExportExcetion(String key, AbstractQingException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            QingSessionUtil.set((String)ExportStatus.getExportStatusKey((String)key), (String)ExportStatus.EXCEPTION.name());
            QingSessionUtil.set((String)ExportStatus.getExportErrorCodeKey((String)key), (String)(e.getErrorCode() + ""));
            QingSessionUtil.set((String)ExportStatus.getExportErrorMessageKey((String)key), (String)e.getMessage());
        }
    }
}

