/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.cache;

import com.kingdee.bos.qing.common.cache.AbstractFileCache;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Element;

public class DashboardModelBookCache
extends AbstractFileCache {
    private byte[] value;

    public DashboardModelBookCache(String key) {
        super(key, QingTempFileType.DSB_CACHE);
    }

    public byte[] getValue() throws IOException {
        if (this.value == null && this.exists()) {
            this.load();
        }
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    protected void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(inputStream);
            this.value = new byte[dataInputStream.readInt()];
            dataInputStream.read(this.value);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{dataInputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{dataInputStream});
    }

    protected void write(OutputStream outputStream) throws IOException {
        outputStream = new DataOutputStream(outputStream);
        DataOutputStream dataOutputStream = (DataOutputStream)outputStream;
        dataOutputStream.writeInt(this.value.length);
        dataOutputStream.write(this.value);
        dataOutputStream.flush();
    }

    public ModelBook toModelBook() throws PersistentModelParseException, PersistentModelTooModernException {
        ModelBook modelBook = new ModelBook();
        Element xmlNode = null;
        try {
            this.load();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
            xmlNode = XmlUtil.loadRootElement((InputStream)bais);
        }
        catch (Exception e) {
            throw new PersistentModelParseException((Throwable)e);
        }
        modelBook.fromXml(xmlNode);
        return modelBook;
    }

    public ByteArrayInputStream toByteArrayInputStream() {
        ByteArrayInputStream bais = null;
        try {
            this.load();
            bais = new ByteArrayInputStream(this.value);
        }
        catch (IOException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return bais;
    }
}

