/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdom2.Element;

public class DashboardDao {
    public static final String T_QING_DSB_CONTENT = "t_qing_dsb_content";
    public static final String T_QING_DSB_REF = "t_qing_dsb_ref";
    public static final String T_QING_DSB_REF_CONTENT = "t_qing_dsb_ref_content";
    private IDBExcuter dbExcuter;
    private String refType = "Map";
    private IThemeDao themeDao;

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    public DashboardDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public List<ReferenceMap> getRefList(String dsbId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FUID,FRefToId,FFullPath,FRefType  FROM T_QING_Dsb_Ref WHERE FDSBID=?", new Object[]{dsbId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    String outerRefKey = UUID.randomUUID().toString();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.put((Object)"outerRefKey", (Object)outerRefKey);
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    RefTypeEnum refEnum = RefTypeEnum.valueOf((String)rs.getString("FRefType").toLowerCase());
                    if (RefTypeEnum.picture == refEnum) {
                        String widgetSourcePath = DashboardModelUtil.parseFullPath(rs.getString("FFullPath"), refEnum);
                        refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                    }
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> getExecutionRefList(String executionId, int type) throws AbstractQingIntegratedException, SQLException {
        String sqlContent;
        switch (type) {
            case 0: {
                sqlContent = "SELECT FID, FUID,FRefToId,FFullPath,FRefType  FROM T_QING_PUB_DSB_REF where FPUBLISHID = ?";
                break;
            }
            case 1: {
                sqlContent = "SELECT FID,FREFUID AS FUID,FRefToId,FFullPath,FRefType  FROM t_qing_tp_dsb_ref where fsourceid =?";
                break;
            }
            default: {
                sqlContent = "SELECT FID, FUID,FRefToId,FFullPath,FRefType  FROM T_QING_Dsb_Ref WHERE FDSBID=?";
            }
        }
        return (List)this.dbExcuter.query(sqlContent, new Object[]{executionId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    String outerRefKey = UUID.randomUUID().toString();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.put((Object)"outerRefKey", (Object)outerRefKey);
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    RefTypeEnum refEnum = RefTypeEnum.valueOf((String)rs.getString("FRefType").toLowerCase());
                    if (RefTypeEnum.picture == refEnum) {
                        String widgetSourcePath = DashboardModelUtil.parseFullPath(rs.getString("FFullPath"), refEnum);
                        refItem.put((Object)"widgetSourcePath", (Object)widgetSourcePath);
                    }
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public ReferenceMap loadRef(String dsbId, String uid) throws AbstractQingIntegratedException, SQLException {
        return (ReferenceMap)this.dbExcuter.query("SELECT FID, FUID,FRefToId,FFullPath,FRefType  FROM T_QING_Dsb_Ref WHERE FDSBID=? AND FUID = ?", new Object[]{dsbId, uid}, (ResultHandler)new ResultHandler<ReferenceMap>(){

            public ReferenceMap handle(ResultSet rs) throws SQLException {
                ReferenceMap refItem = new ReferenceMap();
                if (rs.next()) {
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                }
                return refItem;
            }
        });
    }

    public byte[] loadShemaContent(String uid, String dsbId) throws SQLException, AbstractQingIntegratedException {
        return this.readBlock("SELECT FCONTENT FROM T_QING_Dsb_Ref_Content WHERE FREFUID=? AND FDSBID=? ORDER BY FCONTENTINDEX ASC", new Object[]{uid, dsbId});
    }

    public byte[] loadExecutionShemaContent(String uid, String dsbId, int type) throws SQLException, AbstractQingIntegratedException {
        String sqlContent;
        switch (type) {
            case 0: {
                sqlContent = "SELECT FCONTENT FROM t_qing_pub_dsb_ref_cont WHERE FREFUID=? AND FPUBLISHID=? ORDER BY FCONTENTINDEX ASC";
                break;
            }
            case 1: {
                sqlContent = "SELECT FCONTENT FROM t_qing_tp_dsb_ref_cont WHERE FREFUID = ? and FSOURCEID = ? ORDER BY FCONTENTINDEX ASC";
                break;
            }
            default: {
                sqlContent = "SELECT FCONTENT FROM T_QING_Dsb_Ref_Content WHERE FREFUID=? AND FDSBID=? ORDER BY FCONTENTINDEX ASC";
            }
        }
        return this.readBlock(sqlContent, new Object[]{uid, dsbId});
    }

    public void saveRefInfo(ReferenceMap refItem, String dsbId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[6];
        String fId = this.dbExcuter.genStringId(T_QING_DSB_REF);
        param[0] = fId;
        param[1] = refItem.getUid();
        param[2] = dsbId;
        param[3] = StringUtils.isBlank((CharSequence)refItem.getRefToId()) ? " " : refItem.getRefToId();
        param[4] = StringUtils.isBlank((CharSequence)refItem.getRefToId()) ? refItem.getRefToFullPath() : " ";
        param[5] = refItem.getRefType();
        this.dbExcuter.execute("INSERT INTO T_QING_Dsb_REF (FID,FUID,FDsbID,FRefToID,FFullPath,FRefType) VALUES(?,?,?,?,?,?)", param);
        refItem.put((Object)"id", (Object)fId);
    }

    public void saveRefSource(ReferenceMap refItem, byte[] dsbModelBytes, String dsbId) throws AbstractQingIntegratedException, SQLException {
        int length = dsbModelBytes.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[5];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fId = this.dbExcuter.genStringId(T_QING_DSB_REF_CONTENT);
                param[0] = fId;
                param[1] = refItem.getUid();
                param[2] = i;
                param[3] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                param[4] = dsbId;
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Dsb_REF_CONTENT (FID,FRefUID,FContentIndex,FContent,FDSBID) VALUES(?,?,?,?,?)", params);
        }
    }

    public void saveRefSource(ReferenceMap refItem, ModelBook modelBook, String dsbId) throws AbstractQingIntegratedException, SQLException {
        byte[] dsbModelBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        this.saveRefSource(refItem, dsbModelBytes, dsbId);
    }

    public void saveDsbContent(String dsbId, DashboardModel dsbModel, InputStream dsbModelOrignalBytes) throws AbstractQingIntegratedException, SQLException, EncryptedLicenseCheckException, PersistentModelParseException {
        InputStream dbStream = this.loadDashboardStream(dsbId);
        this.deleteDsbContent(dsbId);
        byte[] dsbModelBytes = DashboardSerializationUtil.toBytes(dsbModel, dsbModelOrignalBytes, dbStream);
        int length = dsbModelBytes.length;
        if (length > 0) {
            byte[] modelStartByte = new byte[1];
            System.arraycopy(dsbModelBytes, 0, modelStartByte, 0, 1);
            try {
                String magicFlag = new String(modelStartByte, "UTF-8");
                if (!"<".equals(magicFlag)) {
                    this.getThemeDao().updateThemeEncryptedStatus(dsbId, 1);
                }
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[4];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fid = this.dbExcuter.genStringId(T_QING_DSB_CONTENT);
                param[0] = fid;
                param[1] = dsbId;
                param[2] = i;
                param[3] = this.dbExcuter.createSqlParameterBytes(dsbModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Dsb_Content (FID,FDsbID,FContentIndex,FContent) VALUES(?,?,?,?)", params);
        }
    }

    public DashboardModel loadDashboard(String dsbId) throws PersistentModelParseException, AbstractQingIntegratedException, SQLException, EncryptedLicenseCheckException {
        InputStream dsbStream = this.loadDashboardStream(dsbId);
        if (dsbStream == null) {
            return null;
        }
        return DashboardSerializationUtil.toModel(dsbStream);
    }

    public InputStream loadDashboardStream(String dsbId) throws AbstractQingIntegratedException, SQLException {
        byte[] dsbBytes = this.readBlock("SELECT FCONTENT FROM T_QING_Dsb_Content WHERE FDSBID=? ORDER BY FCONTENTINDEX ASC", new Object[]{dsbId});
        if (dsbBytes == null) {
            return null;
        }
        return BoxUtil.parseByteToInputStream(dsbBytes);
    }

    private byte[] readBlock(String sql, Object[] params) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    do {
                        try {
                            os.write(rs.getBytes("FCONTENT"));
                        }
                        catch (IOException e) {
                            LogUtil.error((String)e.getMessage(), (Throwable)e);
                        }
                    } while (rs.next());
                    return os.toByteArray();
                }
                return null;
            }
        });
    }

    public void deleteDsbContent(String dsbId) throws AbstractQingIntegratedException, SQLException {
        if (dsbId != null) {
            this.dbExcuter.execute("DELETE FROM T_QING_Dsb_Content WHERE FDsbID=?", new Object[]{dsbId});
        }
    }

    public void deleteDsbRef(String dsbId, String uid) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_REF_CONTENT WHERE FDSBID=? AND FREFUID=?", new Object[]{dsbId, uid});
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_REF WHERE FDSBID=? AND FUID=?", new Object[]{dsbId, uid});
    }

    public void deleteDashboard(String dsbId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_Content WHERE FDsbID=?", new Object[]{dsbId});
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_REF_CONTENT WHERE FDSBID=? ", new Object[]{dsbId});
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_REF WHERE FDSBID=?", new Object[]{dsbId});
    }

    public void updateRef(ReferenceMap ref) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{ref.getRefToId(), ref.getRefToFullPath(), ref.getUid(), ref.get((Object)"dsbId")};
        this.dbExcuter.execute("UPDATE T_QING_Dsb_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FUID = ? AND FDSBID = ?", param);
    }

    public void updateOutSideRef(String mapId, String fId) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Dsb_REF SET FRefToId = ?, FFullPath = ? WHERE FID = ?", param);
    }

    public List<String> loadRefListByRefToIdAndRefType(String refToId, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId, FUID,FRefToId,FFullPath,FRefType,FDsbId FROM T_QING_Dsb_REF WHERE FRefToId = ? AND FRefType = ?", new Object[]{refToId, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FID"));
                }
                return refIds;
            }
        });
    }

    public List<ReferenceMap> loadRefListByRefToId(String refToId, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        String refTypeCondition = refType + "%";
        return (List)this.dbExcuter.query("SELECT R.FID,FUID,FRefToId,FFullPath,FRefType,FDsbId FROM T_QING_Dsb_REF R left join T_QING_THEME TH ON R.FDsbId = TH.FID WHERE R.FRefToId = ? AND R.FRefType LIKE ? AND TH.FUserId = ?", new Object[]{refToId, refTypeCondition, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    refItem.put((Object)"id", (Object)rs.getString("FID"));
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"dsbId", (Object)rs.getString("FDsbId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<ReferenceMap> loadRefListByFullPath(String fullPath, String refType, String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FRefToId,FFullPath,FRefType,FDsbId FROM T_QING_Dsb_REF R left join T_QING_THEME TH ON R.FDsbId = TH.FID WHERE R.FFullPath = ? AND R.FRefType LIKE ? AND TH.FUserId = ?", new Object[]{fullPath, refType, userId}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"dsbId", (Object)rs.getString("FDsbId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public List<String> getDsbRelativeIdForExport(String dsbId, String refType) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT DISTINCT FREFTOID FROM T_QING_DSB_REF WHERE FDSBID = ? AND FREFTYPE = ?";
        Object[] param = new Object[]{dsbId, refType};
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refToId = new ArrayList<String>(10);
                while (rs.next()) {
                    refToId.add(rs.getString("FRefToId"));
                }
                return refToId;
            }
        });
    }

    public List<ReferenceMap> loadRefList(String userId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FRefToId,FFullPath,FRefType,FDsbId FROM T_QING_Dsb_Ref DSBREF left join T_QING_Theme theme on DSBREF.FDsbId = theme.FId WHERE theme.FUserId=? AND DSBREF.FFullPath is not null AND DSBREF.FFullPath !=' ' AND DSBREF.FRefType != ?", new Object[]{userId, this.refType}, (ResultHandler)new ResultHandler<List<ReferenceMap>>(){

            public List<ReferenceMap> handle(ResultSet rs) throws SQLException {
                ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
                while (rs.next()) {
                    ReferenceMap refItem = new ReferenceMap();
                    String fileKey = UUID.randomUUID().toString();
                    refItem.setUid(rs.getString("FUID"));
                    refItem.setRefToFullPath(rs.getString("FFullPath"));
                    refItem.setRefType(rs.getString("FRefType"));
                    refItem.setRefToId(rs.getString("FRefToId"));
                    refItem.put((Object)"dsbId", (Object)rs.getString("FDsbId"));
                    refItem.setFileKey(fileKey);
                    refItems.add(refItem);
                }
                return refItems;
            }
        });
    }

    public int getRefTimeOfImage(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (Integer)this.dbExcuter.query("SELECT FID FROM T_QING_Dsb_REF WHERE FRefToId = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int refTimes = 0;
                while (rs.next()) {
                    ++refTimes;
                }
                return refTimes;
            }
        });
    }

    public List<OutsideReference> loadSchemaRef(String fId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FUID,FRefToId,FFullPath,FRefType FROM T_QING_Dsb_Ref WHERE FDsbId = ?", new Object[]{fId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(rs.getString("FRefType"));
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public List<OutsideReference> loadExecutionSchemaRef(String fId, int type) throws AbstractQingIntegratedException, SQLException {
        String sqlContent;
        switch (type) {
            case 0: {
                sqlContent = "SELECT FUID,FRefToId,FFullPath,FRefType FROM T_QING_PUB_DSB_REF WHERE fpublishid = ?";
                break;
            }
            case 1: {
                sqlContent = "SELECT FREFUID AS FUID,FREFTOID,FFULLPATH,FREFTYPE FROM T_QING_TP_DSB_REF WHERE fsourceid=?";
                break;
            }
            default: {
                sqlContent = "SELECT FUID,FRefToId,FFullPath,FRefType FROM T_QING_Dsb_Ref WHERE FDsbId = ?";
            }
        }
        return (List)this.dbExcuter.query(sqlContent, new Object[]{fId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(rs.getString("FRefType"));
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void deleteOuterRef(String fId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Dsb_Ref WHERE FDSBID = ?", new Object[]{fId});
    }

    public List<String> loadRefListByFullPathWidthoutUserId(String fullPath, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FId,FUID,FRefToId,FFullPath,FRefType,FDsbId FROM T_QING_Dsb_REF WHERE FFullPath = ? AND FRefToId =' ' AND FRefType = ?", new Object[]{fullPath, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FID"));
                }
                return refIds;
            }
        });
    }

    public void updateRefToIdByRefId(String fId, String mapId) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Dsb_REF SET FRefToId = ?, FFullPath = ? WHERE FId = ?", param);
    }

    public void updateRefFullPathByRefId(String fId, String mapPath) throws SQLException, AbstractQingIntegratedException {
        Object[] param = new Object[]{" ", mapPath, fId};
        this.dbExcuter.execute("UPDATE T_QING_Dsb_REF SET FRefToId = ?, FFullPath = ? WHERE FId = ?", param);
    }
}

