/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.exception.DashboardEncryptedLicenseException;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.ModelBookTemporaryStorageException;
import com.kingdee.bos.qing.dashboard.exception.NotSelectMapException;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.manage.domain.ThemeDomain;
import com.kingdee.bos.qing.manage.domain.ThemeGroupDomain;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.FolderNode;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishInfoWithPersonName;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.analysiscenter.domain.AnalysisCenterRuntimeDomain;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.AnalysisCenterException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterMenuVO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class CommonDsbDesignDomain {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    protected IScheduleEngine scheduleEngine;
    private SchemaManageDao SchemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;
    private SubjectManageDomain subjectManageDomain;
    private PublishInfoDao publishInfoDao;
    private ThemeDomain themeDomain;
    private ThemeGroupDomain themeGroupDomain;
    private AnalysisCenterRuntimeDomain analisiCenterRuntimeDomain;
    private MapManageDao mapManageDao;
    private DashboardDao dashboardDao;
    private CommonPublishDomain commonPublishDomain;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;

    public CommonDsbDesignDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    protected SchemaManageDao getSchemaManageDao() {
        if (this.SchemaManageDao == null) {
            this.SchemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.SchemaManageDao;
    }

    protected ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    protected DashboardDao getDashboardDao() {
        if (this.SchemaManageDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.subjectManageDomain;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private ThemeDomain getThemeDomain() {
        if (this.themeDomain == null) {
            this.themeDomain = new ThemeDomain(this.qingContext, this.dbExcuter);
        }
        return this.themeDomain;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    protected IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new EnumMap<RefTypeEnum, IRefHandler>(RefTypeEnum.class);
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.qingContext, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private ThemeGroupDomain getThemeGroupDomain() {
        if (this.themeGroupDomain == null) {
            this.themeGroupDomain = new ThemeGroupDomain();
            this.themeGroupDomain.setDbExcuter(this.dbExcuter);
            this.themeGroupDomain.setQingContext(this.qingContext);
            this.themeGroupDomain.setTx(this.tx);
        }
        return this.themeGroupDomain;
    }

    private AnalysisCenterRuntimeDomain getAnalisiCenterRuntimeDomain() {
        if (this.analisiCenterRuntimeDomain == null) {
            this.analisiCenterRuntimeDomain = new AnalysisCenterRuntimeDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.analisiCenterRuntimeDomain;
    }

    public FolderNode getAllSubject(String userID) throws AbstractQingIntegratedException, DashboardException {
        FolderNode root = new FolderNode();
        try {
            List<ThemeGroupVO> themeGroupList = this.getThemeGroupDomain().getUserVisibleThemeGroups();
            for (int i = 0; i < themeGroupList.size(); ++i) {
                ThemeGroupVO themeGroupVO = themeGroupList.get(i);
                FolderNode themeGroupNode = new FolderNode();
                themeGroupNode.setName(themeGroupVO.getThemeGroupName());
                themeGroupNode.setPreset(themeGroupVO.isPreset());
                List<ThemeVO> themeVOList = this.getThemeDomain().listThemesUnionPreset(userID, themeGroupVO.getThemeGroupID(), "0");
                for (int j = 0; j < themeVOList.size(); ++j) {
                    FolderNode themeNode = new FolderNode();
                    themeNode.setName(themeVOList.get(j).getThemeName());
                    themeNode.setThemeId(themeVOList.get(j).getThemeID());
                    themeNode.setPreset(themeVOList.get(j).isPreset());
                    themeGroupNode.addChild(themeNode);
                }
                if (themeVOList.size() <= 0) continue;
                root.addChild(themeGroupNode);
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        return root;
    }

    public boolean checkExtreportPermission() throws DashboardException {
        try {
            return IntegratedHelper.checkExtreportPermission((QingContext)this.qingContext);
        }
        catch (IntegratedRuntimeException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public Map<String, Object> loadAnalysisCenterExtreportGroup() throws AbstractQingIntegratedException, DashboardException {
        try {
            return this.getAnalisiCenterRuntimeDomain().loadAnalysisCenterExtreportGroup();
        }
        catch (AnalysisCenterException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public ArrayList<SchemaAttrVO> loadSubjectSchemaAttrs(String userId, String themeID, int source) throws AbstractQingIntegratedException, DashboardException {
        try {
            Box box = this.getSubjectManageDomain().loadModel(userId, themeID);
            if (box == null || box != null && box.getEntities().size() == 0) {
                return null;
            }
            return this.loadSchemaAttrs(userId, themeID, source);
        }
        catch (SubjectDataModelingException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public ArrayList<SchemaAttrVO> loadSchemaAttrs(String userId, String bizTag, int source) throws AbstractQingIntegratedException, DashboardException {
        try {
            ArrayList<SchemaBO> listBO = this.getSchemaManageDao().loadSchemaAttrs(bizTag, userId, source);
            ArrayList<SchemaAttrVO> listVO = new ArrayList<SchemaAttrVO>();
            for (SchemaBO schemaBO : listBO) {
                SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                schemaAttrVO.setfId(schemaBO.getfId());
                schemaAttrVO.setSchemaName(schemaBO.getSchemaName());
                schemaAttrVO.setSchemaType(schemaBO.getSchemaType());
                schemaAttrVO.setIsDefault(schemaBO.IsDefault());
                schemaAttrVO.setSource(schemaBO.getSource());
                listVO.add(schemaAttrVO);
            }
            return listVO;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public Map<String, Object> getReferenceMap(Map<String, String> params, RefTypeEnum refType) throws AbstractQingException {
        Map<String, Object> result = this.getRefHandler(refType).createReference(params);
        String refToId = params.get("refToId");
        if (refToId != null && PublishUtil.isPublish((String)refToId)) {
            try {
                result.put("operation", this.getCommonPublishDomain().loadPublishOperList(refToId, null, true, false));
            }
            catch (SQLException e) {
                LogUtil.error((String)"load publish oper auth error", (Throwable)e);
            }
        }
        return result;
    }

    public Map<String, Object> getPublishReferenceMap(Map<String, String> params, String publishType) throws DashboardException, AbstractQingException, PersistentModelParseException, PersistentModelTooModernException {
        Map<String, Object> result = new HashMap<String, Object>();
        String refToId = params.get("refToId");
        try {
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
            if (publishPO != null) {
                if (PublishSourceEnum.subject == publishPO.getPublishSourceType()) {
                    ThemePO themePO = this.getThemeDomain().getThemeByID(publishPO.getTagId());
                    if (themePO != null) {
                        Box box = this.getSubjectManageDomain().loadModel(themePO.getUserID(), publishPO.getTagId());
                        if (box == null || box != null && box.getEntities().size() == 0) {
                            result.put("noModeling", Boolean.TRUE);
                        } else {
                            result = this.getReferenceMap(params, RefTypeEnum.valueOf((String)publishType));
                        }
                    } else {
                        result.put("noTheme", Boolean.TRUE);
                    }
                } else {
                    result = this.getReferenceMap(params, RefTypeEnum.valueOf((String)publishType));
                }
                if (PublishUtil.isPublish((String)refToId)) {
                    HashMap<String, Object> publishOperMapResult = new HashMap<String, Object>(4);
                    publishOperMapResult.put("operation", this.getCommonPublishDomain().loadPublishOperList(refToId, null, true, false));
                    publishOperMapResult.put("scene", "longer");
                    result.put("operation", publishOperMapResult);
                }
            }
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (SubjectDataModelingException e) {
            throw new DashboardException((Throwable)e);
        }
        return result;
    }

    public Map<String, Object> loadAnalysisCenterGroupForDsb() throws AbstractQingIntegratedException, DashboardException {
        try {
            return this.getAnalisiCenterRuntimeDomain().loadAnalysisCenterGroupForDsb("square");
        }
        catch (AnalysisCenterException e) {
            throw new DashboardException((Throwable)e);
        }
    }

    public List<PublishInfoWithPersonName> loadSubjectPublishInfo(List<QingCenterMenuVO> qingCenterMenuVOs) throws AbstractQingIntegratedException, DashboardException {
        ArrayList<PublishInfoWithPersonName> publishInfoWithPersonNames = new ArrayList<PublishInfoWithPersonName>(qingCenterMenuVOs.size());
        for (int i = 0; i < qingCenterMenuVOs.size(); ++i) {
            QingCenterMenuVO qingCenterMenuVO = qingCenterMenuVOs.get(i);
            PublishInfoWithPersonName publishInfoWithPersonName = new PublishInfoWithPersonName();
            String userId = qingCenterMenuVO.getUserId();
            String publishPersonName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
            qingCenterMenuVO.setUserId(null);
            publishInfoWithPersonName.setQingCenterMenuVO(qingCenterMenuVO);
            publishInfoWithPersonName.setPublishPersonName(publishPersonName);
            publishInfoWithPersonNames.add(publishInfoWithPersonName);
        }
        return publishInfoWithPersonNames;
    }

    public Map<String, Boolean> checkPublishCanUseOrNot(String publishId) throws DashboardException, AbstractQingIntegratedException {
        try {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO != null) {
                if (PublishSourceEnum.subject == publishPO.getPublishSourceType()) {
                    ThemePO themePO = this.getThemeDomain().getThemeByID(publishPO.getTagId());
                    if (themePO != null) {
                        Box box = this.getSubjectManageDomain().loadModel(themePO.getUserID(), publishPO.getTagId());
                        if (box == null || box != null && box.getEntities().size() == 0) {
                            result.put("noModeling", Boolean.TRUE);
                        } else {
                            result.put("canUse", Boolean.TRUE);
                        }
                    } else {
                        result.put("noTheme", Boolean.TRUE);
                    }
                } else {
                    result.put("canUse", Boolean.TRUE);
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (SubjectDataModelingException e) {
            throw new DashboardException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new DashboardEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    public void cacheSquareSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException, NotSelectMapException {
        String fileKey = referenceMap.getFileKey();
        List outsideRef = modelBook.pickReferences();
        for (int i = 0; i < outsideRef.size(); ++i) {
            String uid = ((OutsideReference)outsideRef.get(i)).getUid();
            if (uid != null) continue;
            throw new NotSelectMapException();
        }
        if (modelBook.pickReferences() != null) {
            DashboardModelUtil.cacheOuterRef(referenceMap, modelBook.pickReferences());
        }
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
        byte[] byteContent = XmlUtil.toByteArray((Element)modelBook.toXml());
        dashboardCache.setValue(byteContent);
        try {
            dashboardCache.save();
        }
        catch (IOException e) {
            throw new ModelBookTemporaryStorageException(e);
        }
    }

    public void cacheLongerSchema(ReferenceMap referenceMap, ModelBook modelBook) throws ModelBookTemporaryStorageException {
        String fileKey = referenceMap.getFileKey();
        DashboardModelBookCache dashboardCache = new DashboardModelBookCache(fileKey);
        byte[] byteContent = XmlUtil.toByteArray((Element)modelBook.toXml());
        dashboardCache.setValue(byteContent);
        try {
            dashboardCache.save();
        }
        catch (IOException e) {
            throw new ModelBookTemporaryStorageException(e);
        }
    }

    public void fixOutSideRefName(List<OutsideReference> outerRefList) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outerRefList.size(); ++i) {
            OutsideReference outerRef = outerRefList.get(i);
            String mapId = outerRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().loadMap(mapId);
            outerRef.setRefName(mapVO.getMapName());
        }
    }
}

