/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.PictureSwitchPathAndIdHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.imagelibrary.dao.ImageLibraryDao;
import com.kingdee.bos.qing.imagelibrary.domian.ImageLibraryDomain;
import com.kingdee.bos.qing.imagelibrary.exception.GroupDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageFileSizeLimitException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageNotFoundException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageTypeException;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeFileSizeLimitException;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.AbstractExportRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.DsbPictureProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportThemeVO;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

class PictureHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable,
ITimingPushable {
    private ImageLibraryDomain imageLibraryDomain;
    private ImageLibraryDao imageLibraryDao;
    private List<String> cacheExportPic;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private static final String CACHE_IMPORT_PICTURE_SUFFIX = "_dsbPicture";
    private static final String CACHE_EXPORT_PICTURE = "cacheExportPic";

    public PictureHandler() {
        this.setRefType(RefTypeEnum.picture);
    }

    private ImageLibraryDomain getImageLibraryDomain() {
        if (this.imageLibraryDomain == null) {
            this.imageLibraryDomain = new ImageLibraryDomain();
            this.imageLibraryDomain.setDbExcuter(this.dbExcuter);
            this.imageLibraryDomain.setQingContext(this.context);
            this.imageLibraryDomain.setTx(this.tx);
        }
        return this.imageLibraryDomain;
    }

    private ImageLibraryDao getImageLibraryDao() {
        if (this.imageLibraryDao == null) {
            this.imageLibraryDao = new ImageLibraryDao(this.dbExcuter);
        }
        return this.imageLibraryDao;
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new PictureSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    @Override
    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
    }

    @Override
    public ReferenceMap createRefMap(String refToId) {
        ReferenceMap refMap = new ReferenceMap();
        String uid = UUID.randomUUID().toString();
        refMap.setUid(uid);
        refMap.setRefToId(refToId);
        refMap.setRefType(RefTypeEnum.picture.name());
        try {
            PathModel pathModel = this.getImageLibraryDao().getPathModel(refToId, this.context.getUserId());
            if (pathModel != null) {
                pathModel.setNameSpace(NameSpace.user.toPersistance());
                refMap.setRefToFullPath(JsonUtil.encodeToString((Object)pathModel));
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"load image path error", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"load image path error", (Throwable)e);
        }
        return refMap;
    }

    @Override
    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        String dsbWidgetId = refMap.getUid();
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)refMap.getRefToId());
        if (file.exists()) {
            refMap.setRefToFullPath(null);
        } else {
            refMap.setRefToId(null);
        }
        super.getDashboardDao().deleteDsbRef(dsbId, dsbWidgetId);
        super.getDashboardDao().saveRefInfo(refMap, dsbId);
    }

    @Override
    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        String dsbWidgetId = refMap.getUid();
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)refMap.getRefToId());
        if (file.exists()) {
            refMap.setRefToFullPath(null);
        } else {
            refMap.setRefToId(null);
        }
        this.getDashboardPublishDao().deleteRefAndContent(publishId, dsbWidgetId);
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
    }

    @Override
    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
    }

    @Override
    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().saveRefInfo(refMap, toDsbId);
    }

    @Override
    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardDao().deleteDsbRef(dsbId, refMap.getUid());
    }

    @Override
    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
        this.getDashboardPublishDao().deleteRefAndContent(publishId, refUid);
    }

    @Override
    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException, QingImglibException {
        byte[] imageContent = null;
        String refToId = (String)referenceMap.get((Object)"refToId");
        String uid = (String)referenceMap.get((Object)"uid");
        String refType = (String)referenceMap.get((Object)"refType");
        String pictureFolder = dsbFolderPath + File.separator + "qing-dsb-picture";
        if (this.cacheExportPic == null) {
            this.cacheExportPic = new ArrayList<String>();
        }
        try {
            imageContent = this.getImageLibraryDomain().loadImage(refToId);
        }
        catch (ImageNotFoundException e) {
            LogUtil.error((String)("ImageNotFoundException fileName:" + refToId), (Throwable)((Object)e));
        }
        ImageModel imageModel = this.getImageLibraryDomain().loadImageModel(refToId);
        if (imageContent != null && imageModel != null && !imageModel.isPreset()) {
            String categoryName = this.getImageLibraryDomain().getCategoryName(refToId);
            String pictureFolderUuid = UUID.randomUUID().toString();
            DsbPictureProperty dsbPictureProperty = new DsbPictureProperty();
            String nameSpace = imageModel.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            dsbPictureProperty.setCategoryName(categoryName);
            dsbPictureProperty.setImageName(imageModel.getImageName());
            dsbPictureProperty.setRefType(refType);
            dsbPictureProperty.setUid(uid);
            dsbPictureProperty.setNameSpace(nameSpace);
            Element dsbPictureElement = dsbPictureProperty.toXml();
            zos.putNextEntry(new ZipEntry(pictureFolder + File.separator + pictureFolderUuid + File.separator + "qing-dsb-picture.xml"));
            XmlUtil.save((Element)dsbPictureElement, (OutputStream)zos);
            zos.putNextEntry(new ZipEntry(pictureFolder + File.separator + pictureFolderUuid + File.separator + "qing-dsb-ref-picture"));
            zos.write(imageContent);
            this.cacheExportPic.add((String)referenceMap.get((Object)"fullPath"));
            IQingSession session = QingSessionUtil.getQingSessionImpl();
            session.set(CACHE_EXPORT_PICTURE, JsonUtil.encodeToString(this.cacheExportPic));
        }
    }

    @Override
    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws QingImglibException, AbstractQingIntegratedException, IOException {
        ArrayList<String> cacheExportPic = (ArrayList<String>)JsonUtil.decodeFromString((String)QingSessionUtil.get((String)CACHE_EXPORT_PICTURE), List.class);
        if (cacheExportPic == null) {
            cacheExportPic = new ArrayList<String>();
        }
        String picturePath = folderPath + File.separator + dashboardExportFilePathGetter.getPictureFileInZip();
        String pictureProperty = folderPath + File.separator + dashboardExportFilePathGetter.getPicturePropertyFileNameInZip();
        String refToId = (String)refMap.get((Object)"refToId");
        String imagePath = (String)refMap.get((Object)"fullPath");
        ImageModel imageModel = this.getImageLibraryDomain().loadImageModel(refToId);
        if (cacheExportPic.indexOf(imagePath) == -1 && imageModel != null && !imageModel.isPreset()) {
            String categoryName = this.getImageLibraryDomain().getCategoryName(refToId);
            String nameSpace = imageModel.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
            DsbPictureProperty dsbPictureProperty = new DsbPictureProperty();
            dsbPictureProperty.setCategoryName(categoryName);
            dsbPictureProperty.setImageName(imageModel.getImageName());
            dsbPictureProperty.setRefType((String)refMap.get((Object)"refType"));
            dsbPictureProperty.setUid((String)refMap.get((Object)"uid"));
            dsbPictureProperty.setNameSpace(nameSpace);
            Element dsbPictureElement = dsbPictureProperty.toXml();
            zos.putNextEntry(new ZipEntry(pictureProperty));
            XmlUtil.save((Element)dsbPictureElement, (OutputStream)zos);
            byte[] imageContent = null;
            try {
                imageContent = this.getImageLibraryDomain().loadImage(refToId);
            }
            catch (ImageNotFoundException e) {
                LogUtil.error((String)"ImageNotFoundException: ", (Throwable)((Object)e));
            }
            if (imageContent != null) {
                zos.putNextEntry(new ZipEntry(picturePath));
                zos.write(imageContent);
            }
            cacheExportPic.add(imagePath);
            IQingSession session = QingSessionUtil.getQingSessionImpl();
            session.set(CACHE_EXPORT_PICTURE, JsonUtil.encodeToString(cacheExportPic));
        }
    }

    @Override
    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws QingImglibException, AbstractQingIntegratedException, SQLException, IOException {
        Map<String, String> importPicture = this.importPicture(dsbImportModel, successImportFile);
        ExportDsbRefProperty dsbRefProperty = dsbImportModel.getDsbRefProperty();
        List<Map<String, String>> refList = dsbRefProperty.getReference();
        for (int j = 0; j < refList.size(); ++j) {
            Map<String, String> refInfo = refList.get(j);
            String newRefToId = null;
            if (RefTypeEnum.picture != RefTypeEnum.valueOf((String)refInfo.get("refType"))) continue;
            ReferenceMap item = new ReferenceMap();
            String fullPath = refInfo.get("fullPath");
            String uid = refInfo.get("uid");
            item.setRefType(refInfo.get("refType"));
            item.setUid(uid);
            fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
            if (importPicture.get(fullPath) != null) {
                item.setRefToId(importPicture.get(fullPath));
                item.setRefToFullPath(null);
            } else {
                String[] path = fullPath.split("/");
                String nameSpace = path[0];
                String groupName = path[1];
                String refSourceName = path[2];
                String userId = this.context.getUserId();
                if (nameSpace.equals(NameSpace.system.toPersistance())) {
                    if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
                        userId = IntegratedHelper.getPresetUserId();
                        newRefToId = this.getSwitchPathAndIdHandler().switchRefPathToId(groupName, refSourceName, userId);
                    }
                } else {
                    newRefToId = this.getSwitchPathAndIdHandler().switchRefPathToId(groupName, refSourceName, userId);
                }
                if (newRefToId != null) {
                    fullPath = null;
                }
                item.setRefToId(newRefToId);
                item.setRefToFullPath(fullPath);
            }
            this.getDashboardDao().saveRefInfo(item, dsbId);
        }
    }

    @Override
    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dsbImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws ImportThemeException, AbstractQingIntegratedException {
        Map<String, String> importPic = this.saveImportImage(dsbImportModel, dashboardPublishImportModel, successImportFile);
        ExportDsbRefProperty dsbRef = dashboardPublishImportModel.getDsbRefProperty();
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>();
        if (dsbRef != null) {
            List<Map<String, String>> refList = dsbRef.getReference();
            int c = refList.size();
            for (int j = 0; j < c; ++j) {
                Map<String, String> ref = refList.get(j);
                String newRefToId = null;
                if (RefTypeEnum.picture != RefTypeEnum.valueOf((String)ref.get("refType"))) continue;
                ReferenceMap item = new ReferenceMap();
                String fullPath = ref.get("fullPath");
                item.setFileKey(ref.get("fileKey"));
                item.setUid(ref.get("uid"));
                item.setRefType(ref.get("refType"));
                fullPath = ImportUtil.getFullPathWithNameSpace(fullPath);
                String imageFileName = importPic.get(fullPath);
                if (imageFileName != null) {
                    item.setRefToFullPath(null);
                    item.setRefToId(imageFileName);
                } else {
                    String[] path = fullPath.split("/");
                    String nameSpace = path[0];
                    String groupName = path[1];
                    String refSourceName = path[2];
                    String userId = this.context.getUserId();
                    try {
                        if (nameSpace.equals(NameSpace.system.toPersistance())) {
                            if (IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.context, (IDBExcuter)this.dbExcuter)) {
                                userId = IntegratedHelper.getPresetUserId();
                                newRefToId = this.getSwitchPathAndIdHandler().switchRefPathToId(groupName, refSourceName, userId);
                            }
                        } else {
                            newRefToId = this.getSwitchPathAndIdHandler().switchRefPathToId(groupName, refSourceName, userId);
                        }
                    }
                    catch (SQLException e) {
                        throw new ImportThemeException(e);
                    }
                    if (newRefToId != null) {
                        fullPath = null;
                    }
                    item.setRefToId(newRefToId);
                    item.setRefToFullPath(fullPath);
                }
                refItems.add(item);
            }
        }
        return refItems;
    }

    private Map<String, String> importPicture(DashboardImportModel exportDashboardCollectModel, List<IQingFile> successImportFile) throws AbstractQingIntegratedException, SQLException, GroupDuplicateNameException, ImageTypeException, ImageFileSizeLimitException, IOException {
        HashMap<String, String> categoryNames = new HashMap<String, String>();
        IQingFileVisitor zipFile = exportDashboardCollectModel.getZipFile();
        List<AbstractExportRefProperty> picturePropertys = exportDashboardCollectModel.getContentProperties(this.refType);
        List<String> pictureFileKeys = exportDashboardCollectModel.getFileKeys(this.refType);
        HashMap<String, String> importPicFileName = (HashMap<String, String>)JsonUtil.decodeFromString((String)QingSessionUtil.get((String)(zipFile.getName() + CACHE_IMPORT_PICTURE_SUFFIX)), Map.class);
        String userId = this.context.getUserId();
        if (importPicFileName == null) {
            importPicFileName = new HashMap<String, String>();
        }
        String sourceStrategy = exportDashboardCollectModel.getSourceStrategy();
        ExportThemeVO.StrategyType strategyEnum = ExportThemeVO.StrategyType.valueOf(sourceStrategy);
        boolean insertCategory = false;
        if (picturePropertys != null && pictureFileKeys != null) {
            for (int i = 0; i < picturePropertys.size(); ++i) {
                String fId;
                DsbPictureProperty pictureProperty = (DsbPictureProperty)picturePropertys.get(i);
                String pictureFileKey = pictureFileKeys.get(i);
                String categoryName = pictureProperty.getCategoryName();
                String imageName = pictureProperty.getImageName();
                String imagePath = categoryName + "/" + imageName;
                String imageFileName = (String)importPicFileName.get(imagePath);
                if (null != imageFileName) continue;
                String categoryId = null;
                if (categoryNames.get(categoryName) == null) {
                    categoryId = this.getImageLibraryDao().getCategoryIdByName(categoryName, userId);
                    if (categoryId == null) {
                        categoryId = this.getImageLibraryDao().saveOrUpdateCategory(userId, null, categoryName);
                        insertCategory = true;
                    }
                    categoryNames.put(categoryName, categoryId);
                } else {
                    categoryId = (String)categoryNames.get(categoryName);
                }
                boolean imageNameDuplicate = this.getImageLibraryDao().checkImageNameDuplicate(userId, imageName, categoryId);
                if (imageNameDuplicate) {
                    if (ExportThemeVO.StrategyType.ignore == strategyEnum) {
                        if (!insertCategory) continue;
                        insertCategory = false;
                        categoryNames.remove(categoryName);
                        this.getImageLibraryDao().deleteCategory(categoryId, userId);
                        continue;
                    }
                    if (ExportThemeVO.StrategyType.rename == strategyEnum) {
                        fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                        imageFileName = this.saveImage(successImportFile, categoryId, pictureFileKey, imageName, fId);
                    } else if (ExportThemeVO.StrategyType.overwrite == strategyEnum) {
                        ImageModel imageModel = this.getImageLibraryDao().loadModelByImageNameAndCategoryName(categoryName, imageName, userId);
                        String imageId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                        String oldFileName = null;
                        if (imageModel != null) {
                            imageId = imageModel.getId();
                            oldFileName = imageModel.getImageFileName();
                            this.getImageLibraryDomain().deleteImageFile(imageModel.getImageFileName());
                            this.getImageLibraryDomain().deleteImageFile(imageModel.getThumbnailFileName());
                            this.getImageLibraryDao().deleteImage(imageId, userId);
                        }
                        imageFileName = this.saveImage(successImportFile, categoryId, pictureFileKey, imageName, imageId);
                        if (oldFileName != null) {
                            List<ReferenceMap> oldFileNamePublishRef = this.getDashboardPublishDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                            int len = oldFileNamePublishRef.size();
                            for (int j = 0; j < len; ++j) {
                                ReferenceMap ref = oldFileNamePublishRef.get(j);
                                this.getDashboardPublishDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                            }
                            List<ReferenceMap> oldFileNameRef = this.getDashboardDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                            int len2 = oldFileNameRef.size();
                            for (int j = 0; j < len2; ++j) {
                                ReferenceMap ref = oldFileNameRef.get(j);
                                this.getDashboardDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                            }
                            List<ReferenceMap> oldFileNameEmailTimingPushRef = this.getDsbTimingPushDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                            int len3 = oldFileNameEmailTimingPushRef.size();
                            for (int j = 0; j < len3; ++j) {
                                ReferenceMap ref = oldFileNameEmailTimingPushRef.get(j);
                                this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                            }
                            List<ReferenceMap> oldFileNameRobotTimingPushRef = this.getDsbTimingPushDao().loadRobotPushRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                            int len4 = oldFileNameRobotTimingPushRef.size();
                            for (int j = 0; j < len4; ++j) {
                                ReferenceMap ref = oldFileNameRobotTimingPushRef.get(j);
                                this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                            }
                        }
                    }
                } else {
                    fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                    imageFileName = this.saveImage(successImportFile, categoryId, pictureFileKey, imageName, fId);
                }
                importPicFileName.put(imagePath, imageFileName);
            }
        }
        IQingSession session = QingSessionUtil.getQingSessionImpl();
        session.set(zipFile.getName() + CACHE_IMPORT_PICTURE_SUFFIX, JsonUtil.encodeToString(importPicFileName));
        return importPicFileName;
    }

    private String saveImage(List<IQingFile> successImportFile, String categoryId, String pictureFileKey, String imageName, String imageId) throws ImageTypeException, ImageFileSizeLimitException, AbstractQingIntegratedException, SQLException, IOException {
        String userId = this.context.getUserId();
        ImageModel imageModel = new ImageModel();
        imageModel.setId(imageId);
        imageModel.setCategoryId(categoryId);
        imageModel.setUserId(userId);
        imageModel.setImageName(imageName);
        imageModel.setImageFileName(pictureFileKey);
        IQingFile thumbnailFileNameP = this.getImageLibraryDomain().createImageFile(imageName + "_thumbnail", imageId, true);
        IQingFile imageFileNameP = this.getImageLibraryDomain().createImageFile(imageName, imageId, false);
        successImportFile.add(thumbnailFileNameP);
        successImportFile.add(imageFileNameP);
        this.getImageLibraryDomain().saveImageInfoWithNoTX(imageModel, thumbnailFileNameP, imageFileNameP);
        return imageModel.getImageFileName();
    }

    private Map<String, String> saveImportImage(DashboardImportModel dashboardImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> saveSuccessFiles) throws AbstractQingIntegratedException, ImportThemeException {
        HashMap<String, String> categoryNames = new HashMap<String, String>();
        String fileName = dashboardImportModel.getZipFile().getName();
        List<AbstractExportRefProperty> dsbPictureProperty = dashboardPublishImportModel.getContentProperties(this.refType);
        List<String> dsbPictureFileKey = dashboardPublishImportModel.getFileKeys(this.refType);
        HashMap<String, String> cacheImportPic = (HashMap<String, String>)JsonUtil.decodeFromString((String)QingSessionUtil.get((String)(fileName + CACHE_IMPORT_PICTURE_SUFFIX)), Map.class);
        if (cacheImportPic == null) {
            cacheImportPic = new HashMap<String, String>();
        }
        String sourceStrategy = dashboardImportModel.getSourceStrategy();
        ExportThemeVO.StrategyType strategyEnum = ExportThemeVO.StrategyType.valueOf(sourceStrategy);
        boolean insertCategory = false;
        try {
            if (dsbPictureProperty != null && dsbPictureFileKey != null) {
                for (int i = 0; i < dsbPictureProperty.size(); ++i) {
                    String fId;
                    DsbPictureProperty pictureProperty = (DsbPictureProperty)dsbPictureProperty.get(i);
                    String pictureFileKey = dsbPictureFileKey.get(i);
                    String categoryName = pictureProperty.getCategoryName();
                    String imageName = pictureProperty.getImageName();
                    String categoryId = null;
                    String userId = this.context.getUserId();
                    String imagePath = categoryName + "/" + imageName;
                    if (cacheImportPic.get(imagePath) != null) continue;
                    if (categoryNames.get(categoryName) == null) {
                        categoryId = this.getImageLibraryDao().getCategoryIdByName(categoryName, userId);
                        if (categoryId == null) {
                            categoryId = this.getImageLibraryDao().saveOrUpdateCategory(userId, null, categoryName);
                            insertCategory = true;
                        }
                        categoryNames.put(categoryName, categoryId);
                    } else {
                        categoryId = (String)categoryNames.get(categoryName);
                    }
                    String imageFileName = null;
                    boolean imageNameDuplicate = this.getImageLibraryDao().checkImageNameDuplicate(userId, imageName, categoryId);
                    if (imageNameDuplicate) {
                        if (ExportThemeVO.StrategyType.ignore == strategyEnum) {
                            if (!insertCategory) continue;
                            insertCategory = false;
                            categoryNames.remove(categoryName);
                            this.getImageLibraryDao().deleteCategory(categoryId, userId);
                            continue;
                        }
                        if (ExportThemeVO.StrategyType.rename == strategyEnum) {
                            fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                            imageFileName = this.saveImage(saveSuccessFiles, categoryId, pictureFileKey, imageName, fId);
                        } else if (ExportThemeVO.StrategyType.overwrite == strategyEnum) {
                            ImageModel imageModel = this.getImageLibraryDao().loadModelByImageNameAndCategoryName(categoryName, imageName, userId);
                            String imageId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                            String oldFileName = null;
                            if (imageModel != null) {
                                imageId = imageModel.getId();
                                oldFileName = imageModel.getImageFileName();
                                this.getImageLibraryDomain().deleteImageFile(imageModel.getImageFileName());
                                this.getImageLibraryDomain().deleteImageFile(imageModel.getThumbnailFileName());
                                this.getImageLibraryDao().deleteImage(imageId, userId);
                            }
                            imageFileName = this.saveImage(saveSuccessFiles, categoryId, pictureFileKey, imageName, imageId);
                            if (oldFileName != null) {
                                List<ReferenceMap> oldFileNameRef = this.getDashboardDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                                int len = oldFileNameRef.size();
                                for (int j = 0; j < len; ++j) {
                                    ReferenceMap ref = oldFileNameRef.get(j);
                                    this.getDashboardDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                                }
                                List<ReferenceMap> oldFileNamePublishRef = this.getDashboardPublishDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                                int len2 = oldFileNamePublishRef.size();
                                for (int j = 0; j < len2; ++j) {
                                    ReferenceMap ref = oldFileNamePublishRef.get(j);
                                    this.getDashboardPublishDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                                }
                                List<ReferenceMap> oldFileNameEmailTimingPushRef = this.getDsbTimingPushDao().loadRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                                int len3 = oldFileNameEmailTimingPushRef.size();
                                for (int j = 0; j < len3; ++j) {
                                    ReferenceMap ref = oldFileNameEmailTimingPushRef.get(j);
                                    this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                                }
                                List<ReferenceMap> oldFileNameRobotTimingPushRef = this.getDsbTimingPushDao().loadRobotPushRefListByRefToId(oldFileName, RefTypeEnum.picture.name(), userId);
                                int len4 = oldFileNameRobotTimingPushRef.size();
                                for (int j = 0; j < len4; ++j) {
                                    ReferenceMap ref = oldFileNameRobotTimingPushRef.get(j);
                                    this.getDsbTimingPushDao().updateRefToIdByRefId((String)ref.get((Object)"id"), imageFileName);
                                }
                            }
                        }
                    } else {
                        fId = this.dbExcuter.genStringId("T_QING_IMGLIB_IMG_INFO");
                        imageFileName = this.saveImage(saveSuccessFiles, categoryId, pictureFileKey, imageName, fId);
                    }
                    if (imageFileName == null) continue;
                    cacheImportPic.put(imagePath, imageFileName);
                }
            }
            if (cacheImportPic != null) {
                IQingSession session = QingSessionUtil.getQingSessionImpl();
                session.set(fileName + CACHE_IMPORT_PICTURE_SUFFIX, JsonUtil.encodeToString(cacheImportPic));
            }
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
        catch (ImageFileSizeLimitException e) {
            throw new ImportThemeFileSizeLimitException((Throwable)((Object)e));
        }
        catch (GroupDuplicateNameException e) {
            throw new ImportThemeException((Throwable)((Object)e));
        }
        catch (QingImglibException e) {
            throw new ImportThemeException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new ImportThemeException(e);
        }
        return cacheImportPic;
    }

    @Override
    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
    }

    @Override
    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)refMap.getRefToId());
        if (file.exists()) {
            refMap.setRefToFullPath(null);
        } else {
            refMap.setRefToId(null);
        }
        this.getDashboardPublishDao().saveRefInfo(refMap, publishId);
    }

    @Override
    public void saveTimingPushReference(String dashboardUniqueId, String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)refItem.getRefToId());
        if (file.exists()) {
            refItem.setRefToFullPath(null);
        } else {
            refItem.setRefToId(null);
        }
        this.getDsbTimingPushDao().saveRefInfo(sourceId, sourceType, refItem);
    }

    @Override
    public void updateTimingPushReference(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException {
        String refUid = refItem.getUid();
        IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)refItem.getRefToId());
        if (file.exists()) {
            refItem.setRefToFullPath(null);
        } else {
            refItem.setRefToId(null);
        }
        this.getDsbTimingPushDao().deleteRefAndContent(sourceId, refUid, sourceType);
        this.getDsbTimingPushDao().saveRefInfo(sourceId, sourceType, refItem);
    }

    @Override
    public void deleteTimingPushReference(String sourceId, ReferenceMap refMap, int sourceType) throws AbstractQingIntegratedException, SQLException {
        this.getDsbTimingPushDao().deleteRefAndContent(sourceId, refMap.getUid(), sourceType);
    }

    @Override
    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws SubjectModelParseException, PublishedPrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
    }

    @Override
    public String loadRefFullPath(ReferenceMap refItem, String userId) throws AbstractQingIntegratedException, SQLException {
        String refToId = refItem.getRefToId();
        String categoryName = this.getImageLibraryDao().getCategoryName(refToId);
        ImageModel imageModel = this.getImageLibraryDao().loadImageModel(refToId);
        if (categoryName != null && imageModel != null) {
            return categoryName + "/" + imageModel.getImageName();
        }
        return null;
    }

    @Override
    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    @Override
    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
    }

    @Override
    public void exportSource(String refTag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException {
    }

    @Override
    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
    }

    @Override
    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) {
        return null;
    }
}

