/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.reference.impl;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.AbstractRefHandler;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IExImportable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.ITimingPushable;
import com.kingdee.bos.qing.dashboard.reference.impl.ExtreportAppHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.QingRefHandler;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.imexport.importer.exception.ImportException;
import com.kingdee.bos.qing.imexport.importer.qhf.model.datasourceinfovo.AbstractDataSourceInfoVO;
import com.kingdee.bos.qing.imexport.model.ImportedModel;
import com.kingdee.bos.qing.imexport.model.PackageMeta;
import com.kingdee.bos.qing.manage.domain.AbstractThemeManageDomain;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.handler.AnalysisCenterSwitchPathAndIdHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.jdom2.JDOMException;

class QingCenterHandler
extends AbstractRefHandler
implements IExImportable,
IPublishable,
IExImportPublishable,
ITimingPushable,
IPrepareDataable {
    private AnalysisCenterDAO analysisCenterDAO;
    private PublishInfoDao publishInfoDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private static final String SCHEMA_CACHE_SUFFIX = "_qingcenter";
    private CommonPublishDomain commonPublishDomain;
    private Map<RefTypeEnum, AbstractRefHandler> refHandlerMap = new HashMap<RefTypeEnum, AbstractRefHandler>(3);

    public QingCenterHandler(RefTypeEnum refType) {
        this.setRefType(refType);
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.context, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    protected String getSchemaCacheSuffix() {
        return SCHEMA_CACHE_SUFFIX;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private AbstractRefHandler getRefHandler(RefTypeEnum refType) {
        if (this.refHandlerMap.get(refType) == null) {
            AbstractRefHandler refHandler = refType == RefTypeEnum.qingcenter_rpt ? new ExtreportAppHandler(RefTypeEnum.qingcenter_rpt) : (refType == RefTypeEnum.qingcenter_qing ? new QingRefHandler(RefTypeEnum.qingcenter_qing) : new QingRefHandler(RefTypeEnum.qingcenter_qing));
            refHandler.setDbExcuter(this.dbExcuter);
            refHandler.setContext(this.context);
            refHandler.setTx(this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return this.refHandlerMap.get(refType);
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    @Override
    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new AnalysisCenterSwitchPathAndIdHandler(this.context, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    @Override
    public void saveOrUpdateReference(String dsbId, ReferenceMap refMap) throws DashboardException, AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.qingcenter) {
            this.getRefHandler(RefTypeEnum.qingcenter_rpt).saveOrUpdateReference(dsbId, refMap);
            this.getRefHandler(RefTypeEnum.qingcenter_qing).saveOrUpdateReference(dsbId, refMap);
        } else {
            this.getRefHandler(refType).saveOrUpdateReference(dsbId, refMap);
        }
    }

    @Override
    public void copyReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector) throws AbstractQingIntegratedException, SQLException {
        this.getRefHandler(this.getRealRefType(refMap)).copyReference(fromDsbId, toDsbId, refMap, rollbackCollector);
    }

    @Override
    public void copyExecutionReference(String fromDsbId, String toDsbId, ReferenceMap refMap, List<AbstractThemeManageDomain.IFileRollback> rollbackCollector, int type) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        this.getRefHandler(this.getRealRefType(refMap)).copyExecutionReference(fromDsbId, toDsbId, refMap, rollbackCollector, type);
    }

    @Override
    public void deleteReference(String dsbId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.qingcenter) {
            this.getRefHandler(RefTypeEnum.qingcenter_rpt).deleteReference(dsbId, refMap);
            this.getRefHandler(RefTypeEnum.qingcenter_qing).deleteReference(dsbId, refMap);
        } else {
            this.getRefHandler(refType).deleteReference(dsbId, refMap);
        }
    }

    @Override
    public String loadRefFullPath(ReferenceMap refItem, String userId) throws AbstractQingIntegratedException, SQLException {
        String refToId = refItem.getRefToId();
        String fullPath = null;
        PublishPO publishPO = this.getCommonPublishDomain().loadPublishInfo(refToId);
        if (publishPO != null) {
            String publishName = publishPO.getName();
            String fId = publishPO.getPath();
            fullPath = this.getAnalysisCenterDAO().findPublishNameByPath(fId) + "/" + publishName;
        }
        return fullPath;
    }

    @Override
    public ReferenceMap createRefMap(String refToId) throws AbstractQingException {
        return this.getRefHandler(this.getRealRefType(refToId)).createRefMap(refToId);
    }

    @Override
    public void addRefContent(Map<String, String> params, Map<String, Object> result) throws AbstractQingException {
        String refToId = params.get("refToId");
        this.getRefHandler(this.getRealRefType(refToId)).addRefContent(params, result);
    }

    @Override
    public void createPublishedCarryDataDataSource(String tag, PublishPO publishPO, ReferenceMap referenceMap) throws PrepareDataException, ModelParseException, AbstractQingIntegratedException, SQLException, IOException {
        this.getRefHandler(this.getRealRefType(referenceMap)).createPublishedCarryDataDataSource(tag, publishPO, referenceMap);
    }

    @Override
    public void exportPublishedRefContent(String publishId, String folderPath, ReferenceMap refMap, IDashboardExportFilePathGetter dashboardExportFilePathGetter, ZipOutputStream zos) throws IOException, SQLException, QingImglibException, AbstractQingIntegratedException {
        ((IExImportPublishable)((Object)this.getRefHandler(this.getRealRefType(refMap)))).exportPublishedRefContent(publishId, folderPath, refMap, dashboardExportFilePathGetter, zos);
    }

    @Override
    public List<ReferenceMap> importPublishedRefContent(String publishId, DashboardImportModel dsbImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> successImportFile) throws ImportThemeException, AbstractQingIntegratedException {
        List<ReferenceMap> refMapList = ((IExImportPublishable)((Object)this.getRefHandler(this.refType))).importPublishedRefContent(publishId, dsbImportModel, dashboardPublishImportModel, successImportFile);
        return refMapList;
    }

    @Override
    public void separateImportModel(DashboardPublishImportModel dsbPublishImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        ((IExImportPublishable)((Object)this.getRefHandler(this.refType))).separateImportModel(dsbPublishImportModel, dsbSchemaProperty, schemaFileKey);
    }

    @Override
    public void exportRefContent(String dsbId, String dsbFolderPath, boolean isPreset, ReferenceMap referenceMap, ZipOutputStream zos) throws IOException, AbstractQingIntegratedException, SQLException, QingImglibException {
        ((IExImportable)((Object)this.getRefHandler(this.getRealRefType(referenceMap)))).exportRefContent(dsbId, dsbFolderPath, isPreset, referenceMap, zos);
    }

    @Override
    public void importRefContent(String dsbId, DashboardImportModel dsbImportModel, List<IQingFile> successImportFile) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, QingImglibException, IOException {
        ((IExImportable)((Object)this.getRefHandler(this.refType))).importRefContent(dsbId, dsbImportModel, successImportFile);
    }

    @Override
    public void exportSource(String tag, ReferenceMap referenceMap, PackageMeta meta) throws AbstractQingException, SQLException, IOException, JDOMException {
        ((IExImportable)((Object)this.getRefHandler(this.getRealRefType(referenceMap)))).exportSource(tag, referenceMap, meta);
    }

    @Override
    public void separateImportModel(DashboardImportModel dsbImportModel, ExportDsbSchemaProperty dsbSchemaProperty, String schemaFileKey) {
        ((IExImportable)((Object)this.getRefHandler(this.refType))).separateImportModel(dsbImportModel, dsbSchemaProperty, schemaFileKey);
    }

    @Override
    public void cacheQHFDataSource(String refTag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        ((IExImportable)((Object)this.getRefHandler(this.getRealRefType(referenceMap)))).cacheQHFDataSource(refTag, referenceMap, importedModel);
    }

    @Override
    public AbstractDataSourceInfoVO getQHFDataSourceInfo(String tag, ReferenceMap referenceMap, ImportedModel importedModel) throws ImportException {
        return ((IExImportable)((Object)this.getRefHandler(this.getRealRefType(referenceMap)))).getQHFDataSourceInfo(tag, referenceMap, importedModel);
    }

    @Override
    public String getPrepareDataTag(String tag, String refToId) throws AbstractQingIntegratedException, SQLException {
        return ((IPrepareDataable)((Object)this.getRefHandler(this.getRealRefType(refToId)))).getPrepareDataTag(tag, refToId);
    }

    @Override
    public IPrepareDataContext getDataPrepareContext(String tag, String refToId, boolean isStartBySchedule, boolean isFirstFromCache, ProgressModel progressModel) {
        return ((IPrepareDataable)((Object)this.getRefHandler(this.getRealRefType(refToId)))).getDataPrepareContext(tag, refToId, isStartBySchedule, isFirstFromCache, progressModel);
    }

    @Override
    public AbstractPrepareDataHandler getDataPrepareHandler(IPrepareDataContext prepareDataContext) {
        return ((IPrepareDataable)((Object)this.getRefHandler(this.refType))).getDataPrepareHandler(prepareDataContext);
    }

    @Override
    public String getQHFUniqueRefId(String refToId, PackageMeta packageMeta) {
        return ((IPrepareDataable)((Object)this.getRefHandler(this.getRealRefType(refToId)))).getQHFUniqueRefId(refToId, packageMeta);
    }

    @Override
    public void savePublishReference(String dsbId, String publishId, ReferenceMap refMap, ModelBook modelBook) throws com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException, SQLException, AbstractQingIntegratedException {
        ((IPublishable)((Object)this.getRefHandler(this.getRealRefType(refMap)))).savePublishReference(dsbId, publishId, refMap, modelBook);
    }

    @Override
    public void deletePublishContent(String publishId) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(publishId);
        if (refType == RefTypeEnum.qingcenter) {
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_rpt))).deletePublishContent(publishId);
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_qing))).deletePublishContent(publishId);
        } else {
            ((IPublishable)((Object)this.getRefHandler(refType))).deletePublishContent(publishId);
        }
    }

    @Override
    public void updatePublishedRef(String publishId, ReferenceMap refMap) throws AbstractQingIntegratedException, SQLException, DashboardException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.qingcenter) {
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_rpt))).updatePublishedRef(publishId, refMap);
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_qing))).updatePublishedRef(publishId, refMap);
        } else {
            ((IPublishable)((Object)this.getRefHandler(refType))).updatePublishedRef(publishId, refMap);
        }
    }

    @Override
    public void deletePublishedRef(String publishId, String refUid, String refToId) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refToId);
        if (refType == RefTypeEnum.qingcenter) {
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_qing))).deletePublishedRef(publishId, refUid, refToId);
            ((IPublishable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_rpt))).deletePublishedRef(publishId, refUid, refToId);
        } else {
            ((IPublishable)((Object)this.getRefHandler(refType))).deletePublishedRef(publishId, refUid, refToId);
        }
    }

    @Override
    public void saveTimingPushReference(String dashboardUniqueId, String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, com.kingdee.bos.qing.core.exception.PersistentModelParseException, PersistentModelTooModernException {
        ((ITimingPushable)((Object)this.getRefHandler(this.getRealRefType(refItem)))).saveTimingPushReference(dashboardUniqueId, sourceId, sourceType, refItem);
    }

    @Override
    public void updateTimingPushReference(String sourceId, int sourceType, ReferenceMap refItem) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException {
        RefTypeEnum refType = this.getRealRefType(refItem);
        if (refType == RefTypeEnum.qingcenter) {
            ((ITimingPushable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_qing))).updateTimingPushReference(sourceId, sourceType, refItem);
            ((ITimingPushable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_rpt))).updateTimingPushReference(sourceId, sourceType, refItem);
        } else {
            ((ITimingPushable)((Object)this.getRefHandler(refType))).updateTimingPushReference(sourceId, sourceType, refItem);
        }
    }

    @Override
    public void deleteTimingPushReference(String sourceId, ReferenceMap refMap, int sourceType) throws AbstractQingIntegratedException, SQLException {
        RefTypeEnum refType = this.getRealRefType(refMap);
        if (refType == RefTypeEnum.qingcenter) {
            ((ITimingPushable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_rpt))).deleteTimingPushReference(sourceId, refMap, sourceType);
            ((ITimingPushable)((Object)this.getRefHandler(RefTypeEnum.qingcenter_qing))).deleteTimingPushReference(sourceId, refMap, sourceType);
        } else {
            ((ITimingPushable)((Object)this.getRefHandler(refType))).deleteTimingPushReference(sourceId, refMap, sourceType);
        }
    }

    private RefTypeEnum getRealRefType(ReferenceMap referenceMap) {
        if (this.refType == RefTypeEnum.qingcenter) {
            try {
                PublishPO publishPO;
                DashboardModelBookCache dashboardCache = new DashboardModelBookCache(referenceMap.getFileKey());
                if (dashboardCache.exists()) {
                    referenceMap.setRefType(RefTypeEnum.qingcenter_qing.toPersistance());
                } else if (null != referenceMap.getRefToId() && null != this.getPublishInfoDao() && (publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(referenceMap.getRefToId())) != null) {
                    if (PublishSourceEnum.extreport == publishPO.getPublishSourceType()) {
                        referenceMap.setRefType(RefTypeEnum.qingcenter_rpt.toPersistance());
                    } else {
                        referenceMap.setRefType(RefTypeEnum.qingcenter_qing.toPersistance());
                    }
                }
                return RefTypeEnum.fromPersistance((String)referenceMap.getRefType());
            }
            catch (Exception e) {
                return RefTypeEnum.fromPersistance((String)referenceMap.getRefType());
            }
        }
        return this.refType;
    }

    private RefTypeEnum getRealRefType(String refToId) {
        if (this.refType == RefTypeEnum.qingcenter) {
            try {
                PublishPO publishPO;
                if (null != refToId && null != this.getPublishInfoDao() && (publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId)) != null) {
                    if (PublishSourceEnum.extreport == publishPO.getPublishSourceType()) {
                        return RefTypeEnum.qingcenter_rpt;
                    }
                    return RefTypeEnum.qingcenter_qing;
                }
                return this.refType;
            }
            catch (Exception e) {
                return this.refType;
            }
        }
        return this.refType;
    }
}

